/*
 * GQradio
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef IO_PRESET_H
#define IO_PRESET_H


#define PRESET_LIST_SIZE 40


void preset_list_init(gint size);
void preset_list_clear(void);
gint preset_list_find_free_slot(void);

gint preset_set(gint index, guint32 freq, const gchar *description);
gint preset_set_by_path(gint index, const gchar *path);
gint preset_clear(gint index);

guint32 preset_get_freq(gint index);
const gchar *preset_get_description(gint index);
gint preset_find_freq(guint32 freq);

gint preset_is_freq(gint index, guint32 freq);
gint preset_is_set(gint index);

gint preset_list_save(const gchar *path);
gint preset_list_load(const gchar *path);


#endif
