/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.services;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.configurationcache.extensions.CastExtensionsKt;
import org.gradle.configurationcache.extensions.MapExtensionsKt;
import org.gradle.initialization.Environment;
import org.gradle.util.internal.GUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gradle/configurationcache/services/DefaultEnvironment;", "Lorg/gradle/initialization/Environment;", "()V", "getSystemProperties", "Lorg/gradle/initialization/Environment$Properties;", "getVariables", "propertiesFile", "", "", "Ljava/io/File;", "DefaultProperties", "configuration-cache"})
public class DefaultEnvironment
implements Environment {
    @Nullable
    public Map<String, String> propertiesFile(@NotNull File propertiesFile) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        if (propertiesFile.isFile()) {
            Properties properties = GUtil.loadProperties((File)propertiesFile);
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"loadProperties(propertiesFile)");
            map = (Map)CastExtensionsKt.uncheckedCast(properties);
        } else {
            map = null;
        }
        return map;
    }

    @NotNull
    public Environment.Properties getSystemProperties() {
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties()");
        return new DefaultProperties((Map)CastExtensionsKt.uncheckedCast(properties));
    }

    @NotNull
    public Environment.Properties getVariables() {
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        return new DefaultProperties(map);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/gradle/configurationcache/services/DefaultEnvironment$DefaultProperties;", "Lorg/gradle/initialization/Environment$Properties;", "map", "", "", "(Ljava/util/Map;)V", "getMap", "()Ljava/util/Map;", "byNamePrefix", "prefix", "configuration-cache"})
    public static class DefaultProperties
    implements Environment.Properties {
        @NotNull
        private final Map<String, String> map;

        public DefaultProperties(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final Map<String, String> getMap() {
            return this.map;
        }

        @NotNull
        public Map<String, String> byNamePrefix(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return MapExtensionsKt.filterKeysByPrefix(this.map, prefix);
        }
    }
}

