#! /usr/bin/perl -w
# 2003 by Genius

use Tk;
use StreamDVD::Defs;
use StreamDVD::Config;
use StreamDVD::Calc;
use StreamDVD::Title;
use StreamDVD::Project;
use StreamDVD::Util;
use StreamDVD::Gui;
use strict;


my $CONF = new StreamDVD::Config;                    # configuration data
my $PROJECT;                                         # project data
my @TITLE;                                           # Title list
my $GUI;                                             # main gui data objects

my $conf_ok = 0;




if( $CONF->load() ) {                                # check if settings could be loaded
   $conf_ok = 1; }

$GUI = new StreamDVD::Gui($CONF, $conf_ok);          # Fire up GUI

MainLoop();



################################################################################
# this stuff is called by the gui

sub new_project {                                    # give new project object to gui
   my ($name, $dir) = @_;
   $PROJECT = new StreamDVD::Project($name, $dir);
   return $PROJECT;
}



sub new_titlelist {                                  # give title list array to gui
   return \@TITLE;
}



sub dvd_probe {                                      # probe for dvd titleset
   my ($ref_text) = @_;
   return DVD_Probe($CONF, $PROJECT, \@TITLE, $ref_text);
}



sub dvd_analyze {                                    # analyze stream sizes and calc factor
   my ($titlenum, $ref_text) = @_;
   return DVD_Analyze($CONF, $PROJECT, $TITLE[$titlenum], $ref_text);
}



sub dvd_build {                                      # recode video streams
   my ($titlenum, $ref_text) = @_;
   return DVD_Build($CONF, $PROJECT, $TITLE[$titlenum], $ref_text);
}



sub dvd_image {                                      # create an iso image
   my ($titlenum, $ref_text) = @_;
   return DVD_Image($CONF, $PROJECT, $TITLE[$titlenum], $ref_text);
}



sub dvd_burn {                                       # write movie data to DVD
   my ($titlenum, $ref_text) = @_;
   return DVD_Burn($CONF, $PROJECT, $TITLE[$titlenum], $ref_text);
}



sub save_stream_data {                               # save chapter times, stream languages etc. to ptoject
   my ($titlenum) = @_;
   Save_Stream_Data($CONF, $PROJECT, $TITLE[$titlenum]);
}



sub create_dir {                                     # create a directory
   my ($dir) = @_;
   return makedir($dir);
}





################################################################################
# this stuff is called by other functions

sub gui_refresh {                                    # refresh gui display
   $GUI->refresh();
}



