# Part of the StreamDVD project
package StreamDVD::Config;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


use StreamDVD::Defs;
$VERSION = '0.1';

sub new {                                                  # create new config object
   my $class = shift;
   my $self = bless {}, $class;
   $self->_init();
   return $self;
}



sub burn {                                                 # get/set if burning should be done
   my $self = shift;
   my ($value) = @_;
   $self->{BURN} = $value if(defined $value);
   return $self->{BURN};
}



sub reader {                                               # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{READER} = $value if(defined $value);
   return $self->{READER};
}



sub writer {                                               # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{WRITER} = $value if(defined $value);
   return $self->{WRITER};
}



sub mount {                                                # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{MOUNT} = $value if(defined $value);
   return $self->{MOUNT};
}



sub temp_dir {                                             # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{TEMPDIR} = $value if(defined $value);
   return $self->{TEMPDIR};
}



sub data_dir {                                             # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{DATADIR} = $value if(defined $value);
   return $self->{DATADIR};
}



sub lsdvd {                                                # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{LSDVD} = $value if(defined $value);
   return $self->{LSDVD};
}



sub streamanalyze {                                        # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{STREAMANALYZE} = $value if(defined $value);
   return $self->{STREAMANALYZE};
}



sub streamdvd {                                            # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{STREAMDVD} = $value if(defined $value);
   return $self->{STREAMDVD};
}



sub dvdauthor {                                            # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{DVDAUTHOR} = $value if(defined $value);
   return $self->{DVDAUTHOR};
}



sub mkisofs {                                              # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{MKISOFS} = $value if(defined $value);
   return $self->{MKISOFS};
}



sub growisofs {                                            # get/set config value
   my $self = shift;
   my ($value) = @_;
   $self->{GROWISOFS} = $value if(defined $value);
   return $self->{GROWISOFS};
}



sub dialog {                                               # show change-settings-gui
   my $self = shift;
   my ($GUI) = @_;                                              # need parent tk gui object for display
   my %guidata;                                                 # config values
   my %guiprog;                                                 # program fields
   my $pass_color = "green";
   my $fail_color = "red";

   foreach my $key (keys %$self) {
      $guidata{$key} = $self->{$key}; }

   my $Wsetting = $GUI->Toplevel(-title=>"Settings");

   my $FRMoption = $Wsetting->LabFrame(-label=>"Options", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMburn = $FRMoption->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMburn->Label(-text=>"Write DVD: ", -width=>15)->pack(-side=>"left");
   $FRMburn->Checkbutton(-variable=>\$guidata{BURN})->pack(-side=>"left");

   my $FRMdvd = $Wsetting->LabFrame(-label=>"DVD Reader/Writer", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMreader = $FRMdvd->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMreader->Label(-text=>"Reader Device: ", -width=>15)->pack(-side=>"left");
   $FRMreader->Entry(-textvariable => \$guidata{READER}, -width=>20)->pack(-side=>"left");

   my $FRMmount = $FRMdvd->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMmount->Label(-text=>"Mountpoint: ", -width=>15)->pack(-side=>"left");
   $FRMmount->Entry(-textvariable => \$guidata{MOUNT}, -width=>20)->pack(-side=>"left");

   my $FRMwriter = $FRMdvd->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMwriter->Label(-text=>"Writer Devide: ", -width=>15)->pack(-side=>"left");
   $FRMwriter->Entry(-textvariable => \$guidata{WRITER}, -width=>20)->pack(-side=>"left");


   my $FRMfiles = $Wsetting->LabFrame(-label=>"Directories", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMtemp = $FRMfiles->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMtemp->Label(-text=>"Temp. :", -width=>15)->pack(-side=>"left");
   $FRMtemp->Entry(-textvariable => \$guidata{TEMPDIR}, -width=>20)->pack(-side=>"left");

   my $FRMsave = $FRMfiles->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMsave->Label(-text=>"Data :", -width=>15)->pack(-side=>"left");
   $FRMsave->Entry(-textvariable => \$guidata{DATADIR}, -width=>20)->pack(-side=>"left");


   my $FRMprog = $Wsetting->LabFrame(-label=>"Programs", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMstreamdvd = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMstreamdvd->Label(-text=>"streamdvd: ", -width=>15)->pack(-side=>"left");
   $guiprog{STREAMDVD} = $FRMstreamdvd->Entry(-textvariable => \$guidata{STREAMDVD}, -width=>20)->pack(-side=>"left");

   my $FRMstreamanalyze = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMstreamanalyze->Label(-text=>"streamanalyze: ", -width=>15)->pack(-side=>"left");
   $guiprog{STREAMANALYZE} = $FRMstreamanalyze->Entry(-textvariable => \$guidata{STREAMANALYZE}, -width=>20)->pack(-side=>"left");

   my $FRMlsdvd = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMlsdvd->Label(-text=>"lsdvd: ", -width=>15)->pack(-side=>"left");
   $guiprog{LSDVD} = $FRMlsdvd->Entry(-textvariable => \$guidata{LSDVD}, -width=>20)->pack(-side=>"left");

   my $FRMauthor = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMauthor->Label(-text=>"dvdauthor: ", -width=>15)->pack(-side=>"left");
   $guiprog{DVDAUTHOR} = $FRMauthor->Entry(-textvariable => \$guidata{DVDAUTHOR}, -width=>20)->pack(-side=>"left");

   my $FRMmkisofs = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMmkisofs->Label(-text=>"mkisofs: ", -width=>15)->pack(-side=>"left");
   $guiprog{MKISOFS} = $FRMmkisofs->Entry(-textvariable => \$guidata{MKISOFS}, -width=>20)->pack(-side=>"left");

   my $FRMgrowisofs = $FRMprog->Frame(-borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMgrowisofs->Label(-text=>"growisofs: ", -width=>15)->pack(-side=>"left");
   $guiprog{GROWISOFS} = $FRMgrowisofs->Entry(-textvariable => \$guidata{GROWISOFS}, -width=>20)->pack(-side=>"left");

   my $FRMbutton = $Wsetting->Frame(-borderwidth=>2)->pack(-side=>"bottom", -expand=>1, -fill=>"x");
   $FRMbutton->Button(-text=>"Cancel",-command=>sub { $GUI->Unbusy; $Wsetting->destroy; } )->pack(-side=>"left");
   $FRMbutton->Button(-text=>"Save",-command=>sub 
      { 
         foreach my $key (keys %guidata) {
            $self->{$key} = $guidata{$key}; }
         $self->_save();
         $GUI->Unbusy;
         $Wsetting->destroy; 
      } )->pack(-side=>"left");
   $FRMbutton->Button(-text=>"Check Programs",-command=>sub 
      {
         foreach my $key (keys %guiprog) {
            if( $self->checkprog($guidata{$key}) ) {
               $guiprog{$key}->configure(-background=>$pass_color); }
            else {
               $guiprog{$key}->configure(-background=>$fail_color); }
         }
      } )->pack(-side=>"right");

   $GUI->Busy;
   $Wsetting->waitWindow();
}



sub checkprog {                                            # check if a program is present
   my $self = shift;
   my ($prog) = @_;
   my $ok = 0;
   my $path = `which $prog`;
   chomp $path;

   $ok = 1 if( -x $path);

   return $ok;
}



sub load {                                                 # load config data from file
   my $self = shift;
   my $ok = 0;

   if( open CONFFILE, $self->{FILE} ) {
      while( <CONFFILE> ) {
         if( /^(\S+)=(.*)/ ) {
            $self->{$1} = $2;
            chomp $self->{$1};
         }
      }
      close(CONFFILE);
      $ok = 1;
   }

   return $ok;
}



sub _save {                                                # save config data to file
   my $self = shift;
   my $ok = 0;

   if( open CONFFILE, ">".$self->{FILE} ) {
      foreach my $key (keys %$self) {
         print( CONFFILE "$key=$self->{$key}\n"); }
      $ok = 1;
      close(CONFFILE);
   }

   return $ok;
}



sub _init {                                                # initialize config data
   my $self = shift;

   $self->{FILE}           = CONFIG_FILE;
   $self->{READER}         = "/dev/dvd";
   $self->{WRITER}         = "/dev/scd0";
   $self->{MOUNT}          = "/dvd";
   $self->{TEMPDIR}        = "/tmp";
   $self->{DATADIR}        = $ENV{HOME};
   $self->{LSDVD}          = "lsdvd";
   $self->{STREAMANALYZE}  = "streamanalyze";
   $self->{STREAMDVD}      = "streamdvd";
   $self->{DVDAUTHOR}      = "dvdauthor";
   $self->{MKISOFS}        = "mkisofs";
   $self->{GROWISOFS}      = "growisofs";
   $self->{BURN}           = 0;
}



1;

