/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class AbstractStreamOpen
implements Nonza {
    public static final String ETHERX_JABBER_STREAMS_NAMESPACE = "http://etherx.jabber.org/streams";
    public static final String CLIENT_NAMESPACE = "jabber:client";
    public static final String SERVER_NAMESPACE = "jabber:server";
    public static final String VERSION = "1.0";
    protected final String from;
    protected final String to;
    protected final String id;
    protected final String lang;
    protected final String contentNamespace;

    public AbstractStreamOpen(CharSequence to, CharSequence from, String id, String lang) {
        this(to, from, id, lang, StreamOpen.StreamContentNamespace.client);
    }

    public AbstractStreamOpen(CharSequence to, CharSequence from, String id, String lang, StreamOpen.StreamContentNamespace ns) {
        this.to = StringUtils.maybeToString(to);
        this.from = StringUtils.maybeToString(from);
        this.id = id;
        this.lang = lang;
        switch (ns) {
            case client: {
                this.contentNamespace = CLIENT_NAMESPACE;
                break;
            }
            case server: {
                this.contentNamespace = SERVER_NAMESPACE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected final void addCommonAttributes(XmlStringBuilder xml) {
        xml.optAttribute("to", this.to);
        xml.optAttribute("version", VERSION);
    }
}

