/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ConditionHandler;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.handler.TriggerHandler;
import org.openhab.core.automation.internal.ModuleImpl;
import org.openhab.core.automation.internal.RuleEngineImpl;
import org.openhab.core.automation.internal.composite.AbstractCompositeModuleHandler;
import org.openhab.core.automation.internal.composite.CompositeActionHandler;
import org.openhab.core.automation.internal.composite.CompositeConditionHandler;
import org.openhab.core.automation.internal.composite.CompositeTriggerHandler;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.util.ReferenceResolver;
import org.openhab.core.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class CompositeModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ModuleHandlerFactory {
    private final ModuleTypeRegistry mtRegistry;
    private final RuleEngineImpl ruleEngine;
    private final Logger logger = LoggerFactory.getLogger(CompositeModuleHandlerFactory.class);

    public CompositeModuleHandlerFactory(ModuleTypeRegistry mtRegistry, RuleEngineImpl re) {
        this.mtRegistry = mtRegistry;
        this.ruleEngine = re;
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    public Collection<String> getTypes() {
        return new ArrayList<String>();
    }

    @Override
    public void ungetHandler(Module module, String childModulePrefix, ModuleHandler handler) {
        ModuleHandler handlerOfModule = this.getHandlers().get(this.getModuleIdentifier(childModulePrefix, module.getId()));
        if (handlerOfModule instanceof AbstractCompositeModuleHandler) {
            AbstractCompositeModuleHandler h = (AbstractCompositeModuleHandler)handlerOfModule;
            for (Map.Entry entry : h.moduleHandlerMap.entrySet()) {
                ModuleHandlerFactory mhf;
                ModuleImpl child = (ModuleImpl)entry.getKey();
                ModuleHandler childHandler = (ModuleHandler)entry.getValue();
                if (childHandler == null || (mhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID())) == null) continue;
                mhf.ungetHandler(child, childModulePrefix + ":" + module.getId(), childHandler);
            }
        }
        String ruleId = this.getRuleId(childModulePrefix);
        super.ungetHandler(module, ruleId, handler);
    }

    private String getRuleId(String childModulePrefix) {
        int i = childModulePrefix.indexOf(58);
        return i != -1 ? childModulePrefix.substring(0, i) : childModulePrefix;
    }

    @Override
    public @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        Object handler = null;
        String moduleType = module.getTypeUID();
        ModuleType mt = (ModuleType)this.mtRegistry.get(moduleType);
        if (mt instanceof CompositeTriggerType) {
            CompositeTriggerType type = (CompositeTriggerType)mt;
            List<Trigger> childModules = type.getChildren();
            LinkedHashMap<Trigger, @Nullable TriggerHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
            if (mapModuleToHandler != null) {
                handler = new CompositeTriggerHandler((Trigger)module, type, mapModuleToHandler, ruleUID);
            }
        } else if (mt instanceof CompositeConditionType) {
            CompositeConditionType type = (CompositeConditionType)mt;
            List<Condition> childModules = type.getChildren();
            LinkedHashMap<Condition, @Nullable ConditionHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
            if (mapModuleToHandler != null) {
                handler = new CompositeConditionHandler((Condition)module, type, mapModuleToHandler, ruleUID);
            }
        } else if (mt instanceof CompositeActionType) {
            CompositeActionType type = (CompositeActionType)mt;
            List<Action> childModules = type.getChildren();
            LinkedHashMap<Action, @Nullable ActionHandler> mapModuleToHandler = this.getChildHandlers(module.getId(), module.getConfiguration(), childModules, ruleUID);
            if (mapModuleToHandler != null) {
                handler = new CompositeActionHandler((Action)module, type, mapModuleToHandler, ruleUID);
            }
        }
        if (handler != null) {
            this.logger.debug("Set module handler: {}  -> {} of rule {}.", new Object[]{module.getId(), handler.getClass().getSimpleName() + "(" + moduleType + ")", ruleUID});
        } else {
            this.logger.debug("Not found module handler {} for moduleType {} of rule {}.", new Object[]{module.getId(), moduleType, ruleUID});
        }
        return handler;
    }

    private <T extends Module, MT extends ModuleHandler> @Nullable LinkedHashMap<T, MT> getChildHandlers(String compositeModuleId, Configuration compositeConfig, List<T> childModules, String childModulePrefix) {
        LinkedHashMap<Module, ModuleHandler> mapModuleToHandler = new LinkedHashMap<Module, ModuleHandler>();
        for (Module child : childModules) {
            String ruleId = this.getRuleId(childModulePrefix);
            this.ruleEngine.updateMapModuleTypeToRule(ruleId, child.getTypeUID());
            ModuleHandlerFactory childMhf = this.ruleEngine.getModuleHandlerFactory(child.getTypeUID());
            if (childMhf == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            ReferenceResolver.updateConfiguration(child.getConfiguration(), compositeConfig.getProperties(), this.logger);
            ModuleHandler childHandler = childMhf.getHandler(child, childModulePrefix + ":" + compositeModuleId);
            if (childHandler == null) {
                mapModuleToHandler.clear();
                mapModuleToHandler = null;
                return null;
            }
            mapModuleToHandler.put(child, childHandler);
        }
        return mapModuleToHandler;
    }
}

