// search-methods.js - Code borrowed from php.net from the originalafter.js
// script.  Heavily modified to work as a multi-instance widget and to not
// do the compression hack (for now).
// http://php.net/search.php for original source code and example page.
// Code licensed under the PHP license as stated at
// http://www.php.net/search.php.
//
// Changes done by James A. Pattie <james@pcxperience.com>
// Copyright (c) 2005, Xperience, Inc.  http://www.pcxperience.com/


// Initialisation --------------------------------------------------------------

// how many matches to show at most (must be even!)
var sb_showmatches=29;

var isnotopera=true;

// keeps track of the current selections to show the user.
var sb_matches=new Array();
var sb_inmenu=0;
var sb_menupos=0;
var sb_matchcompleted=0;
var sb_matchesjoined="";
var sb_currenttext="";
var sb_keyrepeat=0;
var sb_lastkey="";

// associative array to keep track of the searchBoxes defined.
var sb_searchBoxes = new Array();

// keeps track of the last thing the searchBox did and what the
// current and last searchBoxes are.
var sb_lastAction = new Array();
var sb_lastField = "";
var sb_currField = "";

// bool searchBox(p, ph, data, dataIsSorted, dataIsAA, displayEmpty, displayHelp, onblurCallback, onfocusCallback)
// returns false if an error occured, else true.
//
// creates the searchBox object and stores it in the sb_searchBoxes array.
// arguments:
//   p = input field the user is interacting with.  The drop-down is displayed under this field.
//   ph = hidden field the users input/selection should be stored in after looking it up in
//     data.  If this field is specified, then the value from p.value will be
//     stored in ph.value prefixed with + (if p.value does not exist in data)
//     or = (if p.value does exist in data).
//     If you do not care to know wether the users input is new or not, or what the
//     actual value is, if dataIsAA = true, then do not specify ph.
//   data = array of strings the user can select from.
//   dataIsSorted = true if the data data is sorted, false if not.
//   dataIsAA = true if data is an associative array, = false if data is a normal array.
//   displayEmpty = true if we should display the available options when p.value = ''.
//   displayHelp = true if we should display the help link (?) after the input field.
//   onfocusCallback = javascript code you want run in the initial onblur event when
//     the searchBox has focus for the first time when coming from another field, etc.
//   onblurCallback = javascript code you want run in the onblur handler when we are
//     actually moving to another field and have not clicked in the drop-down.
//     Do not use alert()'s in this code since Mozilla will blow an error.
//
//   p and ph are checked to make sure they are valid fields we can work with.
//   p must be a text field.  ph must be a text or hidden field, if defined.
function searchBox(p, ph, data, dataIsSorted, dataIsAA, displayEmpty, displayHelp, onfocusCallback, onblurCallback)
{
    if (!p)
    {
      alert("searchBox: p must be defined and be a text field!");
      return false;
    }
    if (searchBoxExists(p.form.name + "." + p.name))
    {
      alert("searchBox: searchBox = '" + p.name + "' is already created!");
      return false;
    }
    if (p.type != "text")
    {
      alert("searchBox: p.type = '" + p.type + "' is invalid!\nMust be a text field.");
      return false;
    }
    if (ph && (ph.type != "text" && ph.type != "hidden"))
    {
      alert("searchBox: ph.type = '" + ph.type + "' is invalid!\nMust be a text or hidden field.");
      return false;
    }
    if (!data)
    {
      alert("searchBox: data must be defined and be an array or associative array!");
      return false;
    }

    sb_searchBoxes[p.form.name + "." + p.name] = new sb_searchBox(p, ph, data, dataIsSorted, dataIsAA, displayEmpty, displayHelp, onblurCallback, onfocusCallback);

    return true;
}

function sb_searchBox(p, ph, data, dataIsSorted, dataIsAA, displayEmpty, displayHelp, onblurCallback, onfocusCallback)
{
    this.p = p;
    this.ph = ph;
    this.d = p.ownerDocument;
    this.data = data;
    this.dataIsSorted = dataIsSorted;
    this.dataIsAA = dataIsAA;
    this.displayEmpty = displayEmpty;  // do we want the pop-up to be displayed when the edit field is empty?
    this.onblurCallback = onblurCallback;
    this.onfocusCallback = onfocusCallback;
    this.displayHelp = displayHelp;
    // create the div with id = to the name of the input field + SearchBox, so we can later remove it.
    this.theDIV = sb_CreateSearchDiv(this.d, p.form.name + "." + p.name + 'SearchBox');
    sb_DisableAutoComplete(this.p);

    if (this.displayHelp)
    {
        this.helpDIV = sb_CreateHelpDiv(this.d, p);
    }
    else
    {
        this.helpDIV = null;
    }

    // process the data associative array, if dataIsAA = true
    if (dataIsAA)
    {
        // walk the data associative array and create a standard array.
        this.lookupData = this.data;
        this.data = new Array();
        for (var i in this.lookupData)
        {
            this.data.push(i);
        }
        if (this.dataIsSorted)
        {
            this.data = this.data.sort();
        }
    }
    else
    {
        this.lookupData = null;
    }

    // save the old event handlers for restoring when this object is asked to be deleted.
    this.onkeypress = this.p.onkeypress;
    this.onkeydown = this.p.onkeydown;
    this.onkeyup = this.p.onkeyup;
    this.onfocus = this.p.onfocus;
    this.onblur = this.p.onblur;

    // now setup the event handlers we want running.
    this.p.onkeypress = sb_EKeyPress;
    this.p.onkeydown = sb_EKeyDown;
    this.p.onkeyup = sb_EKeyUp;
    this.p.onfocus = sb_EFocus;
    this.p.onblur = sb_EBlur;
}

// bool deleteSearchBox(name)
// returns false if an error occured, else true.
// pass in the name of the searchBox object that you want cleaned up
// and deleted. the div will be removed from the html document and the
// event handlers will be restored that were originally on the
// input field before createSearchBox() was called.
// The name is the formname.fieldname.  Ex: testing.testDisplay
function deleteSearchBox(b)
{
    if (!searchBoxExists(b))
    {
      //alert("deleteSearchBox: searchBox = '" + b + "' does not exist to be deleted!");
      return false;
    }
    try {
      eval("sb_deleteSearchBox(sb_searchBoxes['" + b + "']);");
    }
    catch (e) {
      alert(e);
      return false;
    }
    // try to delete the object.
    try {
      eval("delete sb_searchBoxes['" + b + "'];");
    }
    catch (e) {
      alert(e);
      return false;
    }

    return true;
}

// deleteSearchBoxes(pattern)
// specify a regular expression pattern that matches
// the searchBoxes you want deleted.
function deleteSearchBoxes(pattern)
{
    for (var i in sb_searchBoxes)
    {
        if (pattern.test(i))
        {
            deleteSearchBox(i);
        }
    }
}

function sb_deleteSearchBox(b)
{
    if (b.p)
    {
        // restore the old event handlers.
        b.p.onkeypress = b.onkeypress;
        b.p.onkeydown = b.onkeydown;
        b.p.onkeyup = b.onkeyup;
        b.p.onfocus = b.onfocus;
        b.p.onblur = b.onblur;
    }

    // remove the div from the html document.
    if (b.theDIV && b.theDIV.parentNode) b.theDIV.parentNode.removeChild(b.theDIV);

    // remove the help link, etc.
    if (b.displayHelp && b.helpDIV && b.helpDIV.parentNode) b.helpDIV.parentNode.removeChild(b.helpDIV);

    if (b.displayHelp && b.helpDIV) delete b.helpDIV;

    // free up the div
    if (b.theDIV) delete b.theDIV;

    if (b.p) sb_EnableAutoComplete(b.p);
}

// bool searchBoxExists(name)
// returns true if the specified searchBox exists in sb_searchBoxes,
// else returns false.
function searchBoxExists(name)
{
    if (sb_searchBoxes[name] != null)
    {
        return true;
    }
    return false;
}

// bool renameSearchBox(old, p, ph)
// returns false if an error occured, else true.
// moves the old searchBox entry to p.form.name + "." + p.name and updates
// p and ph in the new entry to point to the new field items
// so that the form items can be renamed, if needed and still
// have the searchBox functionality follow them.
function renameSearchBox(old, p, ph)
{
    if (!searchBoxExists(old))
    {
        alert("renameSearchBox: name = '" + old + "' does not exist!");
        return false;
    }
    if (!p)
    {
      alert("renameSearchBox: p must be defined and be a text field!");
      return false;
    }
    if (p.type != "text")
    {
      alert("renameSearchBox: p.type = '" + p.type + "' is invalid!\nMust be a text field.");
      return false;
    }
    if (ph && (ph.type != "text" && ph.type != "hidden"))
    {
      alert("renameSearchBox: ph.type = '" + ph.type + "' is invalid!\nMust be a text or hidden field.");
      return false;
    }
    var name = p.form.name + "." + p.name;
    if (searchBoxExists(name))
    {
        alert("renameSearchBox: name = '" + name + "' already created!");
        return false;
    }

    // copy the old to the new location.
    sb_searchBoxes[name] = sb_searchBoxes[old];

    // now delete the old entry.
    delete sb_searchBoxes[old];

    // now update the p and ph entries.
    sb_searchBoxes[name].p = p;
    sb_searchBoxes[name].ph = ph;

    // now backup and assign the event handlers on p.
    sb_searchBoxes[name].onkeypress = sb_searchBoxes[name].p.onkeypress;
    sb_searchBoxes[name].onkeydown = sb_searchBoxes[name].p.onkeydown;
    sb_searchBoxes[name].onkeyup = sb_searchBoxes[name].p.onkeyup;
    sb_searchBoxes[name].onfocus = sb_searchBoxes[name].p.onfocus;
    sb_searchBoxes[name].onblur = sb_searchBoxes[name].p.onblur;

    // now setup the event handlers we want running.
    sb_searchBoxes[name].p.onkeypress = sb_EKeyPress;
    sb_searchBoxes[name].p.onkeydown = sb_EKeyDown;
    sb_searchBoxes[name].p.onkeyup = sb_EKeyUp;
    sb_searchBoxes[name].p.onfocus = sb_EFocus;
    sb_searchBoxes[name].p.onblur = sb_EBlur;

    return true;
}

// bool updateSearchBoxData(name, data, dataIsSorted, dataIsAA)
// returns false if an error occured, else true.
// updates data and re-creates the normal array if dataIsAA = true.
// Allows you to swap out data arrays without having to delete
// and re-create the searchBox widget.  Will properly swap from
// normal array to associative array and the reverse.
function updateSearchBoxData(name, data, dataIsSorted, dataIsAA)
{
    if (!searchBoxExists(name))
    {
        alert("updateSearchBoxData: name = '" + name + "' does not exist!");
        return false;
    }

    if (!data)
    {
      alert("updateSearchBoxData: data must be defined and be an array or associative array!");
      return false;
    }

    delete sb_searchBoxes[name].data;
    delete sb_searchBoxes[name].lookupData;

    sb_searchBoxes[name].data = data;
    sb_searchBoxes[name].dataIsSorted = dataIsSorted;
    sb_searchBoxes[name].dataIsAA = dataIsAA;

    // process the data associative array, if dataIsAA = true
    if (dataIsAA)
    {
        // walk the data associative array and create a standard array.
        sb_searchBoxes[name].lookupData = sb_searchBoxes[name].data;
        sb_searchBoxes[name].data = new Array();
        for (var i in sb_searchBoxes[name].lookupData)
        {
            sb_searchBoxes[name].data.push(i);
        }
        if (dataIsSorted)
        {
            sb_searchBoxes[name].data = sb_searchBoxes[name].data.sort();
        }
    }
    else
    {
        sb_searchBoxes[name].lookupData = null;
    }

    return true;
}

// array getSearchBoxData(name)
// returns the data array from the named searchBox entry.
// returns null if the specified searchBox doesn't exist.
// Usefull if you want to know what array is being worked
// with before calling updateSearchBoxData().
function getSearchBoxData(name)
{
  if (!searchBoxExists(name))
  {
      return null;
  }
  return sb_searchBoxes[name].data;
}

// bool updateSearchBoxHandler(name, type, code)
// returns false if an error occured, else true.
// requires: name - searchBox to modify
//   type - 'onblurCallback', 'onfocusCallback'
//   code - code snippet to set the handler to.  Can be empty.
function updateSearchBoxHandler(name, type, code)
{
  if (!searchBoxExists(name))
  {
      return false;
  }
  if (type != "onblurCallback" && type != "onfocusCallback")
  {
      alert("type = '" + type + "' is invalid!");
      return false;
  }

  // make sure the ' quotes in the code are escaped.
  code = code.replace(/'/g, '\\\'');
  try {
      eval("sb_searchBoxes['" + name + "']." + type + "='" + code + "';");
  }
  catch (e) {
      alert(e);
      return false;
  }
  return true;
}

// array sb_parseResult(string)
// required:  string
// returns:   array
// summary:   This function takes the string generated by a search box
//            and splits it into its components which are then returned
//            as an array.  The input string must include + or = as the
//            first character to denote a new entry (+) or an already
//            existing entry (=)
//            Index 0 = the entire regular expression match.
//            Index 1 = the + or = character.
//            Index 2 = the users input
//            If the regular expression didn't match, it returns null.
function sb_parseResult(s)
{
    myregexp = /^(\+|=)(.+)$/;
    return myregexp.exec(s);
}

// Layer setup -----------------------------------------------------------------

function sb_CreateSearchDiv(d, name)
{
  // d = the document to work with.
  // returns the handle to the created div.
  if (d.all && (isnotopera=(navigator.userAgent.toLowerCase().indexOf("opera")==-1))) {
      isnotopera=false;
  } else {
      isnotopera=true;
  }
  var theDIV = d.createElement('div');
  theDIV.setAttribute('id', name);
  //theDIV.setAttribute('style', 'background-color: white; border: 1px solid black; padding: 4px; font-size: 9px; display:none; position:absolute;');
  // specify the styles explicitly so that IE works! :(
  var ts=theDIV.style;
      ts.backgroundColor="white";
      ts.fontSize="9px";
      ts.borderStyle="solid";
      ts.borderWidth="1px";
      ts.borderColor="black";
      ts.padding="4px";
      ts.position="absolute";
      ts.display="none";

  // now append to the document.
  var elems = d.getElementsByTagName("*");
  for (var i = 0; i < elems.length; i++) {
      if (elems[i].tagName.toLowerCase() == 'body') {
          elems[i].appendChild(theDIV);
          break;
      }
  }

  return theDIV;
}

// found at http://www.xs4all.nl/~zanstra/logs/jsLog.htm
function DOMNode_insertAfter(newChild,refChild)
//Post condition: if childNodes[n] is refChild, than childNodes[n+1] is newChild.
{
    var parent=refChild.parentNode;
    if (parent.lastChild==refChild) return parent.appendChild(newChild);
    else return parent.insertBefore(newChild,refChild.nextSibling);
}

function sb_CreateHelpDiv(d, p)
{
  // d = the document to work with.
  // returns the handle to the created div.
  if (d.all && (isnotopera=(navigator.userAgent.toLowerCase().indexOf("opera")==-1))) {
      isnotopera=false;
  } else {
      isnotopera=true;
  }
  var helpDIV = d.createElement('span');
  helpDIV.setAttribute('id', p.form.name + "." + p.name + "SearchBoxHelp");
  // specify the styles explicitly so that IE works! :(
  var ts=helpDIV.style;
      ts.fontSize="8px";
      ts.position="relative";
      ts.display="inline-block";
  var html = '<a href="#" title="SearchBox Help" onclick="sb_lastAction[\'' + p.form.name + "." + p.name + '\']=\'helpOpen\'; sb_displayHelp(\''+p.form.name + "." + p.name+'\'); return false;" style="text-decoration: none; color: blue;">?</a>';

  helpDIV.innerHTML = html;

  // now position to the right of the input field.
  DOMNode_insertAfter(helpDIV, p);

  return helpDIV;
}

// Functions -------------------------------------------------------------------

function ElLeft(d, eE)
{
    var DL_bIE=d.all?true:false;
    var nLP=eE.offsetLeft;
    var ePE=eE.offsetParent;
    while (ePE!=null) {
        if (DL_bIE) {
            if (ePE.tagName.toLowerCase()=="td") nLP+=ePE.clientLeft;
        } else {
            if (ePE.tagName.toLowerCase()=="table") {
                var nPB=parseInt(ePE.border);
                if (isNaN(nPB)) {
                    var nPF=ePE.getAttribute('frame');
                    if (nPF!=null) nLP+=1;
                } else if (nPB>0) nLP+=nPB;
            }
        }
        nLP+=ePE.offsetLeft;
        ePE=ePE.offsetParent;
    }
    return nLP;
}

function ElTop(d, eE)
{
    var DL_bIE=d.all?true:false;
    var nLP=eE.offsetHeight+eE.offsetTop;
    var ePE=eE.offsetParent;
    while (ePE!=null) {
        if (!DL_bIE) {
            if (ePE.tagName.toLowerCase()=="table") {
                var nPB=parseInt(ePE.border);
                if (isNaN(nPB)) {
                    var nPF=ePE.getAttribute('frame');
                    if (nPF!=null) nLP+=1;
                } else if (nPB>0) nLP+=nPB;
            }
        }
        nLP+=(DL_bIE && ePE.tagName.toLowerCase() != "body" ? ePE.offsetTop : ePE.offsetTop);
        ePE=ePE.offsetParent;
    }
    return nLP;
}

function sb_IsMatch(entry,pr)
{
    if (entry.substring(0,pr.length)==pr) return true;
    return false;
}

function sb_FindMatches(data,pr, isSorted)
{
    var res=new Array;
    if (pr.length == 0)
    {
        for (var i=0; i < data.length; i++)
        {
          res[res.length]=data[i];
        }
    }
    else
    {
        if (isSorted)
        {
            var f=0;
            var l=data.length-1;
            var m=(f+l)>>1;
            while(f<l) {
                if (data[m]==pr) break;
                if (data[m]<pr) f=m; else l=m;
                nm=(f+l+1)>>1;
                if (m==nm) break;
                m=nm;
            }
            if (m&&sb_IsMatch(data[m-1],pr)) m--;
            if (!sb_IsMatch(data[m],pr) && m<(data.length-1) && sb_IsMatch(data[m+1],pr)) m++;
            while (m<data.length && sb_IsMatch(data[m],pr)) res[res.length]=data[m++];
        }
        else
        {
            for (var i=0; i < data.length; i++)
            {
              if (sb_IsMatch(data[i],pr)) res[res.length]=data[i];
            }
        }
    }
    return res;
}

function sb_Show(what, width, d, p, theDIV)
{
    var ts=theDIV.style;
    if (what=="") {
        if (ts.display!="none") ts.display="none";
    } else {
        ts.display="block";
        ts.left=ElLeft(d, p)+"px";
        ts.top=ElTop(d, p)+"px";
        ts.width = width + "em";  // specify the width in characters.
        theDIV.innerHTML=what;
    }
}

function sb_HideAll(d, p, theDIV)
{
    if (sb_lastAction[p.form.name + "." + p.name] != 'key')
    {
        sb_matches=new Array();
        sb_matchesjoined="";
        sb_inmenu=sb_menupos=sb_matchcompleted=0;
    }
    sb_Show("", 0, d, p, theDIV);
}


function sb_ShowNoMatch(d, p, theDIV)
{
    //sb_Show("<font color=\"gray\">Nothing found</font>", d, p, theDIV);
    sb_HideAll(d, p, theDIV);
}

function sb_LookupValue(name)
{
    var lookupData, p, data, dataIsAA;
    try {
        eval('lookupData=sb_searchBoxes["'+name+'"].lookupData;p=sb_searchBoxes["'+name+'"].p;data=sb_searchBoxes["'+name+'"].data;dataIsAA=sb_searchBoxes["'+name+'"].dataIsAA;');
    }
    catch (e) {
        alert(e);
        return;
    }
    if (p.value == '') return p.value;

    var value = "";
    if (dataIsAA)
    {
        value = (lookupData[p.value] != undefined ? "="+lookupData[p.value] : "+"+p.value);
    }
    else
    {
        // walk the data array and see if we find p.value in it.
        var found = false;
        for (var i=0; i < data.length; i++)
        {
            if (data[i] == p.value)
            {
                found = true;
                break;
            }
        }
        if (found)
        {
            value = "=" + p.value;
        }
        else
        {
            value = "+" + p.value;
        }
    }

    return value;
}

function sb_UpdateMenu(d, p, ph, theDIV, updateValue)
{
    var longestEntry = 0;
    var flen=sb_matches.length;
    if (flen<=sb_showmatches) {
        beforedots=first=afterdots=0;
        last=flen-1;
    } else {
        if (sb_inmenu) {
            mid=sb_showmatches>>1;
            if (sb_menupos<=mid) beforedots=first=0;
            else {
                beforedots=1;
                first=sb_menupos-mid+1;
                if (first>(flen-sb_showmatches+1)) first=flen-sb_showmatches+1;
            }
            if (sb_menupos>=(flen-mid-1)) {
                afterdots=0;
                last=flen-1;
            } else {
                afterdots=1;
                last=sb_menupos+mid-1;
                if (last<(sb_showmatches-2)) last=sb_showmatches-2;
            }
        } else {
            first=beforedots=0;
            last=sb_showmatches-2;
            afterdots=1;
        }
    }
    var zh = '';
    zh += '<html><head>\n';
    zh += '<style type="text/css">\n';
    zh += '  tr.searchBoxLink:hover { background-color: rgb(204,204,255); color: #000000; cursor: pointer; }\n';
    zh += '  .searchBoxScroll:hover { background-color: red; color: #FFFFFF; font-size: 9px; cursor: pointer; }\n';
    zh += '  .searchBoxScroll { background-color: #FFFFFF; color: red; font-size: 9px; }\n';
    zh += '  tr.searchBoxRow { background-color: #FFFFFF; color: #000000; }\n';
    zh += '</style>\n';
    zh += '</head><body>\n';
    zh +='<table border="0" cellpadding="0" cellspacing="0" width="100%">\n';
    if (beforedots)
    {
      zh += '  <tr class="searchBoxScroll">\n';
      zh += '    <td class="searchBoxScroll" align="center" onclick="sb_lastAction[\'' + p.form.name + "." + p.name + '\']=\'scroll\';sb_ScrollWindowUpMouse(\'' + p.form.name + "." + p.name + '\');"><span class="searchBoxScroll">Scroll Up</span></td>\n';
      zh += '  </tr>\n';
    }
    for (pos=first; pos<=last; pos++) {
        // TODO: do I need to escape single quotes?  Yes!
        f=sb_matches[pos];
        var fStatus = f.replace("\\'", "'");
        fStatus = fStatus.replace("'", "\\\'");
        if (f.length > longestEntry) longestEntry = f.length;
        zh += '  <tr class="searchBoxLink" onclick="sb_lastAction[\'' + p.form.name + "." + p.name + '\']=\'itemSelect\'; sb_UpdateSelection(\'' + p.form.name + "." + p.name + '\', \'' + fStatus + '\'); window.defaultStatus=\'\'; return false;" onmouseover="window.status=\'' + fStatus + '\'; return true;" onmouseout="window.status=\'\';return true;">\n';
        zh += '    <td style="font-size: 9px;' + (sb_inmenu && sb_menupos==pos && updateValue ? ' background-color: rgb(204,204,255);' : '') + '">' + f + '</td>\n';
        zh += '  </tr>\n';
    }
    if (afterdots)
    {
      if (11 > longestEntry) longestEntry = 11;  // make sure that the Scroll Down doesn't wrap.
      zh += '  <tr class="searchBoxScroll">\n';
      zh += '    <td class="searchBoxScroll" align="center" onclick="sb_lastAction[\'' + p.form.name + "." + p.name + '\']=\'scroll\';sb_ScrollWindowDownMouse(\'' + p.form.name + "." + p.name + '\'); return false;"><span class="searchBoxScroll">Scroll Down</span></td>\n';
      zh += '  </tr>\n';
    }
    zh += '</table>\n';
    zh += '</body></html>\n';
    sb_Show(zh, longestEntry, d, p, theDIV);
    if (sb_inmenu && updateValue)
    {
        p.value=sb_matches[sb_menupos];
        if (ph) ph.value = sb_LookupValue(p.form.name + "." + p.name);
    }
    if (p.value!=sb_currenttext) {
        sb_currenttext=p.value;
    }
    //alert(zh);
}

function sb_NewText(name)
{
    var lookupData, data, dataIsAA, dataIsSorted, displayEmpty, d, p, ph, theDIV;
    try {
        eval('lookupData=sb_searchBoxes["'+name+'"].lookupData;p=sb_searchBoxes["'+name+'"].p;data=sb_searchBoxes["'+name+'"].data;dataIsAA=sb_searchBoxes["'+name+'"].dataIsAA;dataIsSorted=sb_searchBoxes["'+name+'"].dataIsSorted;displayEmpty=sb_searchBoxes["'+name+'"].displayEmpty;d=sb_searchBoxes["'+name+'"].d;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    var t=p.value;
    if (t=="" && !displayEmpty) {
        sb_HideAll(d, p, theDIV);
        return;
    }
    // rebuild the data array if it is an associative array.
    if (dataIsAA)
    {
        data = new Array();
        for (var i in lookupData)
        {
            data.push(i);
        }
        if (dataIsSorted)
        {
            data = data.sort();
        }
    }

    tmpmatches=sb_FindMatches(data, t, dataIsSorted);
    if (tmpmatches.length==0) {
        sb_matchesjoined="";
        sb_ShowNoMatch(d, p, theDIV);
        return;
    }
    if (tmpmatches.join(",")==sb_matchesjoined) return; // do nothing
    sb_inmenu=sb_menupos=0;
    sb_matchesjoined=tmpmatches.join(",");
    sb_matches=tmpmatches;
    sb_UpdateMenu(d, p, ph, theDIV, true);
}

function sb_UpdateSelection(name, value)
{
    var d, p, ph, theDIV;
    try {
        eval('d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    window.status = '';
    sb_HideAll(d, p, theDIV);
    p.value = value;
    if (ph) ph.value = sb_LookupValue(name);
    p.focus();
}

function sb_closeHelp(name)
{
    var data, dataIsSorted, displayEmpty, d, p, ph, theDIV;
    try {
        eval('data=sb_searchBoxes["'+name+'"].data;dataIsSorted=sb_searchBoxes["'+name+'"].dataIsSorted;displayEmpty=sb_searchBoxes["'+name+'"].displayEmpty;d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    window.status = '';
    sb_HideAll(d, p, theDIV);
    p.focus();
}

function sb_displayHelp(name)
{
    var d, p, theDIV;
    try {
        eval('d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    window.status = '';
    var html = '<table border="0" width="100%">\n';
    html += '  <tr class="searchBoxRow">\n';
    html += '    <td align="left"><a href="#" title="Close Popup" onclick="sb_lastAction[\'' + p.form.name + "." + p.name + '\']=\'helpClose\';sb_closeHelp(\''+name+'\');return false;" style="text-decoration: none; color: blue;">Close</a></td>\n';
    html += '    <td align="center" width="95%"><b>SearchBox Help</b></td>\n';
    html += '  </tr>\n';
    html += '</table>\n';
    html += 'This widget allows a user to enter text into an edit field and/or select from known values -- similiar to a select box.<br /><br />\n';
    html += '<b>Key Definitions</b>:<br /><br />\n';
    html += '<b>TAB</b><br /> <span style="color:blue;">Once</span> - attempts to complete the text typed in the input field using the available selections.  ie. If \'abcdefg\' is in the list of available selections and you have typed \'abc\' in the input field, hitting TAB will cause \'defg\' to be added to your input, as long as there was no other possible matches.<br /><span style="color:blue;">Twice</span> - goes to the next field.<br /><br />\n';
    html += '<b>ESC</b> closes the popup if it is open.<br /><br />\n';
    html += '<b>ENTER</b> Closes the popup area if it is open. &nbsp;Also stops TAB completion until focus leaves the widget. &nbsp;This allows entering a string that is a subset of an entry in the popup area. &nbsp;TAB then moves to the next field instead of completing the text.<br /><br />\n';
    html += '<b>ARROW UP/DOWN</b> Moves the selector in the popup area up/down by 1 entry. &nbsp;Automatically opens the popup if closed.<br /><br />\n';
    html += '<b>PAGE UP/DOWN</b> Moves the selector in the popup area up/down by 5 entries. &nbsp;Automatically opens the popup if closed.<br /><br />\n';
    html += '<b>Mouse Interface</b>:<br /><br />\n';
    html += 'The mouse can select entries in the popup area by clicking on them.<br />\n';
    html += 'If there are more entries than will fit in the popup, <span style="color:red;">Scroll Up/Down</span> messages are placed at the top and bottom. &nbsp;These will scroll up/down by 5 entries when clicked.<br />\n';
    html += '<br />\n';
    html += '<b>Caveats</b>:<br />\n';
    html += 'Currently, the popup mouseovers work 100% in Mozilla. &nbsp;Other browsers are being tested.\n';

    sb_Show(html, 45, d, p, theDIV);
    p.focus();
}

function sb_ScrollWindowUpMouse(name)
{
    var d, p, ph, theDIV;
    try {
        eval('d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    sb_ScrollWindowUp(d, p, ph, theDIV, false, 5);
    p.focus();
}

function sb_ScrollWindowDownMouse(name)
{
    var d, p, ph, theDIV;
    try {
        eval('d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    sb_ScrollWindowDown(d, p, ph, theDIV, false, 5);
    p.focus();
}

function sb_EFocus(ev)
{
    ev=ev||event||null;
    var src=ev.target||ev.srcElement||null;
    var name = src.form.name + "." + src.name;
    if (sb_currField != name)
    {
        sb_lastField = sb_currField;

        // see if this is the actual initial focus event and we are not coming in from the helpOpen action.
        if (sb_lastAction[name] == 'helpOpen')
            sb_lastAction[name] = 'helpOpenFocus';
        else
            sb_lastAction[name] = 'focus';

        if (sb_searchBoxes[name].onfocusCallback.length > 0)
        {
            eval(sb_searchBoxes[name].onfocusCallback);
        }
    }
    sb_currField = name;

    if (sb_lastAction[name] != 'helpOpen' && sb_lastAction[name] != 'helpOpenFocus' && sb_lastAction[name] != 'scroll' && sb_lastAction[name] != 'key')
        sb_NewText(name);
}

// Client event handler wrapper does the Timeout.
function sb_EBlur(ev)
{
    ev=ev||event||null;
    var src=ev.target||ev.srcElement||null;
    setTimeout("sb_RealBlurHandler('" + src.form.name + "." + src.name + "')", 150);
}

function sb_RealBlurHandler(name)
{
    var d, p, ph, theDIV, onblurCallback;
    try {
        eval('d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;onblurCallback=sb_searchBoxes["'+name+'"].onblurCallback;');
    }
    catch (e) {
        alert(e);
        return;
    }

    var hide = false;
    if (sb_currField != name && sb_lastField == name)
    {
        hide = true;
    }
    else if (sb_lastAction[name] != 'helpOpen' && sb_lastAction[name] != 'helpClose' && sb_lastAction[name] != 'itemSelect' && sb_lastAction[name] != 'scroll')
    {
        hide = true;
    }
    if (hide)
    {
        if (ph) ph.value = sb_LookupValue(p.form.name + "." + p.name);

        sb_lastAction[name] = 'blur';
        // If we didn't go to another searchBox field, we need to update the sb_currField accordingly.
        if (sb_currField == name)
        {
          sb_lastField = name;
          sb_currField = '';
        }
        sb_HideAll(d, p, theDIV);
        // if the callback code has an alert() in it, then mozilla blows an error about
        // not being able to deal with a select box!  Don't use an alert. :)
        if (onblurCallback.length > 0)
        {
            //setTimeout(onblurCallback, 20);
            eval(onblurCallback);
        }
    }
    else
    {
        if (sb_lastAction[name] == 'helpOpen')
            sb_lastAction[name] = 'helpOpenFocus';
        if (sb_lastAction[name] == 'key' || sb_lastAction[name] == 'scroll' || sb_lastAction[name] == 'itemSelect' || sb_lastAction[name] == 'helpClose')
            sb_lastAction[name] = 'focus';
    }
}

function sb_ScrollWindowUp(d, p, ph, theDIV, updateValue, count)
{
    if (sb_inmenu) {
        if ((sb_menupos -= count) < 0) sb_menupos=sb_matches.length-1;
    } else {
        sb_inmenu=1;
        sb_menupos=sb_matches.length-1;
    }
    sb_UpdateMenu(d, p, ph, theDIV, updateValue);
}

function sb_ScrollWindowDown(d, p, ph, theDIV, updateValue, count)
{
    if (sb_inmenu) {
        if ((sb_menupos += count) >= sb_matches.length) sb_menupos=0;
    }
    else if (sb_lastAction[p.form.name + "." + p.name] == 'scroll')
    {
        // we are wanting to show the next n entries, but don't want
        // to start out at sb_menupos = 0, so split the maximum
        // allowed to display and bump it a little so we start
        // scrolling immediately.
        sb_inmenu = 1;
        sb_menupos = (sb_showmatches>>1)+count;
    } else {
        sb_inmenu=1;
        sb_menupos=0;
    }
    sb_UpdateMenu(d, p, ph, theDIV, updateValue);
}

function sb_EKeyPress(ev)
{
    ev=ev||event||null;
    if (ev) {
        var cc=ev.charCode||ev.keyCode||ev.which;
        if (cc==9 && (sb_matchcompleted == 1))  // TAB
        {
            // Cancel the TAB key propogation if we have only pressed TAB once and we
            // had some matches.
            return false;
        }
        if (cc == 13) // Enter
        {
            // apparently Mozilla and IE 6 don't submit the form with Enter unless there
            // is a submit button defined.  We don't want the Enter in our field to
            // actually submit the form, since this is used to indicate that the
            // tab completion should be ignored if the next key pressed is TAB.
            return false;
        }
        if ((cc==38||cc==57385) && sb_inmenu) { // up
            sb_keyrepeat++;
            if (sb_keyrepeat % 3 == 0)
            {
                return sb_EKeyDown(ev);
            }
            else
            {
                return true;
            }
        }
        if ((cc==33) && sb_inmenu) { // page up
            sb_keyrepeat++;
            if (sb_keyrepeat % 3 == 0)
            {
                return sb_EKeyDown(ev);
            }
            else
            {
                return true;
            }
        }
        if ((cc==40||cc==57386) && sb_inmenu) { // down
            sb_keyrepeat++;
            if (sb_keyrepeat % 3 == 0)
            {
                return sb_EKeyDown(ev);
            }
            else
            {
                return true;
            }
        }
        if ((cc==34) && sb_inmenu) { // page down
            sb_keyrepeat++;
            if (sb_keyrepeat % 3 == 0)
            {
                return sb_EKeyDown(ev);
            }
            else
            {
                return true;
            }
        }
        //if ((cc>=97&&cc<=122)||(cc>=65&&cc<=90)||(cc>=48&&cc<=57)||cc==95) return true; // a-z A-Z 0-9 _
    }
    return true;
}

function sb_EKeyDown(ev)
{
    ev=ev||event||null;
    var src=ev.target||ev.srcElement||null;
    var data, dataIsSorted, displayEmpty, d, p, ph, theDIV;
    var name = src.form.name + "." + src.name;
    try {
        eval('data=sb_searchBoxes["'+name+'"].data;dataIsSorted=sb_searchBoxes["'+name+'"].dataIsSorted;displayEmpty=sb_searchBoxes["'+name+'"].displayEmpty;d=sb_searchBoxes["'+name+'"].d;p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;theDIV=sb_searchBoxes["'+name+'"].theDIV;');
    }
    catch (e) {
        alert(e);
        return;
    }
    sb_lastAction[name] = 'key';
    if (ev&&sb_matches.length>0) {
        var cc=ev.charCode||ev.keyCode||ev.which;
        var shiftPressed = (ev.modifiers && ev.modifiers == Event.SHIFT_MASK)||ev.shiftKey||false;
        var realLastKey = sb_lastkey;
        sb_lastkey = cc;
        //alert('cc = "' + cc + '"');
        if (cc==27) { // ESC
            sb_HideAll(d, p, theDIV);
            return false;
        }
        if (cc==13) { // Enter
            sb_HideAll(d, p, theDIV);
            return false;
        }
        if (cc==38||cc==57385) { // up
            sb_ScrollWindowUp(d, p, ph, theDIV, true, 1);
            return false;
        }
        if (cc==33) { // page up
            sb_ScrollWindowUp(d, p, ph, theDIV, true, 5);
            return false;
        }
        if (cc==40||cc==57386) { // down
            sb_ScrollWindowDown(d, p, ph, theDIV, true, 1);
            return false;
        }
        if (cc==34) { // page down
            sb_ScrollWindowDown(d, p, ph, theDIV, true, 5);
            return false;
        }
        if (cc == 9 && realLastKey != cc)
        {
          // cancel the matchcompleted count, since we did not have back to back TABs.
          sb_matchcompleted = 0;
        }
        if (cc==9) { // TAB  auto-complete or goto next field if we have arrowed down into the div.
            if (sb_inmenu)
            {
                sb_HideAll(d, p, theDIV);
                return false;
            }
            if (realLastKey == 13) return true;
            if (shiftPressed) return true;
            var _p=p.value;
            if (_p.length == 0 && !displayEmpty) return false;
            matches=sb_FindMatches(data, _p, dataIsSorted);
            if (matches.length==0) return false;
            sb_matchcompleted++;  // indicate we have found a match or matches.
            if (_p.length ==0) return false;
            if (matches.length==1) { // full autocomplete in case of single match
                p.value=matches[0];
                if (ph) ph.value = sb_LookupValue(name);
                return false;
            }
            len=0;
            first=matches[0];
            last=matches[matches.length-1]; matches.length--;
            while (len<first.length && first.substring(0,len+1)==last.substring(0,len+1)) len++;
            if (p.value!=first.substring(0,len)) {
                p.value=first.substring(0,len);
                if (ph) ph.value = sb_LookupValue(name);
            }
            return false;
        }
    }
    return true;
}

function sb_EKeyUp(ev)
{
    sb_keyrepeat=0;
    ev=ev||event||null;
    var src=ev.target||ev.srcElement||null;
    var p, ph;
    var name = src.form.name + "." + src.name;
    try {
        eval('p=sb_searchBoxes["'+name+'"].p;ph=sb_searchBoxes["'+name+'"].ph;');
    }
    catch (e) {
        alert(e);
        return;
    }
    sb_lastAction[name] = 'key';
    if (ev) {
        var cc=ev.charCode||ev.keyCode||ev.which;
        if (cc==13||cc==27||cc==33||cc==34||cc==38||cc==40||cc==57385||cc==57386) return false;
        if (cc==9 && sb_matchcompleted > 1) sb_matchcompleted=0;
        if (p.value!=sb_currenttext) {
            sb_currenttext=p.value;
            if (ph) ph.value = sb_LookupValue(name);
            sb_NewText(name);
        }
    }
    return true;
}

// turn off browser's built in autocomplete
function sb_DisableAutoComplete(p)
{
    p.setAttribute("autocomplete", "off");
}

// turn on browser's built in autocomplete
function sb_EnableAutoComplete(p)
{
    p.setAttribute("autocomplete", "on");
}
