/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeWriter;

public class InStreamFromIterativeWriter
extends InputStream {
    private static byte UNINITIALISED = 0;
    private static byte OPEN = 1;
    private static byte CLOSED = (byte)2;
    protected byte[] q;
    protected int qBegin;
    protected int qEnd;
    protected int qSize;
    protected int bufSize;
    protected int incSize;
    protected int minWriteSize;
    protected int writeCushion;
    private InputStream in;
    private IterativeWriter writer;
    private static final int DEF_BUF_SIZE = 4096;
    private byte[] oneByteArr = new byte[1];
    private WriterOutputStream writerStream;
    private int maxBufSize;

    public InStreamFromIterativeWriter(int n, int n2, int n3, int n4) {
        int n5;
        if (n < 1024) {
            n = 1024;
        }
        if (n2 < 128) {
            n2 = 128;
        }
        if (n3 < 256) {
            n3 = 256;
        }
        if (n4 < 256) {
            n4 = 256;
        }
        if (n < (n5 = n3 + n4 + 512)) {
            n = n5;
        }
        this.bufSize = n;
        this.incSize = n2;
        this.writeCushion = n4;
        this.q = new byte[n];
        this.qBegin = 0;
        this.qEnd = 0;
        this.qSize = 0;
        this.maxBufSize = n;
    }

    public InStreamFromIterativeWriter(int n) {
        this(n < 2048 ? 2048 : n, 512, 750, 750);
    }

    public InStreamFromIterativeWriter() {
        this(4096, 1024, 750, 750);
    }

    private void reallocBuf(int n) {
        byte[] byArray = new byte[n];
        int n2 = this.q.length - this.qBegin;
        if (n2 > this.qSize) {
            n2 = this.qSize;
        }
        System.arraycopy(this.q, this.qBegin, byArray, 0, n2);
        int n3 = n2;
        n2 = this.qSize - n2;
        if (n2 > 0) {
            System.arraycopy(this.q, 0, byArray, n3, n2);
        }
        this.q = byArray;
        this.qBegin = 0;
        this.qEnd = this.qSize;
        if (n > this.maxBufSize) {
            this.maxBufSize = n;
        }
    }

    public OutputStream getWriterOutputStream() {
        if (this.writerStream == null) {
            this.writerStream = new WriterOutputStream();
        }
        if (this.writer != null && this.writerStream.openFlag == UNINITIALISED) {
            this.writerStream.openFlag = OPEN;
        }
        return this.writerStream;
    }

    public void setIterativeWriter(IterativeWriter iterativeWriter) {
        if (iterativeWriter == null) {
            throw new NullPointerException("Writer is null");
        }
        if (this.writerStream != null && this.writerStream.openFlag == UNINITIALISED) {
            this.writerStream.openFlag = OPEN;
        }
        this.writer = iterativeWriter;
    }

    private int readOrSkip(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.qSize;
        if (n4 > n2) {
            n4 = n2;
        }
        if (n4 > 0) {
            n3 = this.q.length - this.qBegin;
            if (n3 > n4) {
                n3 = n4;
            }
            if (byArray != null) {
                System.arraycopy(this.q, this.qBegin, byArray, n, n3);
                n += n3;
            }
            this.qBegin += n3;
            if (this.qBegin == this.q.length) {
                this.qBegin = 0;
            }
            if ((n3 = n4 - n3) > 0) {
                if (byArray != null) {
                    System.arraycopy(this.q, this.qBegin, byArray, n, n3);
                    n += n3;
                }
                this.qBegin += n3;
            }
            this.qSize -= n4;
            if (this.qSize == 0) {
                this.qBegin = 0;
                this.qEnd = 0;
            }
        }
        if ((n3 = n2 - n4) > 0) {
            int n5;
            this.writerStream.requestBuf = byArray;
            this.writerStream.requestPos = n;
            this.writerStream.requestRemaining = n3;
            while (this.writerStream.openFlag == OPEN && (n5 = this.bufSize + this.writerStream.requestRemaining - this.qSize - this.writeCushion) > this.minWriteSize) {
                if (this.writer.nextWrite(n5) == 0) continue;
                this.writerStream.close();
            }
            if (this.q.length > this.bufSize && this.q.length - this.qSize >= this.incSize) {
                int n6 = this.bufSize;
                if (this.qSize > this.bufSize) {
                    n6 = this.qSize + (this.incSize - 1 - (this.qSize - 1 - this.bufSize) % this.incSize);
                }
                this.reallocBuf(n6);
            }
            n3 -= this.writerStream.requestRemaining;
        }
        return n4 + n3;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + n2);
        }
        byte by = byArray[n];
        byte by2 = byArray[n + n2 - 1];
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.readOrSkip(byArray, n, n2);
        if (n3 == 0) {
            n3 = -1;
        }
        return n3;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.read(this.oneByteArr, 0, 1) == 1) {
            n = this.oneByteArr[0] & 0xFF;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (l < 0L) {
            l = 0L;
        }
        l2 = this.readOrSkip(null, 0, (int)l);
        return l2;
    }

    public int available() throws IOException {
        int n = this.qSize;
        if (n < 0) {
            n = this.q.length + n;
        }
        if (n <= 0) {
            n = this.writerStream.openFlag == OPEN ? 1 : 0;
        }
        return n;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    static /* synthetic */ byte access$000() {
        return UNINITIALISED;
    }

    private class WriterOutputStream
    extends OutputStream
    implements ByteCounter {
        private byte[] oneByteArr = new byte[1];
        public byte[] requestBuf;
        public int requestPos;
        public int requestRemaining;
        public byte openFlag = InStreamFromIterativeWriter.access$000();
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes = 0L;

        private WriterOutputStream() {
        }

        public void setCounter(int[] nArray, boolean bl) {
            int n = nArray[0];
            this.counterArr = nArray;
            this.upMode = bl;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setRequestBuf(byte[] byArray, int n, int n2) {
            this.requestBuf = byArray;
            this.requestPos = n;
            this.requestRemaining = n2;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.openFlag != OPEN) {
                throw new IOException("Stream is not closed or IterativeWriter not set yet");
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + n2);
            }
            byte by = byArray[n];
            byte by2 = byArray[n + n2 - 1];
            int n4 = n2;
            if (this.requestRemaining > 0) {
                n3 = n2;
                if (this.requestRemaining < n2) {
                    n3 = this.requestRemaining;
                }
                if (this.requestBuf != null) {
                    System.arraycopy(byArray, n, this.requestBuf, this.requestPos, n3);
                }
                this.requestPos += n3;
                this.requestRemaining -= n3;
                n += n3;
                n2 -= n3;
            }
            if (n2 > 0) {
                int n5;
                n3 = InStreamFromIterativeWriter.this.qSize + n2;
                if (n3 > InStreamFromIterativeWriter.this.q.length) {
                    InStreamFromIterativeWriter.this.reallocBuf(n3 + InStreamFromIterativeWriter.this.incSize - 1 - (n3 - 1 - InStreamFromIterativeWriter.this.bufSize) % InStreamFromIterativeWriter.this.incSize);
                }
                if ((n5 = InStreamFromIterativeWriter.this.q.length - InStreamFromIterativeWriter.this.qEnd) > n2) {
                    n5 = n2;
                }
                System.arraycopy(byArray, n, InStreamFromIterativeWriter.this.q, InStreamFromIterativeWriter.this.qEnd, n5);
                n += n5;
                InStreamFromIterativeWriter.this.qEnd += n5;
                if (InStreamFromIterativeWriter.this.qEnd >= InStreamFromIterativeWriter.this.q.length) {
                    InStreamFromIterativeWriter.this.qEnd = 0;
                }
                if ((n5 = n2 - n5) > 0) {
                    System.arraycopy(byArray, n, InStreamFromIterativeWriter.this.q, InStreamFromIterativeWriter.this.qEnd, n5);
                    InStreamFromIterativeWriter.this.qEnd += n5;
                }
                InStreamFromIterativeWriter.this.qSize = n3;
            }
            if (n4 > 0) {
                this.totalBytes += (long)n4;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + n4 : this.counterArr[0] - n4;
                }
            }
        }

        public void write(int n) throws IOException {
            this.oneByteArr[0] = (byte)(n & 0xFF);
            this.write(this.oneByteArr, 0, 1);
        }

        public void close() throws IOException {
            this.openFlag = CLOSED;
        }
    }
}

