/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeReader;

public class OutStreamToIterativeReader
extends OutputStream {
    private static byte UNINITIALISED = 0;
    private static byte OPEN = 1;
    private static byte CLOSED = (byte)2;
    private boolean isDetached;
    protected byte[] q;
    protected int qBegin;
    protected int qEnd;
    protected int qSize;
    private int minReadSize;
    private int readCushion;
    private IterativeReader reader;
    private static final int DEF_BUF_SIZE = 3072;
    private byte openFlag = UNINITIALISED;
    private byte[] oneByteArr = new byte[1];
    private ReaderInputStream readerStream;

    public OutStreamToIterativeReader(int n, int n2, int n3) {
        int n4;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n < (n4 = n2 + n3 + 512)) {
            n = n4;
        }
        this.q = new byte[n];
        this.qBegin = 0;
        this.qEnd = 0;
        this.qSize = 0;
        this.minReadSize = n2;
        this.readCushion = n3;
        this.isDetached = false;
    }

    public OutStreamToIterativeReader() {
        this(3072, 1024, 1024);
    }

    public InputStream getReaderInputStream() {
        if (this.readerStream == null) {
            this.readerStream = new ReaderInputStream();
        }
        if (this.reader != null && this.openFlag == UNINITIALISED) {
            this.openFlag = OPEN;
        }
        return this.readerStream;
    }

    public void setIterativeReader(IterativeReader iterativeReader) {
        if (iterativeReader == null) {
            throw new NullPointerException("Reader is null");
        }
        if (this.readerStream != null && this.openFlag == UNINITIALISED) {
            this.openFlag = OPEN;
        }
        this.reader = iterativeReader;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        block9: {
            if (this.openFlag != OPEN) {
                throw new IOException("Stream is closed or IterativeReader not set yet");
            }
            int n3 = this.readerStream.writeBufRemain;
            if (n3 < 0) {
                n -= n3;
                this.readerStream.writeBufRemain = n3 = (n2 += n3) >= 0 ? 0 : n2;
            }
            if (n2 > 0 && !this.isDetached) {
                int n4;
                int n5 = this.qSize + n2;
                if (n5 > this.q.length) {
                    n4 = n5 - this.readCushion;
                    this.readerStream.writeBuf = byArray;
                    this.readerStream.writeBufPos = n;
                    this.readerStream.writeBufRemain = n2;
                    do {
                        if (this.reader.nextRead(n4) == 0) continue;
                        this.readerStream.close();
                        break block9;
                    } while ((n4 = this.qSize + this.readerStream.writeBufRemain - this.readCushion) > this.minReadSize);
                    n = this.readerStream.writeBufPos;
                    n2 = this.readerStream.writeBufRemain;
                    this.readerStream.writeBufRemain = 0;
                }
                if (n2 > 0) {
                    n4 = this.q.length - this.qEnd;
                    if (n4 > n2) {
                        n4 = n2;
                    }
                    System.arraycopy(byArray, n, this.q, this.qEnd, n4);
                    n += n4;
                    this.qEnd += n4;
                    if (this.qEnd >= this.q.length) {
                        this.qEnd = 0;
                    }
                    if ((n4 = n2 - n4) > 0) {
                        System.arraycopy(byArray, n, this.q, this.qEnd, n4);
                        this.qEnd += n4;
                    }
                    this.qSize += n2;
                }
            }
        }
    }

    public void write(int n) throws IOException {
        this.oneByteArr[0] = (byte)(n & 0xFF);
        this.write(this.oneByteArr, 0, 1);
    }

    public void close() throws IOException {
        this.openFlag = CLOSED;
        if (!this.isDetached) {
            int n;
            while ((n = this.qSize + this.readerStream.writeBufRemain) > 0) {
                if (this.reader.nextRead(n) == 0) continue;
                this.readerStream.close();
                break;
            }
        }
    }

    public boolean isReaderDetached() {
        return this.isDetached;
    }

    private class ReaderInputStream
    extends InputStream
    implements ByteCounter {
        private byte[] oneByteArr = new byte[1];
        public byte[] writeBuf;
        public int writeBufPos;
        public int writeBufRemain = 0;
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes = 0L;

        private ReaderInputStream() {
        }

        public void setCounter(int[] nArray, boolean bl) {
            int n = nArray[0];
            this.counterArr = nArray;
            this.upMode = bl;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setRequestBuf(byte[] byArray, int n, int n2) {
            this.writeBuf = byArray;
            this.writeBufPos = n;
            this.writeBufRemain = n2;
        }

        private int readOrSkip(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            if (OutStreamToIterativeReader.this.openFlag == UNINITIALISED || OutStreamToIterativeReader.this.isDetached) {
                throw new IOException("IterativeReader not set or has been detached");
            }
            int n5 = OutStreamToIterativeReader.this.qSize;
            if (n5 > n2) {
                n5 = n2;
            }
            if (n5 > 0) {
                n4 = OutStreamToIterativeReader.this.q.length - OutStreamToIterativeReader.this.qBegin;
                if (n4 > n5) {
                    n4 = n5;
                }
                if (byArray != null) {
                    System.arraycopy(OutStreamToIterativeReader.this.q, OutStreamToIterativeReader.this.qBegin, byArray, n, n4);
                    n += n4;
                }
                OutStreamToIterativeReader.this.qBegin += n4;
                if (OutStreamToIterativeReader.this.qBegin == OutStreamToIterativeReader.this.q.length) {
                    OutStreamToIterativeReader.this.qBegin = 0;
                }
                if ((n4 = n5 - n4) > 0) {
                    if (byArray != null) {
                        System.arraycopy(OutStreamToIterativeReader.this.q, OutStreamToIterativeReader.this.qBegin, byArray, n, n4);
                        n += n4;
                    }
                    OutStreamToIterativeReader.this.qBegin += n4;
                }
                OutStreamToIterativeReader.this.qSize -= n5;
                if (OutStreamToIterativeReader.this.qSize == 0) {
                    OutStreamToIterativeReader.this.qBegin = 0;
                    OutStreamToIterativeReader.this.qEnd = 0;
                }
            }
            if ((n4 = n2 - n5) > 0) {
                if (n4 > this.writeBufRemain) {
                    if (OutStreamToIterativeReader.this.openFlag == CLOSED) {
                        n4 = this.writeBufRemain > 0 ? this.writeBufRemain : 0;
                    } else if (byArray != null) {
                        throw new IOException("Iterative Reader attempting to read beyond buffer end. Need larger read cushion?");
                    }
                }
                if (byArray != null) {
                    System.arraycopy(this.writeBuf, this.writeBufPos, byArray, n, n4);
                }
                this.writeBufPos += n4;
                this.writeBufRemain -= n4;
            }
            if ((n3 = n5 + n4) > 0) {
                this.totalBytes += (long)n3;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + n3 : this.counterArr[0] - n3;
                }
            }
            return n3;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + n2);
            }
            byte by = byArray[n];
            byte by2 = byArray[n + n2 - 1];
            int n3 = this.readOrSkip(byArray, n, n2);
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            long l2 = 0L;
            if (l < 0L) {
                l = 0L;
            }
            l2 = this.readOrSkip(null, 0, (int)l);
            return l2;
        }

        public int read() throws IOException {
            int n = -1;
            if (this.read(this.oneByteArr) == 1) {
                n = this.oneByteArr[0] & 0xFF;
            }
            return n;
        }

        public int available() throws IOException {
            int n = OutStreamToIterativeReader.this.qSize;
            if (n < 1 && OutStreamToIterativeReader.this.openFlag != CLOSED) {
                n = 1;
            }
            return n;
        }

        public void close() throws IOException {
            OutStreamToIterativeReader.this.isDetached = true;
            OutStreamToIterativeReader.this.q = null;
        }
    }
}

