/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.InputFile;
import net.pms.dlna.LibMediaInfoParser;
import net.pms.formats.Format;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FormatConfiguration.class);
    private ArrayList<SupportSpec> supportSpecs = new ArrayList();
    private static final String[] PARSER_V1_EXTENSIONS = new String[]{".jpg", ".jpe", ".jpeg"};
    public static final String AAC = "aac";
    public static final String AC3 = "ac3";
    public static final String AIFF = "aiff";
    public static final String ALAC = "alac";
    public static final String APE = "ape";
    public static final String ATRAC = "atrac";
    public static final String AVI = "avi";
    public static final String BMP = "bmp";
    public static final String DIVX = "divx";
    public static final String DTS = "dts";
    public static final String DTSHD = "dtshd";
    public static final String DV = "dv";
    public static final String EAC3 = "eac3";
    public static final String FLAC = "flac";
    public static final String FLV = "flv";
    public static final String GIF = "gif";
    public static final String H264 = "h264";
    public static final String JPG = "jpg";
    public static final String LPCM = "lpcm";
    public static final String MATROSKA = "mkv";
    public static final String MI_GMC = "gmc";
    public static final String MI_QPEL = "qpel";
    public static final String MJPEG = "mjpeg";
    public static final String MLP = "mlp";
    public static final String MOV = "mov";
    public static final String MP3 = "mp3";
    public static final String MP4 = "mp4";
    public static final String MPA = "mpa";
    public static final String MPC = "mpc";
    public static final String MPEG1 = "mpeg1";
    public static final String MPEG2 = "mpeg2";
    public static final String MPEGPS = "mpegps";
    public static final String MPEGTS = "mpegts";
    public static final String OGG = "ogg";
    public static final String PNG = "png";
    public static final String RA = "ra";
    public static final String RM = "rm";
    public static final String SHORTEN = "shn";
    public static final String TIFF = "tiff";
    public static final String TRUEHD = "truehd";
    public static final String VC1 = "vc1";
    public static final String WAVPACK = "wavpack";
    public static final String WAV = "wav";
    public static final String WEBM = "WebM";
    public static final String WMA = "wma";
    public static final String WMV = "wmv";
    public static final String MIMETYPE_AUTO = "MIMETYPE_AUTO";
    public static final String und = "und";

    public FormatConfiguration(List<?> lines) {
        for (Object line : lines) {
            if (line == null) continue;
            SupportSpec supportSpec = this.parseSupportLine(line.toString());
            if (supportSpec.isValid()) {
                this.supportSpecs.add(supportSpec);
                continue;
            }
            logger.warn("Invalid configuration line: " + line);
        }
    }

    public void parse(DLNAMediaInfo media, InputFile file, Format ext, int type) {
        boolean forceV1 = false;
        if (file.getFile() != null) {
            String fName = file.getFile().getName().toLowerCase();
            for (String e : PARSER_V1_EXTENSIONS) {
                if (!fName.endsWith(e)) continue;
                forceV1 = true;
                break;
            }
            if (forceV1) {
                media.parse(file, ext, type, false);
            } else {
                LibMediaInfoParser.parse(media, file, type);
            }
        } else {
            media.parse(file, ext, type, false);
        }
    }

    @Deprecated
    public boolean isDVDVideoRemuxSupported() {
        return this.match(MPEGPS, MPEG2, null) != null;
    }

    public boolean isFormatSupported(String container) {
        return this.match(container, null, null) != null;
    }

    public boolean isDTSSupported() {
        return this.match(MPEGPS, null, DTS) != null || this.match(MPEGTS, null, DTS) != null;
    }

    public boolean isLPCMSupported() {
        return this.match(MPEGPS, null, LPCM) != null || this.match(MPEGTS, null, LPCM) != null;
    }

    public boolean isMpeg2Supported() {
        return this.match(MPEGPS, MPEG2, null) != null || this.match(MPEGTS, MPEG2, null) != null;
    }

    @Deprecated
    public boolean isHiFiMusicFileSupported() {
        return this.match(WAV, null, null, 0, 96000, 0, 0, 0, null) != null || this.match(MP3, null, null, 0, 96000, 0, 0, 0, null) != null;
    }

    public String getPrimaryVideoTranscoder() {
        for (SupportSpec supportSpec : this.supportSpecs) {
            if (supportSpec.match(MPEGPS, MPEG2, AC3)) {
                return MPEGPS;
            }
            if (supportSpec.match(MPEGTS, MPEG2, AC3)) {
                return MPEGTS;
            }
            if (!supportSpec.match(WMV, WMV, WMA)) continue;
            return WMV;
        }
        return null;
    }

    @Deprecated
    public String getPrimaryAudioTranscoder() {
        for (SupportSpec supportSpec : this.supportSpecs) {
            if (supportSpec.match(WAV, null, null)) {
                return WAV;
            }
            if (!supportSpec.match(MP3, null, null)) continue;
            return MP3;
        }
        return null;
    }

    public String match(DLNAMediaInfo media) {
        if (media.getFirstAudioTrack() == null) {
            return this.match(media.getContainer(), media.getCodecV(), null, 0, 0, media.getBitrate(), media.getWidth(), media.getHeight(), media.getExtras());
        }
        String finalMimeType = null;
        for (DLNAMediaAudio audio : media.getAudioTracksList()) {
            String mimeType;
            finalMimeType = mimeType = this.match(media.getContainer(), media.getCodecV(), audio.getCodecA(), audio.getAudioProperties().getNumberOfChannels(), audio.getSampleRate(), media.getBitrate(), media.getWidth(), media.getHeight(), media.getExtras());
            if (mimeType != null) continue;
            return null;
        }
        return finalMimeType;
    }

    public String match(String container, String videoCodec, String audioCodec) {
        return this.match(container, videoCodec, audioCodec, 0, 0, 0, 0, 0, null);
    }

    public String match(String container, String videoCodec, String audioCodec, int nbAudioChannels, int frequency, int bitrate, int videoWidth, int videoHeight, Map<String, String> extras) {
        String matchedMimeType = null;
        for (SupportSpec supportSpec : this.supportSpecs) {
            if (!supportSpec.match(container, videoCodec, audioCodec, nbAudioChannels, frequency, bitrate, videoWidth, videoHeight, extras)) continue;
            matchedMimeType = supportSpec.mimeType;
            break;
        }
        return matchedMimeType;
    }

    private SupportSpec parseSupportLine(String line) {
        StringTokenizer st = new StringTokenizer(line, "\t ");
        SupportSpec supportSpec = new SupportSpec();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("f:")) {
                supportSpec.format = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("v:")) {
                supportSpec.videoCodec = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("a:")) {
                supportSpec.audioCodec = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("n:")) {
                supportSpec.maxNbChannels = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("s:")) {
                supportSpec.maxFrequency = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("w:")) {
                supportSpec.maxVideoWidth = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("h:")) {
                supportSpec.maxVideoHeight = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("m:")) {
                supportSpec.mimeType = token.substring(2).trim();
                continue;
            }
            if (token.startsWith("b:")) {
                supportSpec.maxBitrate = token.substring(2).trim();
                continue;
            }
            if (!token.contains(":")) continue;
            if (supportSpec.miExtras == null) {
                supportSpec.miExtras = new HashMap();
            }
            String key = token.substring(0, token.indexOf(":"));
            String value = token.substring(token.indexOf(":") + 1);
            supportSpec.miExtras.put(key, Pattern.compile(value));
        }
        return supportSpec;
    }

    private class SupportSpec {
        private int iMaxBitrate = Integer.MAX_VALUE;
        private int iMaxFrequency = Integer.MAX_VALUE;
        private int iMaxNbChannels = Integer.MAX_VALUE;
        private int iMaxVideoHeight = Integer.MAX_VALUE;
        private int iMaxVideoWidth = Integer.MAX_VALUE;
        private Map<String, Pattern> miExtras;
        private Pattern pAudioCodec;
        private Pattern pFormat;
        private Pattern pVideoCodec;
        private String audioCodec;
        private String format;
        private String line;
        private String maxBitrate;
        private String maxFrequency;
        private String maxNbChannels;
        private String maxVideoHeight;
        private String maxVideoWidth;
        private String mimeType = "MIMETYPE_AUTO";
        private String videoCodec;

        SupportSpec() {
        }

        boolean isValid() {
            if (StringUtils.isBlank(this.format)) {
                logger.warn("No format supplied");
                return false;
            }
            try {
                this.pFormat = Pattern.compile(this.format);
            }
            catch (PatternSyntaxException pse) {
                logger.error("Error parsing format: " + this.format, pse);
                return false;
            }
            if (this.videoCodec != null) {
                try {
                    this.pVideoCodec = Pattern.compile(this.videoCodec);
                }
                catch (PatternSyntaxException pse) {
                    logger.error("Error parsing video codec: " + this.videoCodec, pse);
                    return false;
                }
            }
            if (this.audioCodec != null) {
                try {
                    this.pAudioCodec = Pattern.compile(this.audioCodec);
                }
                catch (PatternSyntaxException pse) {
                    logger.error("Error parsing audio codec: " + this.audioCodec, pse);
                    return false;
                }
            }
            if (this.maxNbChannels != null) {
                try {
                    this.iMaxNbChannels = Integer.parseInt(this.maxNbChannels);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Error parsing number of channels: " + this.maxNbChannels, nfe);
                    return false;
                }
            }
            if (this.maxFrequency != null) {
                try {
                    this.iMaxFrequency = Integer.parseInt(this.maxFrequency);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Error parsing maximum frequency: " + this.maxFrequency, nfe);
                    return false;
                }
            }
            if (this.maxBitrate != null) {
                try {
                    this.iMaxBitrate = Integer.parseInt(this.maxBitrate);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Error parsing maximum bitrate: " + this.maxBitrate, nfe);
                    return false;
                }
            }
            if (this.maxVideoWidth != null) {
                try {
                    this.iMaxVideoWidth = Integer.parseInt(this.maxVideoWidth);
                }
                catch (Exception nfe) {
                    logger.error("Error parsing maximum video width: " + this.maxVideoWidth, nfe);
                    return false;
                }
            }
            if (this.maxVideoHeight != null) {
                try {
                    this.iMaxVideoHeight = Integer.parseInt(this.maxVideoHeight);
                }
                catch (NumberFormatException nfe) {
                    logger.error("Error parsing maximum video height: " + this.maxVideoHeight, nfe);
                    return false;
                }
            }
            return true;
        }

        public boolean match(String container, String videoCodec, String audioCodec) {
            return this.match(container, videoCodec, audioCodec, 0, 0, 0, 0, 0, null);
        }

        public boolean match(String format, String videoCodec, String audioCodec, int nbAudioChannels, int frequency, int bitrate, int videoWidth, int videoHeight, Map<String, String> extras) {
            boolean matched = false;
            if (format != null && !(matched = this.pFormat.matcher(format).matches())) {
                return false;
            }
            if (matched && videoCodec != null && this.pVideoCodec != null && !(matched = this.pVideoCodec.matcher(videoCodec).matches())) {
                return false;
            }
            if (matched && audioCodec != null && this.pAudioCodec != null && !(matched = this.pAudioCodec.matcher(audioCodec).matches())) {
                return false;
            }
            if (matched && nbAudioChannels > 0 && this.iMaxNbChannels > 0 && nbAudioChannels > this.iMaxNbChannels) {
                return false;
            }
            if (matched && frequency > 0 && this.iMaxFrequency > 0 && frequency > this.iMaxFrequency) {
                return false;
            }
            if (matched && bitrate > 0 && this.iMaxBitrate > 0 && bitrate > this.iMaxBitrate) {
                return false;
            }
            if (matched && videoWidth > 0 && this.iMaxVideoWidth > 0 && videoWidth > this.iMaxVideoWidth) {
                return false;
            }
            if (matched && videoHeight > 0 && this.iMaxVideoHeight > 0 && videoHeight > this.iMaxVideoHeight) {
                return false;
            }
            if (matched && extras != null && this.miExtras != null) {
                for (String key : extras.keySet()) {
                    String value = extras.get(key);
                    if (matched && key.equals(FormatConfiguration.MI_QPEL) && this.miExtras.get(FormatConfiguration.MI_QPEL) != null) {
                        matched = this.miExtras.get(FormatConfiguration.MI_QPEL).matcher(value).matches();
                        continue;
                    }
                    if (!matched || !key.equals(FormatConfiguration.MI_GMC) || this.miExtras.get(FormatConfiguration.MI_GMC) == null) continue;
                    matched = this.miExtras.get(FormatConfiguration.MI_GMC).matcher(value).matches();
                }
            }
            return matched;
        }
    }
}

