/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.InputFile;
import net.pms.dlna.MediaInfo;
import net.pms.formats.v2.SubtitleType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibMediaInfoParser {
    private static final Logger logger = LoggerFactory.getLogger(LibMediaInfoParser.class);
    private static final String YEAR_REGEX = ".*([\\d]{4}).*";
    private static final Pattern yearPattern = Pattern.compile(".*([\\d]{4}).*");
    private static MediaInfo MI = new MediaInfo();
    private static Base64 base64;

    public static boolean isValid() {
        return MI.isValid();
    }

    public static void close() {
        try {
            MI.finalize();
        }
        catch (Throwable e) {
            logger.debug("Caught exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void parse(DLNAMediaInfo media, InputFile inputFile, int type) {
        File file = inputFile.getFile();
        if (!media.isMediaparsed() && file != null && MI.isValid() && MI.Open(file.getAbsolutePath()) > 0) {
            try {
                String info = MI.Inform();
                MediaInfo.StreamType streamType = MediaInfo.StreamType.General;
                DLNAMediaAudio currentAudioTrack = new DLNAMediaAudio();
                boolean audioPrepped = false;
                DLNAMediaSubtitle currentSubTrack = new DLNAMediaSubtitle();
                boolean subPrepped = false;
                if (StringUtils.isNotBlank(info)) {
                    media.setSize(file.length());
                    StringTokenizer st = new StringTokenizer(info, "\n\r");
                    while (st.hasMoreTokens()) {
                        int point;
                        String line = st.nextToken().trim();
                        if (line.equals("Video") || line.startsWith("Video #")) {
                            streamType = MediaInfo.StreamType.Video;
                        } else if (line.equals("Audio") || line.startsWith("Audio #")) {
                            if (audioPrepped) {
                                LibMediaInfoParser.addAudio(currentAudioTrack, media);
                                currentAudioTrack = new DLNAMediaAudio();
                            }
                            audioPrepped = true;
                            streamType = MediaInfo.StreamType.Audio;
                        } else if (line.equals("Text") || line.startsWith("Text #")) {
                            if (subPrepped) {
                                LibMediaInfoParser.addSub(currentSubTrack, media);
                                currentSubTrack = new DLNAMediaSubtitle();
                            }
                            subPrepped = true;
                            streamType = MediaInfo.StreamType.Text;
                        } else if (line.equals("Menu") || line.startsWith("Menu #")) {
                            streamType = MediaInfo.StreamType.Menu;
                        } else if (line.equals("Chapters")) {
                            streamType = MediaInfo.StreamType.Chapters;
                        }
                        if ((point = line.indexOf(":")) <= -1) continue;
                        String key = line.substring(0, point).trim();
                        String ovalue = line.substring(point + 1).trim();
                        String value = ovalue.toLowerCase();
                        if (key.equals("Format") || key.startsWith("Format_Version") || key.startsWith("Format_Profile")) {
                            if (streamType == MediaInfo.StreamType.Text) {
                                currentSubTrack.setType(SubtitleType.valueOfLibMediaInfoCodec(value));
                                continue;
                            }
                            LibMediaInfoParser.getFormat(streamType, media, currentAudioTrack, value, file);
                            continue;
                        }
                        if (key.equals("Duration/String1") && streamType == MediaInfo.StreamType.General) {
                            media.setDuration(LibMediaInfoParser.getDuration(value));
                            continue;
                        }
                        if (key.equals("Format_Settings_RefFrames/String") && streamType == MediaInfo.StreamType.Video) {
                            media.setReferenceFrameCount(LibMediaInfoParser.getReferenceFrameCount(value));
                            continue;
                        }
                        if (key.equals("Format_Settings_QPel") && streamType == MediaInfo.StreamType.Video) {
                            media.putExtra("qpel", value);
                            continue;
                        }
                        if (key.equals("Format_Settings_GMC") && streamType == MediaInfo.StreamType.Video) {
                            media.putExtra("gmc", value);
                            continue;
                        }
                        if (key.equals("MuxingMode") && streamType == MediaInfo.StreamType.Video) {
                            media.setMuxingMode(ovalue);
                            continue;
                        }
                        if (key.equals("CodecID")) {
                            if (streamType == MediaInfo.StreamType.Text) {
                                currentSubTrack.setType(SubtitleType.valueOfLibMediaInfoCodec(value));
                                continue;
                            }
                            LibMediaInfoParser.getFormat(streamType, media, currentAudioTrack, value, file);
                            continue;
                        }
                        if (key.equals("Language/String")) {
                            if (streamType == MediaInfo.StreamType.Audio) {
                                currentAudioTrack.setLang(LibMediaInfoParser.getLang(value));
                                continue;
                            }
                            if (streamType != MediaInfo.StreamType.Text) continue;
                            currentSubTrack.setLang(LibMediaInfoParser.getLang(value));
                            continue;
                        }
                        if (key.equals("Title")) {
                            if (streamType == MediaInfo.StreamType.Audio) {
                                currentAudioTrack.setFlavor(LibMediaInfoParser.getFlavor(value));
                                continue;
                            }
                            if (streamType != MediaInfo.StreamType.Text) continue;
                            currentSubTrack.setFlavor(LibMediaInfoParser.getFlavor(value));
                            continue;
                        }
                        if (key.equals("Width")) {
                            media.setWidth(LibMediaInfoParser.getPixelValue(value));
                            continue;
                        }
                        if (key.equals("Encryption") && !media.isEncrypted()) {
                            media.setEncrypted("encrypted".equals(value));
                            continue;
                        }
                        if (key.equals("Height")) {
                            media.setHeight(LibMediaInfoParser.getPixelValue(value));
                            continue;
                        }
                        if (key.equals("DisplayAspectRatio/String")) {
                            media.setAspectRatioContainer(value);
                            continue;
                        }
                        if (key.equals("DisplayAspectRatio_Original/Stri")) {
                            media.setAspectRatioVideoTrack(value);
                            continue;
                        }
                        if (key.equals("FrameRate")) {
                            media.setFrameRate(LibMediaInfoParser.getFPSValue(value));
                            continue;
                        }
                        if (key.equals("FrameRateMode")) {
                            media.setFrameRateMode(LibMediaInfoParser.getFrameRateModeValue(value));
                            continue;
                        }
                        if (key.equals("OverallBitRate")) {
                            if (streamType != MediaInfo.StreamType.General) continue;
                            media.setBitrate(LibMediaInfoParser.getBitrate(value));
                            continue;
                        }
                        if (key.equals("Channel(s)")) {
                            if (streamType != MediaInfo.StreamType.Audio) continue;
                            currentAudioTrack.getAudioProperties().setNumberOfChannels(value);
                            continue;
                        }
                        if (key.equals("BitRate")) {
                            if (streamType != MediaInfo.StreamType.Audio) continue;
                            currentAudioTrack.setBitRate(LibMediaInfoParser.getBitrate(value));
                            continue;
                        }
                        if (key.equals("SamplingRate")) {
                            if (streamType != MediaInfo.StreamType.Audio) continue;
                            currentAudioTrack.setSampleFrequency(LibMediaInfoParser.getSampleFrequency(value));
                            continue;
                        }
                        if (key.equals("ID/String")) {
                            if (value.contains("(0x") && !"ogg".equals(media.getContainer())) {
                                if (streamType == MediaInfo.StreamType.Audio) {
                                    currentAudioTrack.setId(LibMediaInfoParser.getSpecificID(value));
                                    continue;
                                }
                                if (streamType != MediaInfo.StreamType.Text) continue;
                                currentSubTrack.setId(LibMediaInfoParser.getSpecificID(value));
                                continue;
                            }
                            if (streamType == MediaInfo.StreamType.Audio) {
                                currentAudioTrack.setId(media.getAudioTracksList().size());
                                continue;
                            }
                            if (streamType != MediaInfo.StreamType.Text) continue;
                            currentSubTrack.setId(media.getSubtitleTracksList().size());
                            continue;
                        }
                        if (key.equals("Cover_Data") && streamType == MediaInfo.StreamType.General) {
                            media.setThumb(LibMediaInfoParser.getCover(ovalue));
                            continue;
                        }
                        if (key.equals("Track") && streamType == MediaInfo.StreamType.General) {
                            currentAudioTrack.setSongname(ovalue);
                            continue;
                        }
                        if (key.equals("Album") && streamType == MediaInfo.StreamType.General) {
                            currentAudioTrack.setAlbum(ovalue);
                            continue;
                        }
                        if (key.equals("Performer") && streamType == MediaInfo.StreamType.General) {
                            currentAudioTrack.setArtist(ovalue);
                            continue;
                        }
                        if (key.equals("Genre") && streamType == MediaInfo.StreamType.General) {
                            currentAudioTrack.setGenre(ovalue);
                            continue;
                        }
                        if (key.equals("Recorded_Date") && streamType == MediaInfo.StreamType.General) {
                            Matcher matcher = yearPattern.matcher(value);
                            if (!matcher.matches()) continue;
                            try {
                                currentAudioTrack.setYear(Integer.parseInt(matcher.group(1)));
                            }
                            catch (NumberFormatException nfe) {
                                logger.debug("Could not parse year from recorded date \"" + value + "\"");
                            }
                            continue;
                        }
                        if (key.equals("Track/Position") && streamType == MediaInfo.StreamType.General) {
                            try {
                                currentAudioTrack.setTrack(Integer.parseInt(value));
                            }
                            catch (NumberFormatException nfe) {
                                logger.debug("Could not parse track \"" + value + "\"");
                            }
                            continue;
                        }
                        if (key.equals("BitDepth") && streamType == MediaInfo.StreamType.Audio) {
                            try {
                                currentAudioTrack.setBitsperSample(Integer.parseInt(value));
                            }
                            catch (NumberFormatException nfe) {
                                logger.debug("Could not parse bits per sample \"" + value + "\"");
                            }
                            continue;
                        }
                        if (!key.equals("Video_Delay") || streamType != MediaInfo.StreamType.Audio) continue;
                        try {
                            currentAudioTrack.getAudioProperties().setAudioDelay(value);
                        }
                        catch (NumberFormatException nfe) {
                            logger.debug("Could not parse delay \"" + value + "\"");
                        }
                    }
                }
                if (audioPrepped) {
                    LibMediaInfoParser.addAudio(currentAudioTrack, media);
                }
                if (subPrepped) {
                    LibMediaInfoParser.addSub(currentSubTrack, media);
                }
                if ("mp4".equals(media.getContainer()) && StringUtils.isBlank(media.getCodecV()) && media.getAudioTracksList() != null && media.getAudioTracksList().size() == 1 && "aac".equals(media.getAudioTracksList().get(0).getCodecA())) {
                    media.setContainer("aac");
                }
                media.finalize(type, inputFile);
            }
            catch (Exception e) {
                logger.error("Error in MediaInfo parsing:", e);
            }
            finally {
                MI.Close();
                if (media.getContainer() == null) {
                    media.setContainer("und");
                }
                if (media.getCodecV() == null) {
                    media.setCodecV("und");
                }
                media.setMediaparsed(true);
            }
        }
    }

    public static void addAudio(DLNAMediaAudio currentAudioTrack, DLNAMediaInfo media) {
        if (currentAudioTrack.getLang() == null) {
            currentAudioTrack.setLang("und");
        }
        if (currentAudioTrack.getCodecA() == null) {
            currentAudioTrack.setCodecA("und");
        }
        media.getAudioTracksList().add(currentAudioTrack);
    }

    public static void addSub(DLNAMediaSubtitle currentSubTrack, DLNAMediaInfo media) {
        if (currentSubTrack.getType() == SubtitleType.UNSUPPORTED) {
            return;
        }
        if (currentSubTrack.getLang() == null) {
            currentSubTrack.setLang("und");
        }
        media.getSubtitleTracksList().add(currentSubTrack);
    }

    @Deprecated
    public static void getFormat(MediaInfo.StreamType streamType, DLNAMediaInfo media, DLNAMediaAudio audio, String value) {
        LibMediaInfoParser.getFormat(streamType, media, audio, value, null);
    }

    private static void getFormat(MediaInfo.StreamType streamType, DLNAMediaInfo media, DLNAMediaAudio audio, String value, File file) {
        String format = null;
        if (value.equals("matroska")) {
            format = "mkv";
        } else if (value.equals("avi") || value.equals("opendml")) {
            format = "avi";
        } else if (value.startsWith("flash")) {
            format = "flv";
        } else if (value.toLowerCase().equals("webm")) {
            format = "WebM";
        } else if (value.equals("qt") || value.equals("quicktime")) {
            format = "mov";
        } else if (value.equals("isom") || value.startsWith("mp4") || value.equals("20") || value.equals("m4v") || value.startsWith("mpeg-4")) {
            format = "mp4";
        } else if (value.contains("mpeg-ps")) {
            format = "mpegps";
        } else if (value.contains("mpeg-ts") || value.equals("bdav")) {
            format = "mpegts";
        } else if (value.contains("aiff")) {
            format = "aiff";
        } else if (value.contains("ogg")) {
            format = "ogg";
        } else if (value.contains("realmedia") || value.startsWith("rv") || value.startsWith("cook")) {
            format = "rm";
        } else if (value.contains("windows media") || value.equals("wmv1") || value.equals("wmv2") || value.equals("wmv7") || value.equals("wmv8")) {
            format = "wmv";
        } else if (value.contains("mjpg") || value.contains("m-jpeg")) {
            format = "mjpeg";
        } else if (value.startsWith("avc") || value.contains("h264")) {
            format = "h264";
        } else if (value.contains("xvid")) {
            format = "mp4";
        } else if (value.contains("mjpg") || value.contains("m-jpeg")) {
            format = "mjpeg";
        } else if (value.contains("div") || value.contains("dx")) {
            format = "divx";
        } else if (value.matches("(?i)(dv)|(cdv.?)|(dc25)|(dcap)|(dvc.?)|(dvs.?)|(dvrs)|(dv25)|(dv50)|(dvan)|(dvh.?)|(dvis)|(dvl.?)|(dvnm)|(dvp.?)|(mdvf)|(pdvc)|(r411)|(r420)|(sdcc)|(sl25)|(sl50)|(sldv)")) {
            format = "dv";
        } else if (value.contains("mpeg video")) {
            format = "mpeg2";
        } else if (value.equals("vc-1") || value.equals("vc1") || value.equals("wvc1") || value.equals("wmv3") || value.equals("wmv9") || value.equals("wmva")) {
            format = "vc1";
        } else if (value.equals("version 1")) {
            if (media.getCodecV() != null && media.getCodecV().equals("mpeg2") && audio.getCodecA() == null) {
                format = "mpeg1";
            }
        } else if (value.equals("layer 3")) {
            if (audio.getCodecA() != null && audio.getCodecA().equals("mpa")) {
                format = "mp3";
                if (media.getContainer() != null && media.getContainer().equals("mpa")) {
                    media.setContainer("mp3");
                }
            }
        } else if (value.equals("ma")) {
            if (audio.getCodecA() != null && audio.getCodecA().equals("dts")) {
                format = "dtshd";
            }
        } else if (value.equals("vorbis") || value.equals("a_vorbis")) {
            format = "ogg";
        } else if (value.equals("ac-3") || value.equals("a_ac3") || value.equals("2000")) {
            format = "ac3";
        } else if (value.equals("e-ac-3")) {
            format = "eac3";
        } else if (value.contains("truehd")) {
            format = "truehd";
        } else if (value.equals("55") || value.equals("a_mpeg/l3")) {
            format = "mp3";
        } else if (value.equals("m4a") || value.equals("40") || value.equals("a_aac") || value.equals("aac")) {
            format = "aac";
        } else if (value.equals("pcm") || value.equals("1") && (audio.getCodecA() == null || !audio.getCodecA().equals("dts"))) {
            format = "lpcm";
        } else if (value.equals("alac")) {
            format = "alac";
        } else if (value.equals("wave")) {
            format = "wav";
        } else if (value.equals("shorten")) {
            format = "shn";
        } else if (value.equals("dts") || value.equals("a_dts") || value.equals("8")) {
            format = "dts";
        } else if (value.equals("mpeg audio")) {
            format = "mpa";
        } else if (value.equals("161") || value.startsWith("wma")) {
            format = "wma";
            if (media.getCodecV() == null) {
                media.setContainer("wma");
            }
        } else if (value.equals("flac")) {
            format = "flac";
        } else if (value.equals("monkey's audio")) {
            format = "ape";
        } else if (value.contains("musepack")) {
            format = "mpc";
        } else if (value.contains("wavpack")) {
            format = "wavpack";
        } else if (value.contains("mlp")) {
            format = "mlp";
        } else if (value.contains("atrac3")) {
            format = "atrac";
            if (media.getCodecV() == null) {
                media.setContainer("atrac");
            }
        } else if (value.equals("jpeg")) {
            format = "jpg";
        } else if (value.equals("png")) {
            format = "png";
        } else if (value.equals("gif")) {
            format = "gif";
        } else if (value.equals("bitmap")) {
            format = "bmp";
        } else if (value.equals("tiff")) {
            format = "tiff";
        } else if (StringUtils.contains((CharSequence)value, "@l") && streamType == MediaInfo.StreamType.Video) {
            media.setAvcLevel(LibMediaInfoParser.getAvcLevel(value));
        }
        if (format != null) {
            if (streamType == MediaInfo.StreamType.General) {
                media.setContainer(format);
            } else if (streamType == MediaInfo.StreamType.Video) {
                media.setCodecV(format);
            } else if (streamType == MediaInfo.StreamType.Audio) {
                audio.setCodecA(format);
            }
        }
    }

    public static int getPixelValue(String value) {
        if (value.indexOf("pixel") > -1) {
            value = value.substring(0, value.indexOf("pixel"));
        }
        if ((value = value.trim()).contains("/")) {
            value = value.substring(0, value.indexOf("/")).trim();
        }
        int pixels = Integer.parseInt(value);
        return pixels;
    }

    public static byte getReferenceFrameCount(String value) {
        try {
            return Byte.parseByte(StringUtils.substringBefore(value, " "));
        }
        catch (NumberFormatException ex) {
            logger.warn("Could not parse ReferenceFrameCount value {}.", (Object)value);
            logger.warn("Exception: ", ex);
            return -1;
        }
    }

    public static String getAvcLevel(String value) {
        String avcLevel = StringUtils.substringAfterLast(StringUtils.lowerCase(value), "@l");
        if (StringUtils.isNotBlank(avcLevel)) {
            return avcLevel;
        }
        logger.warn("Could not parse AvcLevel value {}.", (Object)value);
        return null;
    }

    public static int getBitrate(String value) {
        if (value.contains("/")) {
            value = value.substring(0, value.indexOf("/")).trim();
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.trace("Could not parse bitrate from: " + value);
            logger.trace("The full error was: " + e);
            return 0;
        }
    }

    public static int getSpecificID(String value) {
        if (value.indexOf("(0x") > -1) {
            value = value.substring(0, value.indexOf("(0x"));
        }
        value = value.trim();
        int id = Integer.parseInt(value);
        return id;
    }

    public static String getSampleFrequency(String value) {
        if (value.indexOf("/") > -1) {
            value = value.substring(0, value.indexOf("/"));
        }
        if (value.indexOf("khz") > -1) {
            value = value.substring(0, value.indexOf("khz"));
        }
        value = value.trim();
        return value;
    }

    public static String getFPSValue(String value) {
        if (value.indexOf("fps") > -1) {
            value = value.substring(0, value.indexOf("fps"));
        }
        value = value.trim();
        return value;
    }

    public static String getFrameRateModeValue(String value) {
        if (value.indexOf("/") > -1) {
            value = value.substring(0, value.indexOf("/"));
        }
        value = value.trim();
        return value;
    }

    public static String getLang(String value) {
        if (value.indexOf("(") > -1) {
            value = value.substring(0, value.indexOf("("));
        }
        if (value.indexOf("/") > -1) {
            value = value.substring(0, value.indexOf("/"));
        }
        value = value.trim();
        return value;
    }

    public static String getFlavor(String value) {
        value = value.trim();
        return value;
    }

    private static double getDuration(String value) {
        int h = 0;
        int m = 0;
        int s = 0;
        StringTokenizer st = new StringTokenizer(value, " ");
        while (st.hasMoreTokens()) {
            int sl;
            int msl;
            int mnl;
            String token = st.nextToken();
            int hl = token.indexOf("h");
            if (hl > -1) {
                h = Integer.parseInt(token.substring(0, hl).trim());
            }
            if ((mnl = token.indexOf("mn")) > -1) {
                m = Integer.parseInt(token.substring(0, mnl).trim());
            }
            if ((msl = token.indexOf("ms")) != -1 || (sl = token.indexOf("s")) <= -1) continue;
            s = Integer.parseInt(token.substring(0, sl).trim());
        }
        return h * 3600 + m * 60 + s;
    }

    public static byte[] getCover(String based64Value) {
        try {
            if (base64 != null) {
                return base64.decode(based64Value.getBytes());
            }
        }
        catch (Exception e) {
            logger.error("Error in decoding thumbnail data", e);
        }
        return null;
    }

    static {
        if (MI.isValid()) {
            MI.Option("Complete", "1");
            MI.Option("Language", "raw");
        }
        base64 = new Base64();
    }
}

