/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.pms.PMS;
import net.pms.encoders.Track;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.io.Gob;
import net.pms.io.OutputParams;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperLiteImpl;
import net.pms.util.H264AnnexBInputStream;
import net.pms.util.PCMAudioOutputStream;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviDemuxerInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(AviDemuxerInputStream.class);
    private Process process;
    private InputStream stream;
    private ArrayList<ProcessWrapper> attachedProcesses;
    private long readCount = -1L;
    private String streamVideoTag;
    private Track[] track = new Track[2];
    private int numberOfAudioChannels;
    private OutputStream aOut;
    private OutputStream vOut;
    private long audiosize;
    private long videosize;
    private InputStream realIS;
    private Thread parsing;
    private OutputParams params;

    @Override
    public void close() throws IOException {
        if (this.process != null) {
            ProcessUtil.destroy(this.process);
        }
        super.close();
    }

    public AviDemuxerInputStream(InputStream fin, final OutputParams params, ArrayList<ProcessWrapper> at) throws IOException {
        this.stream = fin;
        logger.trace("Opening AVI Stream");
        this.attachedProcesses = at;
        this.params = params;
        this.aOut = params.output_pipes[1].getOutputStream();
        if (params.no_videoencode && params.forceType != null && params.forceType.equals("V_MPEG4/ISO/AVC") && params.header != null) {
            PipedOutputStream pout = new PipedOutputStream();
            final H264AnnexBInputStream pin = new H264AnnexBInputStream(new PipedInputStream(pout), params.header);
            final OutputStream out = params.output_pipes[0].getOutputStream();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] b = new byte[524288];
                        int n = -1;
                        while ((n = pin.read(b)) > -1) {
                            out.write(b, 0, n);
                        }
                    }
                    catch (Exception e) {
                        logger.error(null, e);
                    }
                }
            };
            ((InputStream)pin).close();
            this.vOut = pout;
            new Thread(r, "Avi Demuxer").start();
        } else {
            this.vOut = params.output_pipes[0].getOutputStream();
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    TsMuxeRVideo ts = new TsMuxeRVideo(PMS.getConfiguration());
                    File f = new File(PMS.getConfiguration().getTempFolder(), "pms-tsmuxer.meta");
                    PrintWriter pw = new PrintWriter(f);
                    pw.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
                    String videoType = "V_MPEG-2";
                    if (params.no_videoencode && params.forceType != null) {
                        videoType = params.forceType;
                    }
                    String fps = "";
                    if (params.forceFps != null) {
                        fps = "fps=" + params.forceFps + ", ";
                    }
                    String audioType = "A_LPCM";
                    if (params.lossyaudio) {
                        audioType = "A_AC3";
                    }
                    pw.println(videoType + ", \"" + params.output_pipes[0].getOutputPipe() + "\", " + fps + "level=4.1, insertSEI, contSPS, track=1");
                    pw.println(audioType + ", \"" + params.output_pipes[1].getOutputPipe() + "\", track=2");
                    pw.close();
                    PipeProcess tsPipe = new PipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
                    ProcessWrapper pipe_process = tsPipe.getPipeProcess();
                    AviDemuxerInputStream.this.attachedProcesses.add(pipe_process);
                    pipe_process.runInNewThread();
                    tsPipe.deleteLater();
                    String[] cmd = new String[]{ts.executable(), f.getAbsolutePath(), tsPipe.getInputPipe()};
                    ProcessBuilder pb = new ProcessBuilder(cmd);
                    AviDemuxerInputStream.this.process = pb.start();
                    ProcessWrapperLiteImpl pwi = new ProcessWrapperLiteImpl(AviDemuxerInputStream.this.process);
                    AviDemuxerInputStream.this.attachedProcesses.add(pwi);
                    new Gob(AviDemuxerInputStream.this.process.getErrorStream()).start();
                    new Gob(AviDemuxerInputStream.this.process.getInputStream()).start();
                    AviDemuxerInputStream.this.realIS = tsPipe.getInputStream();
                    ProcessUtil.waitFor(AviDemuxerInputStream.this.process);
                    logger.trace("tsMuxeR muxing finished");
                }
                catch (IOException e) {
                    logger.error(null, e);
                }
            }
        };
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                try {
                    AviDemuxerInputStream.this.parseHeader();
                }
                catch (IOException e) {
                    logger.debug("Parsing error", e);
                }
            }
        };
        logger.trace("Launching tsMuxeR muxing");
        new Thread(r, "Avi Demuxer tsMuxeR").start();
        this.parsing = new Thread(r2, "Avi Demuxer Header Parser");
        logger.trace("Ready to mux");
    }

    private void parseHeader() throws IOException {
        int size;
        String command;
        logger.trace("Parsing AVI stream");
        String id = this.getString(this.stream, 4);
        this.getBytes(this.stream, 4);
        String type = this.getString(this.stream, 4);
        if (!"RIFF".equalsIgnoreCase(id) || !"AVI ".equalsIgnoreCase(type)) {
            throw new IOException("Not AVI file");
        }
        byte[] hdrl = null;
        while (true) {
            String command2 = this.getString(this.stream, 4);
            int length = this.readBytes(this.stream, 4) + 1 & 0xFFFFFFFE;
            if ("LIST".equalsIgnoreCase(command2)) {
                command2 = this.getString(this.stream, 4);
                length -= 4;
                if ("movi".equalsIgnoreCase(command2)) break;
                if ("hdrl".equalsIgnoreCase(command2)) {
                    hdrl = this.getBytes(this.stream, length);
                }
                if ("idx1".equalsIgnoreCase(command2)) {
                    this.getBytes(this.stream, length);
                }
                if (!"iddx".equalsIgnoreCase(command2)) continue;
                this.getBytes(this.stream, length);
                continue;
            }
            this.getBytes(this.stream, length);
        }
        int streamNumber = 0;
        int lastTagID = 0;
        int i = 0;
        while (i < hdrl.length) {
            command = new String(hdrl, i, 4);
            size = AviDemuxerInputStream.str2ulong(hdrl, i + 4);
            if ("LIST".equalsIgnoreCase(command)) {
                i += 12;
                continue;
            }
            String command2 = new String(hdrl, i + 8, 4);
            if ("strh".equalsIgnoreCase(command)) {
                lastTagID = 0;
                if ("vids".equalsIgnoreCase(command2)) {
                    String compressor = new String(hdrl, i + 12, 4);
                    int scale = AviDemuxerInputStream.str2ulong(hdrl, i + 28);
                    int rate = AviDemuxerInputStream.str2ulong(hdrl, i + 32);
                    this.track[0] = new Track(compressor, scale, rate, -1);
                    this.streamVideoTag = new String(new char[]{(char)(streamNumber / 10 + 48), (char)(streamNumber % 10 + 48), 'd', 'b'});
                    ++streamNumber;
                    lastTagID = 1;
                }
                if ("auds".equalsIgnoreCase(command2)) {
                    int scale = AviDemuxerInputStream.str2ulong(hdrl, i + 28);
                    int rate = AviDemuxerInputStream.str2ulong(hdrl, i + 32);
                    int sampleSize = AviDemuxerInputStream.str2ulong(hdrl, i + 52);
                    this.track[1 + this.numberOfAudioChannels++] = new Track(null, scale, rate, sampleSize);
                    ++streamNumber;
                    lastTagID = 2;
                }
            }
            if ("strf".equalsIgnoreCase(command)) {
                byte[] information;
                if (lastTagID == 1) {
                    information = new byte[size];
                    System.arraycopy(hdrl, i + 8, information, 0, information.length);
                    this.track[0].setBih(information);
                }
                if (lastTagID == 2) {
                    information = new byte[size];
                    System.arraycopy(hdrl, i + 8, information, 0, information.length);
                    Track aud = this.track[1 + this.numberOfAudioChannels - 1];
                    aud.setBih(information);
                    int bitsPerSample = AviDemuxerInputStream.str2ushort(information, 14);
                    aud.setBitsPerSample(bitsPerSample);
                    int nbAudio = AviDemuxerInputStream.str2ushort(information, 2);
                    aud.setNbAudio(nbAudio);
                    long fileLength = 100L;
                    if (this.params.losslessaudio) {
                        this.aOut = new PCMAudioOutputStream(this.aOut, nbAudio, 48000, bitsPerSample);
                    }
                    if (!this.params.lossyaudio && this.params.losslessaudio) {
                        AviDemuxerInputStream.writePCMHeader(this.aOut, fileLength, nbAudio, aud.getRate(), aud.getSampleSize(), bitsPerSample);
                    }
                }
            }
            if (size % 2 != 0) {
                ++size;
            }
            i += size + 8;
        }
        logger.trace("Found " + streamNumber + " stream(s)");
        boolean init = false;
        while (true) {
            command = null;
            try {
                command = this.getString(this.stream, 4);
            }
            catch (Exception e) {
                logger.trace("Error reading stream: " + e.getMessage());
                break;
            }
            if (command == null) break;
            command = command.toUpperCase();
            size = this.readBytes(this.stream, 4);
            boolean framed = false;
            while ("LIST".equals(command) || "RIFF".equals(command) || "JUNK".equals(command)) {
                if (size < 0) {
                    size = 4;
                }
                this.getBytes(this.stream, "RIFF".equals(command) ? 4 : size);
                command = this.getString(this.stream, 4).toUpperCase();
                size = this.readBytes(this.stream, 4);
                if (!"LIST".equals(command) && !"RIFF".equals(command) && !"JUNK".equals(command) || size % 2 == 0) continue;
                this.readByte(this.stream);
            }
            String videoTag = this.streamVideoTag.substring(0, 3);
            if (command.substring(0, 3).equalsIgnoreCase(videoTag) && (command.charAt(3) == 'B' || command.charAt(3) == 'C')) {
                byte[] buffer = this.getBytes(this.stream, size);
                if (!command.equalsIgnoreCase("IDX1")) {
                    this.vOut.write(buffer);
                    this.videosize += (long)size;
                }
                framed = true;
            }
            if (!framed) {
                for (int i2 = 0; i2 < this.numberOfAudioChannels; ++i2) {
                    byte[] buffer = this.getBytes(this.stream, size);
                    if (!command.equalsIgnoreCase("IDX1")) {
                        this.aOut.write(buffer, init ? 4 : 0, init ? size - 4 : size);
                        init = false;
                        this.audiosize += (long)size;
                    }
                    framed = true;
                }
            }
            if (!framed) {
                throw new IOException("Not header: " + command);
            }
            if (size % 2 == 0) continue;
            this.readByte(this.stream);
        }
        logger.trace("output pipes closed");
        this.aOut.close();
        this.vOut.close();
    }

    private String getString(InputStream input, int sz) throws IOException {
        byte[] bb = this.getBytes(input, sz);
        return new String(bb);
    }

    private byte[] getBytes(InputStream input, int sz) throws IOException {
        int u;
        byte[] bb = new byte[sz];
        for (int n = input.read(bb); n < sz && (u = input.read(bb, n, sz - n)) != -1; n += u) {
        }
        return bb;
    }

    private final int readBytes(InputStream input, int number) throws IOException {
        byte[] buffer = new byte[number];
        int read = input.read(buffer);
        if (read < number) {
            if (read < 0) {
                throw new IOException("End of stream");
            }
            for (int i = read; i < number; ++i) {
                buffer[i] = (byte)this.readByte(input);
            }
        }
        switch (number) {
            case 1: {
                return buffer[0] & 0xFF;
            }
            case 2: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
            }
            case 3: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16;
            }
            case 4: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
            }
        }
        throw new IOException("Illegal Read quantity");
    }

    private final int readByte(InputStream input) throws IOException {
        return input.read();
    }

    public static final int str2ulong(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | (data[i + 3] & 0xFF) << 24;
    }

    public static final int str2ushort(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
    }

    public static final byte[] getLe32(long value) {
        byte[] buffer = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        return buffer;
    }

    public static final byte[] getLe16(int value) {
        byte[] buffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.readCount == -1L) {
            this.parsing.start();
            this.readCount = 0L;
        }
        for (int c = 0; (this.realIS == null || this.videosize == 0L || this.audiosize == 0L) && c < 15; ++c) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                logger.trace("Sleep interrupted", e);
            }
        }
        if (this.realIS != null) {
            ++this.readCount;
            return this.realIS.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.readCount == -1L) {
            this.parsing.start();
            this.readCount = 0L;
        }
        for (int c = 0; (this.realIS == null || this.videosize == 0L || this.audiosize == 0L) && c < 15; ++c) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                logger.trace("Sleep interrupted", e);
            }
        }
        if (this.realIS != null) {
            int n = this.realIS.read(b);
            this.readCount += (long)n;
            return n;
        }
        return -1;
    }

    public static void writePCMHeader(OutputStream aOut, long fileLength, int nbAudio, int rate, int sampleSize, int bitsPerSample) throws IOException {
    }
}

