/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.newgui.ImagePanel;
import net.pms.newgui.LooksFrame;
import net.pms.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutTab {
    private static final Logger logger = LoggerFactory.getLogger(AboutTab.class);
    private ImagePanel imagePanel;
    private JLabel jl;
    private JProgressBar jpb;

    public JProgressBar getJpb() {
        return this.jpb;
    }

    public JLabel getJl() {
        return this.jl;
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public JComponent build() {
        FormLayout layout = new FormLayout("0:grow, pref, 0:grow", "pref, 3dlu, pref, 3dlu, pref, 12dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        String projectName = PropertiesUtil.getProjectProperties().get("project.name");
        LinkMouseListener pms3Link = new LinkMouseListener(projectName + " " + PMS.getVersion(), "http://www.ps3mediaserver.org/");
        JLabel lPms3Link = builder.addLabel(pms3Link.getLabel(), cc.xy(2, 1, "center, fill"));
        lPms3Link.setCursor(Cursor.getPredefinedCursor(12));
        lPms3Link.addMouseListener(pms3Link);
        String commitId = PropertiesUtil.getProjectProperties().get("git.commit.id");
        String commitTime = PropertiesUtil.getProjectProperties().get("git.commit.time");
        String shortCommitId = commitId.substring(0, 9);
        String commitUrl = "https://github.com/ps3mediaserver/ps3mediaserver/commit/" + commitId;
        String buildLabel = Messages.getString("LinksTab.6") + " " + shortCommitId + " (" + commitTime + ")";
        LinkMouseListener commitLink = new LinkMouseListener(buildLabel, commitUrl);
        JLabel lCommitLink = builder.addLabel(commitLink.getLabel(), cc.xy(2, 3, "center, fill"));
        lCommitLink.setCursor(Cursor.getPredefinedCursor(12));
        lCommitLink.addMouseListener(commitLink);
        this.imagePanel = this.buildImagePanel();
        builder.add((Component)this.imagePanel, cc.xy(2, 5, "center, fill"));
        builder.addLabel(Messages.getString("LinksTab.5"), cc.xy(2, 7, "center, fill"));
        LinkMouseListener ffmpegLink = new LinkMouseListener("FFmpeg", "http://ffmpeg.mplayerhq.hu");
        JLabel lFfmpegLink = builder.addLabel(ffmpegLink.getLabel(), cc.xy(2, 9, "center, fill"));
        lFfmpegLink.setCursor(Cursor.getPredefinedCursor(12));
        lFfmpegLink.addMouseListener(ffmpegLink);
        LinkMouseListener mplayerLink = new LinkMouseListener("MPlayer", "http://www.mplayerhq.hu");
        JLabel lMplayerLink = builder.addLabel(mplayerLink.getLabel(), cc.xy(2, 11, "center, fill"));
        lMplayerLink.setCursor(Cursor.getPredefinedCursor(12));
        lMplayerLink.addMouseListener(mplayerLink);
        LinkMouseListener vlcLink = new LinkMouseListener("VLC media player", "http://www.videolan.org/vlc/");
        JLabel lVlcLink = builder.addLabel(vlcLink.getLabel(), cc.xy(2, 13, "center, fill"));
        lVlcLink.setCursor(Cursor.getPredefinedCursor(12));
        lVlcLink.addMouseListener(vlcLink);
        LinkMouseListener mediaInfoLink = new LinkMouseListener("MediaInfo", "http://mediainfo.sourceforge.net/en");
        JLabel lMediaInfoLink = builder.addLabel(mediaInfoLink.getLabel(), cc.xy(2, 15, "center, fill"));
        lMediaInfoLink.setCursor(Cursor.getPredefinedCursor(12));
        lMediaInfoLink.addMouseListener(mediaInfoLink);
        JScrollPane scrollPane = new JScrollPane(builder.getPanel());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    public ImagePanel buildImagePanel() {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(LooksFrame.class.getResourceAsStream("/resources/images/logo.png"));
        }
        catch (IOException e) {
            logger.debug("Caught exception", e);
        }
        return new ImagePanel(bi);
    }

    private static class LinkMouseListener
    implements MouseListener {
        private final String name;
        private final String link;

        public LinkMouseListener(String n, String l) {
            this.name = n;
            this.link = l;
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<a href=\"");
            sb.append(this.link);
            sb.append("\">");
            sb.append(this.name);
            sb.append("</a>");
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                PMS.get().getRegistry().browseURI(this.link);
            }
            catch (Exception e1) {
                logger.debug("Caught exception", e1);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

