/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.HashMap;
import java.util.Set;
import org.jaudiotagger.audio.AudioHeader;

public class GenericAudioHeader
implements AudioHeader {
    public static final String FIELD_BITRATE = "BITRATE";
    public static final String FIELD_CHANNEL = "CHANNB";
    public static final String FIELD_INFOS = "INFOS";
    public static final String FIELD_LENGTH = "LENGTH";
    public static final String FIELD_SAMPLERATE = "SAMPLING";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_VBR = "VBR";
    private boolean isLossless = false;
    protected HashMap<String, Object> content = new HashMap(6);

    public GenericAudioHeader() {
        this.content.put(FIELD_BITRATE, -1);
        this.content.put(FIELD_CHANNEL, -1);
        this.content.put(FIELD_TYPE, "");
        this.content.put(FIELD_INFOS, "");
        this.content.put(FIELD_SAMPLERATE, -1);
        this.content.put(FIELD_LENGTH, Float.valueOf(-1.0f));
        this.content.put(FIELD_VBR, true);
    }

    public String getBitRate() {
        return this.content.get(FIELD_BITRATE).toString();
    }

    public long getBitRateAsNumber() {
        return ((Integer)this.content.get(FIELD_BITRATE)).longValue();
    }

    public int getChannelNumber() {
        return (Integer)this.content.get(FIELD_CHANNEL);
    }

    public String getChannels() {
        return String.valueOf(this.getChannelNumber());
    }

    public String getEncodingType() {
        return (String)this.content.get(FIELD_TYPE);
    }

    public String getFormat() {
        return (String)this.content.get(FIELD_TYPE);
    }

    public String getExtraEncodingInfos() {
        return (String)this.content.get(FIELD_INFOS);
    }

    public int getTrackLength() {
        return (int)this.getPreciseLength();
    }

    public float getPreciseLength() {
        return ((Float)this.content.get(FIELD_LENGTH)).floatValue();
    }

    public String getSampleRate() {
        return this.content.get(FIELD_SAMPLERATE).toString();
    }

    public int getSampleRateAsNumber() {
        return (Integer)this.content.get(FIELD_SAMPLERATE);
    }

    public boolean isVariableBitRate() {
        return (Boolean)this.content.get(FIELD_VBR);
    }

    public boolean isLossless() {
        return this.isLossless;
    }

    public void setBitrate(int bitrate) {
        this.content.put(FIELD_BITRATE, bitrate);
    }

    public void setChannelNumber(int chanNb) {
        this.content.put(FIELD_CHANNEL, chanNb);
    }

    public void setEncodingType(String encodingType) {
        this.content.put(FIELD_TYPE, encodingType);
    }

    public void setExtraEncodingInfos(String infos) {
        this.content.put(FIELD_INFOS, infos);
    }

    public void setLength(int length) {
        this.content.put(FIELD_LENGTH, Float.valueOf(length));
    }

    public void setPreciseLength(float seconds) {
        this.content.put(FIELD_LENGTH, Float.valueOf(seconds));
    }

    public void setSamplingRate(int samplingRate) {
        this.content.put(FIELD_SAMPLERATE, samplingRate);
    }

    public void setVariableBitRate(boolean b) {
        this.content.put(FIELD_VBR, b);
    }

    public void setLossless(boolean b) {
        this.isLossless = b;
    }

    public void setExtra(String key, Object value) {
        this.content.put(key, value);
    }

    public String toString() {
        StringBuffer out = new StringBuffer(50);
        out.append("Encoding infos content:\n");
        Set<String> set = this.content.keySet();
        for (String key : set) {
            Object val = this.content.get(key);
            out.append("\t");
            out.append(key);
            out.append(" : ");
            out.append(val);
            out.append("\n");
        }
        return out.toString().substring(0, out.length() - 1);
    }
}

