---
title: "Drime"
description: "Rclone docs for Drime"
versionIntroduced: "v1.73"
---

# {{< icon "fa fa-cloud" >}} Drime

[Drime](https://drime.cloud/) is a cloud storage and transfer service focused
on fast, resilient file delivery. It offers both free and paid tiers with
emphasis on high-speed uploads and link sharing.

To setup Drime you need to log in, navigate to Settings, Developer, and create a
token to use as an API access key. Give it a sensible name and copy the token
for use in the config.

## Configuration

Here is a run through of `rclone config` to make a remote called `remote`.

Firstly run:


```console
rclone config
```

Then follow through the interactive setup:


```text
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n

Enter name for new remote.
name> remote

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
XX / Drime
   \ (drime)
Storage> drime

Option access_token.
API Access token
You can get this from the web control panel.
Enter a value. Press Enter to leave empty.
access_token> YOUR_API_ACCESS_TOKEN

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: drime
- access_token: YOUR_API_ACCESS_TOKEN
Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

Once configured you can then use `rclone` like this (replace `remote` with the
name you gave your remote):

List directories and files in the top level of your Drime

```console
rclone lsf remote:
```

To copy a local directory to a Drime directory called backup

```console
rclone copy /home/source remote:backup
```


### Modification times and hashes

Drime does not support modification times or hashes.

This means that by default syncs will only use the size of the file to determine
if it needs updating.

You can use the `--update` flag which will use the time the object was uploaded.
For many operations this is sufficient to determine if it has changed. However
files created with timestamps in the past will be missed by the sync if using
`--update`.


### Restricted filename characters

In addition to the [default restricted characters set](/overview/#restricted-characters)
the following characters are also replaced:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| \         | 0x5C  | ＼           |

File names can also not start or end with the following characters. These only
get replaced if they are the first or last character in the name:

| Character | Value | Replacement |
| --------- |:-----:|:-----------:|
| SP        | 0x20  | ␠           |

Invalid UTF-8 bytes will also be [replaced](/overview/#invalid-utf8),
as they can't be used in JSON strings.

### Root folder ID

You can set the `root_folder_id` for rclone.  This is the directory
(identified by its `Folder ID`) that rclone considers to be the root
of your Drime drive.

Normally you will leave this blank and rclone will determine the
correct root to use itself and fill in the value in the config file.

However you can set this to restrict rclone to a specific folder
hierarchy.

In order to do this you will have to find the `Folder ID` of the
directory you wish rclone to display.

You can do this with rclone

```console
$ rclone lsf -Fip --dirs-only remote:
d6341f53-ee65-4f29-9f59-d11e8070b2a0;Files/
f4f5c9b8-6ece-478b-b03e-4538edfe5a1c;Photos/
d50e356c-29ca-4b27-a3a7-494d91026e04;Videos/
```

The ID to use is the part before the `;` so you could set

```text
root_folder_id = d6341f53-ee65-4f29-9f59-d11e8070b2a0
```

To restrict rclone to the `Files` directory.

<!-- autogenerated options start - DO NOT EDIT - instead edit fs.RegInfo in backend/drime/drime.go and run make backenddocs to verify --> <!-- markdownlint-disable-line line-length -->
### Standard options

Here are the Standard options specific to drime (Drime).

#### --drime-access-token

API Access token

You can get this from the web control panel.

Properties:

- Config:      access_token
- Env Var:     RCLONE_DRIME_ACCESS_TOKEN
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to drime (Drime).

#### --drime-root-folder-id

ID of the root folder

Leave this blank normally, rclone will fill it in automatically.

If you want rclone to be restricted to a particular folder you can
fill it in - see the docs for more info.


Properties:

- Config:      root_folder_id
- Env Var:     RCLONE_DRIME_ROOT_FOLDER_ID
- Type:        string
- Required:    false

#### --drime-workspace-id

Account ID

Leave this blank normally unless you wish to specify a Workspace ID.


Properties:

- Config:      workspace_id
- Env Var:     RCLONE_DRIME_WORKSPACE_ID
- Type:        string
- Required:    false

#### --drime-list-chunk

Number of items to list in each call

Properties:

- Config:      list_chunk
- Env Var:     RCLONE_DRIME_LIST_CHUNK
- Type:        int
- Default:     1000

#### --drime-hard-delete

Delete files permanently rather than putting them into the trash.

Properties:

- Config:      hard_delete
- Env Var:     RCLONE_DRIME_HARD_DELETE
- Type:        bool
- Default:     false

#### --drime-upload-cutoff

Cutoff for switching to chunked upload.

Any files larger than this will be uploaded in chunks of chunk_size.
The minimum is 0 and the maximum is 5 GiB.

Properties:

- Config:      upload_cutoff
- Env Var:     RCLONE_DRIME_UPLOAD_CUTOFF
- Type:        SizeSuffix
- Default:     200Mi

#### --drime-chunk-size

Chunk size to use for uploading.

When uploading files larger than upload_cutoff or files with unknown
size (e.g. from "rclone rcat" or uploaded with "rclone mount" or google
photos or google docs) they will be uploaded as multipart uploads
using this chunk size.

Note that "--drime-upload-concurrency" chunks of this size are buffered
in memory per transfer.

If you are transferring large files over high-speed links and you have
enough memory, then increasing this will speed up the transfers.

Rclone will automatically increase the chunk size when uploading a
large file of known size to stay below the 10,000 chunks limit.

Files of unknown size are uploaded with the configured
chunk_size. Since the default chunk size is 5 MiB and there can be at
most 10,000 chunks, this means that by default the maximum size of
a file you can stream upload is 48 GiB.  If you wish to stream upload
larger files then you will need to increase chunk_size.


Properties:

- Config:      chunk_size
- Env Var:     RCLONE_DRIME_CHUNK_SIZE
- Type:        SizeSuffix
- Default:     5Mi

#### --drime-upload-concurrency

Concurrency for multipart uploads and copies.

This is the number of chunks of the same file that are uploaded
concurrently for multipart uploads and copies.

If you are uploading small numbers of large files over high-speed links
and these uploads do not fully utilize your bandwidth, then increasing
this may help to speed up the transfers.

Properties:

- Config:      upload_concurrency
- Env Var:     RCLONE_DRIME_UPLOAD_CONCURRENCY
- Type:        int
- Default:     4

#### --drime-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_DRIME_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,LeftSpace,RightSpace,InvalidUtf8,Dot

#### --drime-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_DRIME_DESCRIPTION
- Type:        string
- Required:    false

<!-- autogenerated options stop -->

## Limitations

Drime only supports filenames up to 255 bytes in length, where filenames are
encoded in UTF8.

