%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x0000000600000007", "0x0000000400000005", "0x0000000200000003", "0x0000000000000001"],
    "XMM1": ["0x0000000500000005", "0x0000000500000005", "0x0000000500000005", "0x0000000500000005"],
    "XMM2": ["0xFFFFFFF0FFFFFFF1", "0xFFFFFFF2FFFFFFF3", "0xFFFFFFF4FFFFFFF5", "0xFFFFFFF6FFFFFFF7"],
    "XMM3": ["0x8888888899999999", "0xAAAAAAAABBBBBBBB", "0xCCCCCCCCDDDDDDDD", "0xEEEEEEEEFFFFFFFF"],
    "XMM4": ["0xBBBBBBBBBBBBBBBB", "0xBBBBBBBBBBBBBBBB", "0xBBBBBBBBBBBBBBBB", "0xBBBBBBBBBBBBBBBB"],
    "XMM5": ["0xEEEEEEEEFFFFFFFF", "0xCCCCCCCCDDDDDDDD", "0xAAAAAAAABBBBBBBB", "0x8888888899999999"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rel .invert]
vmovapd ymm1, [rel .select_elem_5]
vmovapd ymm2, [rel .reverse_quadwords]

vpermps ymm3, ymm0, [rel .data]
vpermps ymm4, ymm1, [rel .data]
vpermps ymm5, ymm2, [rel .data]

hlt

align 32
.data:
dq 0xFFFFFFFFEEEEEEEE
dq 0xDDDDDDDDCCCCCCCC
dq 0xBBBBBBBBAAAAAAAA
dq 0x9999999988888888

.invert:
dq 0x0000000600000007
dq 0x0000000400000005
dq 0x0000000200000003
dq 0x0000000000000001

.select_elem_5:
dq 0x0000000500000005
dq 0x0000000500000005
dq 0x0000000500000005
dq 0x0000000500000005

; Upper bits filled with junk. Should have no impact on operation
.reverse_quadwords:
dq 0xFFFFFFF0FFFFFFF1
dq 0xFFFFFFF2FFFFFFF3
dq 0xFFFFFFF4FFFFFFF5
dq 0xFFFFFFF6FFFFFFF7
