(*++

Copyright (C) 2019 Calculator developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal exception class definition file in order to allow easy
development of Calculator library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*)

{$MODE DELPHI}
unit calculator_exception;

interface

uses
  calculator_types,
  calculator_interfaces,
  Classes,
  sysutils;

type
  ECalculatorException = class(Exception)
  private
    FErrorCode: TCalculatorResult;
    FCustomMessage: String;
  public
    property ErrorCode: TCalculatorResult read FErrorCode;
    property CustomMessage: String read FCustomMessage;
    constructor Create(AErrorCode: TCalculatorResult);
    constructor CreateCustomMessage(AErrorCode: TCalculatorResult; AMessage: String);
  end;


(*************************************************************************************************************************
 Definition of exception handling functionality for Calculator
**************************************************************************************************************************)

function HandleCalculatorException(ACalculatorObject: TObject; E: ECalculatorException): TCalculatorResult;
function HandleStdException(ACalculatorObject: TObject; E: Exception): TCalculatorResult;
function HandleUnhandledException(ACalculatorObject: TObject): TCalculatorResult;


implementation

  constructor ECalculatorException.Create(AErrorCode: TCalculatorResult);
  var
    ADescription: String;
  begin
    FErrorCode := AErrorCode;
    case FErrorCode of
      CALCULATOR_ERROR_NOTIMPLEMENTED: ADescription := 'functionality not implemented';
      CALCULATOR_ERROR_INVALIDPARAM: ADescription := 'an invalid parameter was passed';
      CALCULATOR_ERROR_INVALIDCAST: ADescription := 'a type cast failed';
      CALCULATOR_ERROR_BUFFERTOOSMALL: ADescription := 'a provided buffer is too small';
      CALCULATOR_ERROR_GENERICEXCEPTION: ADescription := 'a generic exception occurred';
      CALCULATOR_ERROR_COULDNOTLOADLIBRARY: ADescription := 'the library could not be loaded';
      CALCULATOR_ERROR_COULDNOTFINDLIBRARYEXPORT: ADescription := 'a required exported symbol could not be found in the library';
      CALCULATOR_ERROR_INCOMPATIBLEBINARYVERSION: ADescription := 'the version of the binary interface does not match the bindings interface';
      else
        ADescription := 'unknown';
    end;

    inherited Create(Format('Calculator library Error - %s (#%d)', [ ADescription, AErrorCode ]));
  end;

  constructor ECalculatorException.CreateCustomMessage(AErrorCode: TCalculatorResult; AMessage: String);
  begin
    FCustomMessage := AMessage;
    FErrorCode := AErrorCode;
    inherited Create(Format('%s(%d)', [FCustomMessage, AErrorCode]));
  end;

(*************************************************************************************************************************
 Implementation of exception handling functionality for Calculator
**************************************************************************************************************************)

function HandleCalculatorException(ACalculatorObject: TObject; E: ECalculatorException): TCalculatorResult;
begin
  result := E.ErrorCode;
  if Supports(ACalculatorObject, ICalculatorBase) then begin
    (ACalculatorObject as ICalculatorBase).RegisterErrorMessage(E.CustomMessage)
  end;
end;
function HandleStdException(ACalculatorObject: TObject; E: Exception): TCalculatorResult;
begin
  Result := CALCULATOR_ERROR_GENERICEXCEPTION;
  if Supports(ACalculatorObject, ICalculatorBase) then begin
    (ACalculatorObject as ICalculatorBase).RegisterErrorMessage(E.Message)
  end;
end;
function HandleUnhandledException(ACalculatorObject: TObject): TCalculatorResult;
begin
  Result := CALCULATOR_ERROR_GENERICEXCEPTION;
  if Supports(ACalculatorObject, ICalculatorBase) then begin
    (ACalculatorObject as ICalculatorBase).RegisterErrorMessage('Unhandled Exception')
  end;
end;
end.
