/*++

Copyright (C) 2019 Numbers developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Numbers library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*/

#include "numbers_abi.hpp"
#include "numbers_interfaces.hpp"
#include "numbers_interfaceexception.hpp"

#include <map>

using namespace Numbers::Impl;

NumbersResult handleNumbersException(IBase * pIBaseClass, ENumbersInterfaceException & Exception)
{
	NumbersResult errorCode = Exception.getErrorCode();

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

NumbersResult handleStdException(IBase * pIBaseClass, std::exception & Exception)
{
	NumbersResult errorCode = NUMBERS_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

NumbersResult handleUnhandledException(IBase * pIBaseClass)
{
	NumbersResult errorCode = NUMBERS_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Variable
**************************************************************************************************************************/
NumbersResult numbers_variable_getvalue(Numbers_Variable pVariable, Numbers_double * pValue)
{
	IBase* pIBaseClass = (IBase *)pVariable;

	try {
		if (pValue == nullptr)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		IVariable* pIVariable = dynamic_cast<IVariable*>(pIBaseClass);
		if (!pIVariable)
			throw ENumbersInterfaceException(NUMBERS_ERROR_INVALIDCAST);
		
		*pValue = pIVariable->GetValue();

		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_variable_setvalue(Numbers_Variable pVariable, Numbers_double dValue)
{
	IBase* pIBaseClass = (IBase *)pVariable;

	try {
		IVariable* pIVariable = dynamic_cast<IVariable*>(pIBaseClass);
		if (!pIVariable)
			throw ENumbersInterfaceException(NUMBERS_ERROR_INVALIDCAST);
		
		pIVariable->SetValue(dValue);

		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}



/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

NumbersResult _numbers_getprocaddress_internal(const char * pProcName, void ** ppProcAddress)
{
	static bool sbProcAddressMapHasBeenInitialized = false;
	static std::map<std::string, void*> sProcAddressMap;
	if (!sbProcAddressMapHasBeenInitialized) {
		sProcAddressMap["numbers_variable_getvalue"] = (void*)&numbers_variable_getvalue;
		sProcAddressMap["numbers_variable_setvalue"] = (void*)&numbers_variable_setvalue;
		sProcAddressMap["numbers_createvariable"] = (void*)&numbers_createvariable;
		sProcAddressMap["numbers_getversion"] = (void*)&numbers_getversion;
		sProcAddressMap["numbers_getlasterror"] = (void*)&numbers_getlasterror;
		sProcAddressMap["numbers_releaseinstance"] = (void*)&numbers_releaseinstance;
		sProcAddressMap["numbers_acquireinstance"] = (void*)&numbers_acquireinstance;
		sProcAddressMap["numbers_getsymbollookupmethod"] = (void*)&numbers_getsymbollookupmethod;
		
		sbProcAddressMapHasBeenInitialized = true;
	}
	if (pProcName == nullptr)
		return NUMBERS_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return NUMBERS_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	auto procPair = sProcAddressMap.find(sProcName);
	if (procPair == sProcAddressMap.end()) {
		return NUMBERS_ERROR_COULDNOTFINDLIBRARYEXPORT;
	}
	else {
		*ppProcAddress = procPair->second;
		return NUMBERS_SUCCESS;
	}
	
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
NumbersResult numbers_createvariable(Numbers_double dInitialValue, Numbers_Variable * pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pInstance == nullptr)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		pBaseInstance = CWrapper::CreateVariable(dInitialValue);

		*pInstance = (IBase*)(pBaseInstance);
		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_getversion(Numbers_uint32 * pMajor, Numbers_uint32 * pMinor, Numbers_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (!pMajor)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		CWrapper::GetVersion(*pMajor, *pMinor, *pMicro);

		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_getlasterror(Numbers_Base pInstance, const Numbers_uint32 nErrorMessageBufferSize, Numbers_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError)
{
	IBase* pIBaseClass = nullptr;

	try {
		if ( (!pErrorMessageBuffer) && !(pErrorMessageNeededChars) )
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		if (pHasError == nullptr)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDCAST);
		
		std::string sErrorMessage("");
		*pHasError = CWrapper::GetLastError(pIInstance, sErrorMessage);

		if (pErrorMessageNeededChars)
			*pErrorMessageNeededChars = (Numbers_uint32) (sErrorMessage.size()+1);
		if (pErrorMessageBuffer) {
			if (sErrorMessage.size() >= nErrorMessageBufferSize)
				throw ENumbersInterfaceException (NUMBERS_ERROR_BUFFERTOOSMALL);
			for (size_t iErrorMessage = 0; iErrorMessage < sErrorMessage.size(); iErrorMessage++)
				pErrorMessageBuffer[iErrorMessage] = sErrorMessage[iErrorMessage];
			pErrorMessageBuffer[sErrorMessage.size()] = 0;
		}
		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_releaseinstance(Numbers_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDCAST);
		
		CWrapper::ReleaseInstance(pIInstance);

		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_acquireinstance(Numbers_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDCAST);
		
		CWrapper::AcquireInstance(pIInstance);

		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

NumbersResult numbers_getsymbollookupmethod(Numbers_pvoid * pSymbolLookupMethod)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pSymbolLookupMethod == nullptr)
			throw ENumbersInterfaceException (NUMBERS_ERROR_INVALIDPARAM);
		*pSymbolLookupMethod = (void*)&_numbers_getprocaddress_internal;
		return NUMBERS_SUCCESS;
	}
	catch (ENumbersInterfaceException & Exception) {
		return handleNumbersException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}


