/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import java.util.regex.Pattern;

public interface MultiPartName {
    public static final Pattern LEADING_TRAILING_QUOTES_PATTERN = Pattern.compile("^[\"\\[`]+|[\"\\]`]+$");

    public static String unquote(String quotedIdentifier) {
        return quotedIdentifier != null ? LEADING_TRAILING_QUOTES_PATTERN.matcher(quotedIdentifier).replaceAll("") : null;
    }

    public static boolean isQuoted(String identifier) {
        return identifier != null && LEADING_TRAILING_QUOTES_PATTERN.matcher(identifier).find();
    }

    public String getFullyQualifiedName();

    public String getUnquotedName();
}

