// Copyright (c) 2012- PPSSPP Project.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 2.0 or later versions.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License 2.0 for more details.

// A copy of the GPL 2.0 should have been included with the program.
// If not, see http://www.gnu.org/licenses/

// Official git repository and contact information can be found at
// https://github.com/hrydgard/ppsspp and http://www.ppsspp.org/.


enum GECommand {
	GE_CMD_NOP = 0,
	GE_CMD_VADDR = 0x1,
	GE_CMD_IADDR = 0x2,
	GE_CMD_PRIM = 0x4,
	GE_CMD_BEZIER = 0x5,
	GE_CMD_SPLINE = 0x6,
	GE_CMD_BOUNDINGBOX = 0x7,
	GE_CMD_JUMP = 0x8,
	GE_CMD_BJUMP = 0x9,
	GE_CMD_CALL = 0xA,
	GE_CMD_RET = 0xB,
	GE_CMD_END = 0xC,
	GE_CMD_SIGNAL = 0xE,
	GE_CMD_FINISH = 0xF,
	GE_CMD_BASE = 0x10,
	GE_CMD_VERTEXTYPE = 0x12,
	GE_CMD_OFFSETADDR = 0x13,
	GE_CMD_ORIGIN = 0x14,
	GE_CMD_REGION1 = 0x15,
	GE_CMD_REGION2 = 0x16,
	GE_CMD_LIGHTINGENABLE = 0x17,
	GE_CMD_LIGHTENABLE0 = 0x18,
	GE_CMD_LIGHTENABLE1 = 0x19,
	GE_CMD_LIGHTENABLE2 = 0x1A,
	GE_CMD_LIGHTENABLE3 = 0x1B,
	GE_CMD_DEPTHCLAMPENABLE = 0x1C,
	GE_CMD_CULLFACEENABLE = 0x1D,
	GE_CMD_TEXTUREMAPENABLE = 0x1E,
	GE_CMD_FOGENABLE = 0x1F,
	GE_CMD_DITHERENABLE = 0x20,
	GE_CMD_ALPHABLENDENABLE = 0x21,
	GE_CMD_ALPHATESTENABLE = 0x22,
	GE_CMD_ZTESTENABLE = 0x23,
	GE_CMD_STENCILTESTENABLE = 0x24,
	GE_CMD_ANTIALIASENABLE = 0x25,
	GE_CMD_PATCHCULLENABLE = 0x26,
	GE_CMD_COLORTESTENABLE = 0x27,
	GE_CMD_LOGICOPENABLE = 0x28,
	GE_CMD_BONEMATRIXNUMBER = 0x2A,
	GE_CMD_BONEMATRIXDATA = 0x2B,
	GE_CMD_MORPHWEIGHT0 = 0x2C,
	GE_CMD_MORPHWEIGHT1 = 0x2D,
	GE_CMD_MORPHWEIGHT2 = 0x2E,
	GE_CMD_MORPHWEIGHT3 = 0x2F,
	GE_CMD_MORPHWEIGHT4 = 0x30,
	GE_CMD_MORPHWEIGHT5 = 0x31,
	GE_CMD_MORPHWEIGHT6 = 0x32,
	GE_CMD_MORPHWEIGHT7 = 0x33,
	GE_CMD_PATCHDIVISION = 0x36,
	GE_CMD_PATCHPRIMITIVE = 0x37,
	GE_CMD_PATCHFACING = 0x38,
	GE_CMD_WORLDMATRIXNUMBER = 0x3A,
	GE_CMD_WORLDMATRIXDATA = 0x3B,
	GE_CMD_VIEWMATRIXNUMBER = 0x3C,
	GE_CMD_VIEWMATRIXDATA = 0x3D,
	GE_CMD_PROJMATRIXNUMBER = 0x3E,
	GE_CMD_PROJMATRIXDATA = 0x3F,
	GE_CMD_TGENMATRIXNUMBER = 0x40,
	GE_CMD_TGENMATRIXDATA = 0x41,
	GE_CMD_VIEWPORTXSCALE = 0x42,
	GE_CMD_VIEWPORTYSCALE = 0x43,
	GE_CMD_VIEWPORTZSCALE = 0x44,
	GE_CMD_VIEWPORTXCENTER = 0x45,
	GE_CMD_VIEWPORTYCENTER = 0x46,
	GE_CMD_VIEWPORTZCENTER = 0x47,
	GE_CMD_TEXSCALEU = 0x48,
	GE_CMD_TEXSCALEV = 0x49,
	GE_CMD_TEXOFFSETU = 0x4A,
	GE_CMD_TEXOFFSETV = 0x4B,
	GE_CMD_OFFSETX = 0x4C,
	GE_CMD_OFFSETY = 0x4D,
	GE_CMD_SHADEMODE = 0x50,  // flat or gouraud
	GE_CMD_REVERSENORMAL = 0x51,
	GE_CMD_MATERIALUPDATE = 0x53,
	GE_CMD_MATERIALEMISSIVE = 0x54, //not sure about these but this makes sense
	GE_CMD_MATERIALAMBIENT = 0x55,  //gotta try enabling lighting and check :)
	GE_CMD_MATERIALDIFFUSE = 0x56,
	GE_CMD_MATERIALSPECULAR = 0x57,
	GE_CMD_MATERIALALPHA = 0x58,
	GE_CMD_MATERIALSPECULARCOEF = 0x5B,
	GE_CMD_AMBIENTCOLOR = 0x5C,
	GE_CMD_AMBIENTALPHA = 0x5D,
	GE_CMD_LIGHTMODE = 0x5E,
	GE_CMD_LIGHTTYPE0 = 0x5F,
	GE_CMD_LIGHTTYPE1 = 0x60,
	GE_CMD_LIGHTTYPE2 = 0x61,
	GE_CMD_LIGHTTYPE3 = 0x62,
	GE_CMD_LX0 = 0x63,
	GE_CMD_LY0,
	GE_CMD_LZ0,
	GE_CMD_LX1,
	GE_CMD_LY1,
	GE_CMD_LZ1,
	GE_CMD_LX2,
	GE_CMD_LY2,
	GE_CMD_LZ2,
	GE_CMD_LX3,
	GE_CMD_LY3,
	GE_CMD_LZ3,
	GE_CMD_LDX0 = 0x6F,
	GE_CMD_LDY0,
	GE_CMD_LDZ0,
	GE_CMD_LDX1,
	GE_CMD_LDY1,
	GE_CMD_LDZ1,
	GE_CMD_LDX2,
	GE_CMD_LDY2,
	GE_CMD_LDZ2,
	GE_CMD_LDX3,
	GE_CMD_LDY3,
	GE_CMD_LDZ3,
	GE_CMD_LKA0 = 0x7B,
	GE_CMD_LKB0,
	GE_CMD_LKC0,
	GE_CMD_LKA1,
	GE_CMD_LKB1,
	GE_CMD_LKC1,
	GE_CMD_LKA2,
	GE_CMD_LKB2,
	GE_CMD_LKC2,
	GE_CMD_LKA3,
	GE_CMD_LKB3,
	GE_CMD_LKC3,
	GE_CMD_LKS0 = 0x87,
	GE_CMD_LKS1,
	GE_CMD_LKS2,
	GE_CMD_LKS3,
	GE_CMD_LKO0 = 0x8b,
	GE_CMD_LKO1,
	GE_CMD_LKO2,
	GE_CMD_LKO3,
	GE_CMD_LAC0 = 0x8F,
	GE_CMD_LDC0,
	GE_CMD_LSC0,
	GE_CMD_LAC1,
	GE_CMD_LDC1,
	GE_CMD_LSC1,
	GE_CMD_LAC2,
	GE_CMD_LDC2,
	GE_CMD_LSC2,
	GE_CMD_LAC3,
	GE_CMD_LDC3,
	GE_CMD_LSC3,
	GE_CMD_CULL = 0x9B,
	GE_CMD_FRAMEBUFPTR = 0x9C,
	GE_CMD_FRAMEBUFWIDTH = 0x9D,
	GE_CMD_ZBUFPTR = 0x9E,
	GE_CMD_ZBUFWIDTH = 0x9F,
	GE_CMD_TEXADDR0 = 0xA0,
	GE_CMD_TEXADDR1,
	GE_CMD_TEXADDR2,
	GE_CMD_TEXADDR3,
	GE_CMD_TEXADDR4,
	GE_CMD_TEXADDR5,
	GE_CMD_TEXADDR6,
	GE_CMD_TEXADDR7,
	GE_CMD_TEXBUFWIDTH0 = 0xA8,
	GE_CMD_TEXBUFWIDTH1,
	GE_CMD_TEXBUFWIDTH2,
	GE_CMD_TEXBUFWIDTH3,
	GE_CMD_TEXBUFWIDTH4,
	GE_CMD_TEXBUFWIDTH5,
	GE_CMD_TEXBUFWIDTH6,
	GE_CMD_TEXBUFWIDTH7,
	GE_CMD_CLUTADDR = 0xB0,
	GE_CMD_CLUTADDRUPPER = 0xB1,
	GE_CMD_TRANSFERSRC,
	GE_CMD_TRANSFERSRCW,
	GE_CMD_TRANSFERDST,
	GE_CMD_TRANSFERDSTW,
	GE_CMD_TEXSIZE0 = 0xB8,
	GE_CMD_TEXSIZE1,
	GE_CMD_TEXSIZE2,
	GE_CMD_TEXSIZE3,
	GE_CMD_TEXSIZE4,
	GE_CMD_TEXSIZE5,
	GE_CMD_TEXSIZE6,
	GE_CMD_TEXSIZE7,
	GE_CMD_TEXMAPMODE = 0xC0,
	GE_CMD_TEXSHADELS = 0xC1,
	GE_CMD_TEXMODE = 0xC2,
	GE_CMD_TEXFORMAT = 0xC3,
	GE_CMD_LOADCLUT = 0xC4,
	GE_CMD_CLUTFORMAT = 0xC5,
	GE_CMD_TEXFILTER = 0xC6,
	GE_CMD_TEXWRAP = 0xC7,
	GE_CMD_TEXLEVEL = 0xC8,
	GE_CMD_TEXFUNC = 0xC9,
	GE_CMD_TEXENVCOLOR = 0xCA,
	GE_CMD_TEXFLUSH = 0xCB,
	GE_CMD_TEXSYNC = 0xCC,
	GE_CMD_FOG1 = 0xCD,
	GE_CMD_FOG2 = 0xCE,
	GE_CMD_FOGCOLOR = 0xCF,
	GE_CMD_TEXLODSLOPE = 0xD0,
	GE_CMD_FRAMEBUFPIXFORMAT = 0xD2,
	GE_CMD_CLEARMODE = 0xD3,
	GE_CMD_SCISSOR1 = 0xD4,
	GE_CMD_SCISSOR2 = 0xD5,
	GE_CMD_MINZ = 0xD6,
	GE_CMD_MAXZ = 0xD7,
	GE_CMD_COLORTEST = 0xD8,
	GE_CMD_COLORREF = 0xD9,
	GE_CMD_COLORTESTMASK = 0xDA,
	GE_CMD_ALPHATEST = 0xDB,
	GE_CMD_STENCILTEST = 0xDC,
	GE_CMD_STENCILOP = 0xDD,
	GE_CMD_ZTEST = 0xDE,
	GE_CMD_BLENDMODE = 0xDF,
	GE_CMD_BLENDFIXEDA = 0xE0,
	GE_CMD_BLENDFIXEDB = 0xE1,
	GE_CMD_DITH0 = 0xE2,
	GE_CMD_DITH1,
	GE_CMD_DITH2,
	GE_CMD_DITH3,
	GE_CMD_LOGICOP = 0xE6,
	GE_CMD_ZWRITEDISABLE = 0xE7,
	GE_CMD_MASKRGB = 0xE8,
	GE_CMD_MASKALPHA = 0xE9,
	GE_CMD_TRANSFERSTART = 0xEA,
	GE_CMD_TRANSFERSRCPOS = 0xEB,
	GE_CMD_TRANSFERDSTPOS = 0xEC,
	GE_CMD_TRANSFERSIZE = 0xEE,
	GE_CMD_VSCX = 0xF0,
	GE_CMD_VSCY = 0xF1,
	GE_CMD_VSCZ = 0xF2,
	GE_CMD_VTCS = 0xF3,
	GE_CMD_VTCT = 0xF4,
	GE_CMD_VTCQ = 0xF5,
	GE_CMD_VCV = 0xF6,
	GE_CMD_VAP = 0xF7,
	GE_CMD_VFC = 0xF8,
	GE_CMD_VSCV = 0xF9,
	GE_CMD_UNKNOWN_03 = 0x03,
	GE_CMD_UNKNOWN_0D = 0x0D,
	GE_CMD_UNKNOWN_11 = 0x11,
	GE_CMD_UNKNOWN_29 = 0x29,
	GE_CMD_UNKNOWN_34 = 0x34,
	GE_CMD_UNKNOWN_35 = 0x35,
	GE_CMD_UNKNOWN_39 = 0x39,
	GE_CMD_UNKNOWN_4E = 0x4E,
	GE_CMD_UNKNOWN_4F = 0x4F,
	GE_CMD_UNKNOWN_52 = 0x52,
	GE_CMD_UNKNOWN_59 = 0x59,
	GE_CMD_UNKNOWN_5A = 0x5A,
	GE_CMD_UNKNOWN_B6 = 0xB6,
	GE_CMD_UNKNOWN_B7 = 0xB7,
	GE_CMD_UNKNOWN_D1 = 0xD1,
	GE_CMD_UNKNOWN_ED = 0xED,
	GE_CMD_UNKNOWN_EF = 0xEF,
	GE_CMD_UNKNOWN_FA = 0xFA,
	GE_CMD_UNKNOWN_FB = 0xFB,
	GE_CMD_UNKNOWN_FC = 0xFC,
	GE_CMD_UNKNOWN_FD = 0xFD,
	GE_CMD_UNKNOWN_FE = 0xFE,
	GE_CMD_NOP_FF = 0xFF,
};
