// Code generated by git.sr.ht/~nelsam/hel. DO NOT EDIT.
//
// This file contains mocks generated by hel. Do not edit this code by
// hand unless you *really* know what you're doing. Expect any changes
// made manually to be overwritten the next time hel regenerates this
// file.

package proj_test

import (
	"context"
	"io"
	"io/fs"
	"time"

	"git.sr.ht/~nelsam/hel/vegr"
	"github.com/earthly/earthly/util/proj"
)

type mockFS struct {
	t          vegr.T
	timeout    time.Duration
	OpenCalled chan bool
	OpenInput  struct {
		Name chan string
	}
	OpenOutput struct {
		Ret0 chan fs.File
		Ret1 chan error
	}
	StatCalled chan bool
	StatInput  struct {
		Name chan string
	}
	StatOutput struct {
		Ret0 chan fs.FileInfo
		Ret1 chan error
	}
}

func newMockFS(t vegr.T, timeout time.Duration) *mockFS {
	m := &mockFS{t: t, timeout: timeout}
	m.OpenCalled = make(chan bool, 100)
	m.OpenInput.Name = make(chan string, 100)
	m.OpenOutput.Ret0 = make(chan fs.File, 100)
	m.OpenOutput.Ret1 = make(chan error, 100)
	m.StatCalled = make(chan bool, 100)
	m.StatInput.Name = make(chan string, 100)
	m.StatOutput.Ret0 = make(chan fs.FileInfo, 100)
	m.StatOutput.Ret1 = make(chan error, 100)
	return m
}
func (m *mockFS) Open(name string) (ret0 fs.File, ret1 error) {
	m.t.Helper()
	m.OpenCalled <- true
	m.OpenInput.Name <- name
	vegr.PopulateReturns(m.t, "Open", m.timeout, m.OpenOutput, &ret0, &ret1)
	return ret0, ret1
}
func (m *mockFS) Stat(name string) (ret0 fs.FileInfo, ret1 error) {
	m.t.Helper()
	m.StatCalled <- true
	m.StatInput.Name <- name
	vegr.PopulateReturns(m.t, "Stat", m.timeout, m.StatOutput, &ret0, &ret1)
	return ret0, ret1
}

type mockCmd struct {
	t         vegr.T
	timeout   time.Duration
	RunCalled chan bool
	RunInput  struct {
		Ctx chan context.Context
	}
	RunOutput struct {
		Stdout, Stderr chan io.Reader
		Ret1           chan error
	}
}

func newMockCmd(t vegr.T, timeout time.Duration) *mockCmd {
	m := &mockCmd{t: t, timeout: timeout}
	m.RunCalled = make(chan bool, 100)
	m.RunInput.Ctx = make(chan context.Context, 100)
	m.RunOutput.Stdout = make(chan io.Reader, 100)
	m.RunOutput.Stderr = make(chan io.Reader, 100)
	m.RunOutput.Ret1 = make(chan error, 100)
	return m
}
func (m *mockCmd) Run(ctx context.Context) (stdout, stderr io.Reader, ret1 error) {
	m.t.Helper()
	m.RunCalled <- true
	m.RunInput.Ctx <- ctx
	vegr.PopulateReturns(m.t, "Run", m.timeout, m.RunOutput, &stdout, &stderr, &ret1)
	return stdout, stderr, ret1
}

type mockExecer struct {
	t             vegr.T
	timeout       time.Duration
	CommandCalled chan bool
	CommandInput  struct {
		Name chan string
		Args chan []string
	}
	CommandOutput struct {
		Ret0 chan proj.Cmd
	}
}

func newMockExecer(t vegr.T, timeout time.Duration) *mockExecer {
	m := &mockExecer{t: t, timeout: timeout}
	m.CommandCalled = make(chan bool, 100)
	m.CommandInput.Name = make(chan string, 100)
	m.CommandInput.Args = make(chan []string, 100)
	m.CommandOutput.Ret0 = make(chan proj.Cmd, 100)
	return m
}
func (m *mockExecer) Command(name string, args ...string) (ret0 proj.Cmd) {
	m.t.Helper()
	m.CommandCalled <- true
	m.CommandInput.Name <- name
	m.CommandInput.Args <- args
	vegr.PopulateReturns(m.t, "Command", m.timeout, m.CommandOutput, &ret0)
	return ret0
}

type mockProject struct {
	t       vegr.T
	timeout time.Duration
}

func newMockProject(t vegr.T, timeout time.Duration) *mockProject {
	m := &mockProject{t: t, timeout: timeout}
	return m
}

type mockFileInfo struct {
	t          vegr.T
	timeout    time.Duration
	NameCalled chan bool
	NameOutput struct {
		Ret0 chan string
	}
	SizeCalled chan bool
	SizeOutput struct {
		Ret0 chan int64
	}
	ModeCalled chan bool
	ModeOutput struct {
		Ret0 chan fs.FileMode
	}
	ModTimeCalled chan bool
	ModTimeOutput struct {
		Ret0 chan time.Time
	}
	IsDirCalled chan bool
	IsDirOutput struct {
		Ret0 chan bool
	}
	SysCalled chan bool
	SysOutput struct {
		Ret0 chan any
	}
}

func newMockFileInfo(t vegr.T, timeout time.Duration) *mockFileInfo {
	m := &mockFileInfo{t: t, timeout: timeout}
	m.NameCalled = make(chan bool, 100)
	m.NameOutput.Ret0 = make(chan string, 100)
	m.SizeCalled = make(chan bool, 100)
	m.SizeOutput.Ret0 = make(chan int64, 100)
	m.ModeCalled = make(chan bool, 100)
	m.ModeOutput.Ret0 = make(chan fs.FileMode, 100)
	m.ModTimeCalled = make(chan bool, 100)
	m.ModTimeOutput.Ret0 = make(chan time.Time, 100)
	m.IsDirCalled = make(chan bool, 100)
	m.IsDirOutput.Ret0 = make(chan bool, 100)
	m.SysCalled = make(chan bool, 100)
	m.SysOutput.Ret0 = make(chan any, 100)
	return m
}
func (m *mockFileInfo) Name() (ret0 string) {
	m.t.Helper()
	m.NameCalled <- true
	vegr.PopulateReturns(m.t, "Name", m.timeout, m.NameOutput, &ret0)
	return ret0
}
func (m *mockFileInfo) Size() (ret0 int64) {
	m.t.Helper()
	m.SizeCalled <- true
	vegr.PopulateReturns(m.t, "Size", m.timeout, m.SizeOutput, &ret0)
	return ret0
}
func (m *mockFileInfo) Mode() (ret0 fs.FileMode) {
	m.t.Helper()
	m.ModeCalled <- true
	vegr.PopulateReturns(m.t, "Mode", m.timeout, m.ModeOutput, &ret0)
	return ret0
}
func (m *mockFileInfo) ModTime() (ret0 time.Time) {
	m.t.Helper()
	m.ModTimeCalled <- true
	vegr.PopulateReturns(m.t, "ModTime", m.timeout, m.ModTimeOutput, &ret0)
	return ret0
}
func (m *mockFileInfo) IsDir() (ret0 bool) {
	m.t.Helper()
	m.IsDirCalled <- true
	vegr.PopulateReturns(m.t, "IsDir", m.timeout, m.IsDirOutput, &ret0)
	return ret0
}
func (m *mockFileInfo) Sys() (ret0 any) {
	m.t.Helper()
	m.SysCalled <- true
	vegr.PopulateReturns(m.t, "Sys", m.timeout, m.SysOutput, &ret0)
	return ret0
}

type mockFile struct {
	t          vegr.T
	timeout    time.Duration
	StatCalled chan bool
	StatOutput struct {
		Ret0 chan fs.FileInfo
		Ret1 chan error
	}
	ReadCalled chan bool
	ReadInput  struct {
		Arg0 chan []byte
	}
	ReadOutput struct {
		Ret0 chan int
		Ret1 chan error
	}
	CloseCalled chan bool
	CloseOutput struct {
		Ret0 chan error
	}
}

func newMockFile(t vegr.T, timeout time.Duration) *mockFile {
	m := &mockFile{t: t, timeout: timeout}
	m.StatCalled = make(chan bool, 100)
	m.StatOutput.Ret0 = make(chan fs.FileInfo, 100)
	m.StatOutput.Ret1 = make(chan error, 100)
	m.ReadCalled = make(chan bool, 100)
	m.ReadInput.Arg0 = make(chan []byte, 100)
	m.ReadOutput.Ret0 = make(chan int, 100)
	m.ReadOutput.Ret1 = make(chan error, 100)
	m.CloseCalled = make(chan bool, 100)
	m.CloseOutput.Ret0 = make(chan error, 100)
	return m
}
func (m *mockFile) Stat() (ret0 fs.FileInfo, ret1 error) {
	m.t.Helper()
	m.StatCalled <- true
	vegr.PopulateReturns(m.t, "Stat", m.timeout, m.StatOutput, &ret0, &ret1)
	return ret0, ret1
}
func (m *mockFile) Read(arg0 []byte) (ret0 int, ret1 error) {
	m.t.Helper()
	m.ReadCalled <- true
	m.ReadInput.Arg0 <- arg0
	vegr.PopulateReturns(m.t, "Read", m.timeout, m.ReadOutput, &ret0, &ret1)
	return ret0, ret1
}
func (m *mockFile) Close() (ret0 error) {
	m.t.Helper()
	m.CloseCalled <- true
	vegr.PopulateReturns(m.t, "Close", m.timeout, m.CloseOutput, &ret0)
	return ret0
}

type mockContext struct {
	t              vegr.T
	timeout        time.Duration
	DeadlineCalled chan bool
	DeadlineOutput struct {
		Deadline chan time.Time
		Ok       chan bool
	}
	DoneCalled chan bool
	DoneOutput struct {
		Ret0 chan (<-chan struct{})
	}
	ErrCalled chan bool
	ErrOutput struct {
		Ret0 chan error
	}
	ValueCalled chan bool
	ValueInput  struct {
		Key chan any
	}
	ValueOutput struct {
		Ret0 chan any
	}
}

func newMockContext(t vegr.T, timeout time.Duration) *mockContext {
	m := &mockContext{t: t, timeout: timeout}
	m.DeadlineCalled = make(chan bool, 100)
	m.DeadlineOutput.Deadline = make(chan time.Time, 100)
	m.DeadlineOutput.Ok = make(chan bool, 100)
	m.DoneCalled = make(chan bool, 100)
	m.DoneOutput.Ret0 = make(chan (<-chan struct{}), 100)
	m.ErrCalled = make(chan bool, 100)
	m.ErrOutput.Ret0 = make(chan error, 100)
	m.ValueCalled = make(chan bool, 100)
	m.ValueInput.Key = make(chan any, 100)
	m.ValueOutput.Ret0 = make(chan any, 100)
	return m
}
func (m *mockContext) Deadline() (deadline time.Time, ok bool) {
	m.t.Helper()
	m.DeadlineCalled <- true
	vegr.PopulateReturns(m.t, "Deadline", m.timeout, m.DeadlineOutput, &deadline, &ok)
	return deadline, ok
}
func (m *mockContext) Done() (ret0 <-chan struct{}) {
	m.t.Helper()
	m.DoneCalled <- true
	vegr.PopulateReturns(m.t, "Done", m.timeout, m.DoneOutput, &ret0)
	return ret0
}
func (m *mockContext) Err() (ret0 error) {
	m.t.Helper()
	m.ErrCalled <- true
	vegr.PopulateReturns(m.t, "Err", m.timeout, m.ErrOutput, &ret0)
	return ret0
}
func (m *mockContext) Value(key any) (ret0 any) {
	m.t.Helper()
	m.ValueCalled <- true
	m.ValueInput.Key <- key
	vegr.PopulateReturns(m.t, "Value", m.timeout, m.ValueOutput, &ret0)
	return ret0
}

type mockReader struct {
	t          vegr.T
	timeout    time.Duration
	ReadCalled chan bool
	ReadInput  struct {
		P chan []byte
	}
	ReadOutput struct {
		N   chan int
		Err chan error
	}
}

func newMockReader(t vegr.T, timeout time.Duration) *mockReader {
	m := &mockReader{t: t, timeout: timeout}
	m.ReadCalled = make(chan bool, 100)
	m.ReadInput.P = make(chan []byte, 100)
	m.ReadOutput.N = make(chan int, 100)
	m.ReadOutput.Err = make(chan error, 100)
	return m
}
func (m *mockReader) Read(p []byte) (n int, err error) {
	m.t.Helper()
	m.ReadCalled <- true
	m.ReadInput.P <- p
	vegr.PopulateReturns(m.t, "Read", m.timeout, m.ReadOutput, &n, &err)
	return n, err
}
