/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.client.PortFileInaccessibleException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.concurrent.Semaphore;

public class PortFile {
    private static final int magicNr = 4468;
    private String filename;
    private File file;
    private File stopFile;
    private RandomAccessFile rwfile;
    private FileChannel channel;
    private FileLock lock;
    private Semaphore lockSem = new Semaphore(1);
    private boolean containsPortInfo;
    private int serverPort;
    private long serverCookie;
    private int myServerPort;
    private long myServerCookie;

    public PortFile(String string) {
        this.filename = string;
        this.file = new File(this.filename);
        this.stopFile = new File(this.filename + ".stop");
        this.containsPortInfo = false;
        this.lock = null;
    }

    private void initializeChannel() throws PortFileInaccessibleException {
        try {
            this.rwfile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PortFileInaccessibleException(fileNotFoundException);
        }
        this.channel = this.rwfile.getChannel();
    }

    public void lock() throws IOException, InterruptedException {
        if (this.channel == null) {
            this.initializeChannel();
        }
        this.lockSem.acquire();
        this.lock = this.channel.lock();
    }

    public void getValues() {
        this.containsPortInfo = false;
        if (this.lock == null) {
            return;
        }
        try {
            if (this.rwfile.length() > 0L) {
                this.rwfile.seek(0L);
                int n = this.rwfile.readInt();
                this.serverPort = this.rwfile.readInt();
                this.serverCookie = this.rwfile.readLong();
                this.containsPortInfo = n == 4468;
            }
        }
        catch (IOException iOException) {
            this.containsPortInfo = false;
        }
    }

    public boolean containsPortInfo() {
        return this.containsPortInfo;
    }

    public int getPort() {
        Assert.check(this.containsPortInfo);
        return this.serverPort;
    }

    public long getCookie() {
        Assert.check(this.containsPortInfo);
        return this.serverCookie;
    }

    public void setValues(int n, long l) throws IOException {
        Assert.check(this.lock != null);
        this.rwfile.seek(0L);
        this.rwfile.writeInt(4468);
        this.rwfile.writeInt(n);
        this.rwfile.writeLong(l);
        this.myServerPort = n;
        this.myServerCookie = l;
    }

    public void delete() throws IOException, InterruptedException {
        this.rwfile.close();
        this.file.delete();
        for (int i = 0; i < 10 && this.file.exists(); ++i) {
            Thread.sleep(1000L);
        }
        if (this.file.exists()) {
            throw new IOException("Failed to delete file.");
        }
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean markedForStop() throws IOException {
        if (this.stopFile.exists()) {
            try {
                this.stopFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void unlock() throws IOException {
        if (this.lock == null) {
            return;
        }
        this.lock.release();
        this.lock = null;
        this.lockSem.release();
    }

    public void waitForValidValues() throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = l + this.getServerStartupTimeoutSeconds() * 1000L;
        while (true) {
            Log.debug("Looking for valid port file values...");
            if (this.exists()) {
                this.lock();
                this.getValues();
                this.unlock();
            }
            if (this.containsPortInfo) {
                Log.debug("Valid port file values found after " + (System.currentTimeMillis() - l) + " ms");
                return;
            }
            if (System.currentTimeMillis() > l2) break;
            Thread.sleep(500L);
        }
        throw new IOException("No port file values materialized. Giving up after " + (System.currentTimeMillis() - l) + " ms");
    }

    /*
     * Loose catch block
     */
    public boolean stillMyValues() throws IOException, FileNotFoundException, InterruptedException {
        while (true) {
            try {
                this.lock();
                this.getValues();
                this.unlock();
                if (this.containsPortInfo) {
                    return this.serverPort == this.myServerPort && this.serverCookie == this.myServerCookie;
                }
                return false;
            }
            catch (FileLockInterruptionException fileLockInterruptionException) {
                continue;
            }
            break;
        }
        catch (ClosedChannelException closedChannelException) {
            return false;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    private long getServerStartupTimeoutSeconds() {
        String string = System.getProperty("serverStartupTimeout");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 60L;
    }
}

