# 0.80.1 release notes

**Release date:** 2023-01-06

## Summary

This maintenance release fixes minor issues with the mouse defaults, modem and
Ethernet connection handling, and Meson dependencies.

We are also happy to report that the high DPI improvements in the previous
0.80.0 release have been verified on Windows, meaning that high DPI support is
now functional on all platforms. Thanks to *GranMinigun* for this addition!

This maintenance release was made possible by everyone who tried 0.80.0,
submitted bugs and pull requests, and tested the updates: thank you!


## How to upgrade

Get started by downloading the latest version and updating your configuration
file:

### Downloads

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

### Upgrade your configuration file

1. Launch the new release.
2. At the`Z:\>` prompt, run `config -wc` to write the new configuration file.

!!! note

    - Existing settings will be retained, but extraneous comments will be
      dropped.


## Bug and regression fixes

- The mouse will now be captured only after the first click inside the window.
  For users without a windowing environment, the previous capture-on-start
  behavior will remain unchanged.

- The captured mouse will now be centered in the window upon release.

- The softmodem now includes a brief warm-up period where it will drop initial
  unreliable data, similar to hardware modems. This allows **Duke Nukem 3D** to
  establish its data connection on the first attempt.

- A potential slow memory leak related to closed Ethernet connections has been
  fixed.

- A bug that caused the `C:` mount to become unlistable after launching DOSBox
  Staging with a command-line mount while using `MORE.COM` has been fixed.

- The xinput2 library, an optional dependency of ManyMouse, can now be set via
  the Meson options. For more information, see
  [`meson_options.txt`](https://github.com/dosbox-staging/dosbox-staging/blob/main/meson_options.txt).

- When compiling on ARM platforms, the SpeexDSP wrap will now correctly check if
  the host supports NEON instructions, and use them if available.

??? note "Full PR list of bug and regression fixes"

    - Add Linux ARM CI jobs using containerized cross-compiler (#2193)
    - Add missing Windows 11 features to MORE command (#2142)
    - Bump Coverity to v2022.06 (#2162)
    - Bump actions/cache from 3.2.0 to 3.2.1 (#2152)
    - Bump actions/cache from 3.2.1 to 3.2.2 (#2165)
    - Center mouse cursor before releasing it (#2173)
    - Change mouse capture default to 'onclick' (#2172)
    - Check CLI arguments for directories using non-invasive test (#2148)
    - Cleanup some minor Coverity issues (#2179)
    - Fix CGA mono and Hercules intro banners (#2190)
    - Fix imprecise help string in MORE command (#2161)
    - Fix logging of some pre-EGA modes (#2187)
    - Fix remaining two CWEs involving unchecked return values (#2150)
    - Fix slirp/ne2000 warnings (#2182)
    - Improve logging of the current display mode (#2168)
    - Improve seamless mouse configuration entry description, mention the touchscreen (#2163)
    - Make the xinput2 library optional for ManyMouse (#2155)
    - Use extended ASCII check in MORE command (#2195)
    - Use presence of desktop environment in mouse capture states (#2181)


## Translation improvements

This maintenance release includes updates to the Dutch, Italian, and Polish
translations.

??? note "Full PR list of translation improvements"

    - Update Dutch (nl) translation of MORE (#2164)
    - Update Italian (it-it) translation (#2166)
    - Update Polish (pl) translation (#2159)
    - Update Polish (pl) translation (#2186)
    - Update Polish (pl) translation, for 0.80.x only (#2194)


## Contributors

The following commit authors, sponsors, supporters, and backers invested their
time or funds into this maintenance release. Thank you!


### Commit authors

In alphabetic order:

<div class="compact" markdown>

- FeralChild64
- johnnovak
- Kappa971
- kcgen
- NicknineTheEagle
- rderooy
- shermp
- ThomasEricB

</div>


### Sponsors

Sponsors who donated **100+ USD per month** to the project:

<div class="compact" markdown>

- Antti Peltola
- Wengier Wu

</div>


### Backers

Backers who donated **5+ USD per month** to the project:

<div class="compact" markdown>

- Burrito78
- Hannu Hartikainen
- Hugo Locurcio

</div>

Thank you for considering supporting our work through a donation on [GitHub
Sponsors](https://github.com/sponsors/dosbox-staging) or [Open
Collective](https://opencollective.com/dosbox-staging). Your contribution helps
us purchase hardware and cover ongoing expenses to keep the project going.


## Thank you

We are grateful for all community contributions as well as the original DOSBox
project, upon which DOSBox Staging is based.

