 
C*********************************************************************
 
C...PYMAEL
C...Auxiliary to PYSHOW and PYPTFS.
C...Matrix elements for gluon (or photon) emission from
C...a two-body state; to be used by the parton shower routine.
C...Here X_i = 2 E_i/E_cm, R_i = m_i/E_cm and
C...1/sigma_0 d(sigma)/d(x_1)d(x_2) =
C...      = (alpha-strong/2 pi) * CF * PYMAEL,
C...i.e. normalization is such that one recovers the familiar
C...(X1**2+X2**2)/((1-X1)*(1-X2)) for the massless case.
C...Coupling structure:
C...NI =  6- 9 : eikonal soft-gluon expression (spin-independent)
C...   = 11-14 : V -> q qbar (V = vector/axial vector colour singlet)
C...   = 16-19 : q -> q V
C...   = 21-24 : S -> q qbar (S = scalar/pseudoscalar colour singlet)
C...   = 26-29 : q -> q S
C...   = 31-34 : V -> ~q ~qbar  (~q = squark)
C...   = 36-39 : ~q -> ~q V
C...   = 41-44 : S -> ~q ~qbar
C...   = 46-49 : ~q -> ~q S
C...   = 51-54 : chi -> q ~qbar (chi = neutralino/chargino)
C...   = 56-59 : ~q -> q chi
C...   = 61-64 : q -> ~q chi
C...   = 66-69 : ~g -> q ~qbar
C...   = 71-74 : ~q -> q ~g
C...   = 76-79 : q -> ~q ~g
C...   = 81-84 : (9/4)*(eikonal) for gg -> ~g ~g
C...Note that the order of the decay products is important.
C...In each set of four, the variants are ordered as:
C...ICOMBI = 1 : pure non-gamma5, i.e. vector/scalar/...
C...       = 2 : pure gamma5, i.e. axial vector/pseudoscalar/....
C...       = 3 : mixture alpha*(ICOMBI=1) + (1-alpha)*(ICOMBI=2)
C...       = 4 : mixture (ICOMBI=1) +- (ICOMBI=2)
 
      FUNCTION PYMAEL(NI,X1,X2,R1,R2,ALPHA)
 
C...Double precision and integer declarations.
      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
      IMPLICIT INTEGER(I-N)
 
C...Check input values. Return zero outside allowed phase space.
      PYMAEL=0D0
      IF(X1.LE.2D0*R1.OR.X1.GE.1D0+R1**2-R2**2) RETURN
      IF(X2.LE.2D0*R2.OR.X2.GE.1D0+R2**2-R1**2) RETURN
      IF(X1+X2.LE.1D0+(R1+R2)**2) RETURN
      IF((2D0-2D0*X1-2D0*X2+X1*X2+2D0*R1**2+2D0*R2**2)**2.GE.
     &(X1**2-4D0*R1**2)*(X2**2-4D0*R2**2)) RETURN
      ALPCOR=MAX(0D0,MIN(1D0,ALPHA))
 
C...Initial values and flags.
      ICLASS=NI/5
      ICOMBI=NI-5*ICLASS
      ISSET1=0
      ISSET2=0
      ISSET4=0
 
C... Phase space.
      PS=SQRT((1D0-(R1+R2)**2)*(1D0-(R1-R2)**2))
 
C...Eikonal expression; also acts as default.
      IF(ICLASS.LE.1.OR.ICLASS.GE.17.OR.ICOMBI.EQ.0) THEN
        RLO=PS
        IF(ICOMBI.EQ.0.OR.ICOMBI.EQ.1) THEN
          ANUM=0D0
        ELSEIF(ICOMBI.EQ.2) THEN
          ANUM=(2D0-X1-X2)**2
        ELSEIF(ICOMBI.EQ.3) THEN
          ANUM=ALPCOR*(2D0-X1-X2)**2
        ELSE
          ANUM=0.5D0*(2D0-X1-X2)**2
        ENDIF
        RFO=PS*2D0*((X1+X2-1D0+ANUM-R1**2-R2**2)/
     &       ((1D0+R1**2-R2**2-X1)*(1D0+R2**2-R1**2-X2))-
     &       R1**2/(1D0+R2**2-R1**2-X2)**2-
     &       R2**2/(1D0+R1**2-R2**2-X1)**2)
        ICOMBI=0
 
C...V -> q qbar (V = gamma*/Z0/W+-/...).
      ELSEIF(ICLASS.EQ.2) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(2-R1**2-R1**4+6*R1*R2-R2**2+2*R1**2*R2**2-R2**4)/2.D0
        RFO1=-1.D0*(3+6*R1**2+R1**4-6*R1*R2+6*R1**3*R2-2*R2**2
     &       -6*R1**2*R2**2+6*R1*R2**3+R2**4-3*X1+6*R1*R2*X1
     &       +2*R2**2*X1+X1**2-2*R1**2*X1**2+3*R1**2*(2-X1-X2)
     &       +6*R1*R2*(2-X1-X2)-R2**2*(2-X1-X2)-2*X1*(2-X1-X2)
     &       -5*R1**2*X1*(2-X1-X2)+R2**2*X1*(2-X1-X2)+X1**2*(2-X1-X2)
     &       -3*(2-X1-X2)**2-3*R1**2*(2-X1-X2)**2+R2**2*(2-X1-X2)**2
     &       +2*X1*(2-X1-X2)**2+(2-X1-X2)**3-X2)/
     &       (-1+R1**2-R2**2+X2)**2
        RFO1=RFO1-2*(-3+R1**2-6*R1*R2+6*R1**3*R2+3*R2**2-4*R1**2*R2**2
     &       +6*R1*R2**3+2*X1+3*R1**2*X1+R2**2*X1-X1**2-R1**2*X1**2
     &       -R2**2*X1**2+4*(2-X1-X2)+2*R1**2*(2-X1-X2)+3*R1*R2*(2-X1
     &       -X2)-R2**2*(2-X1-X2)-3*X1*(2-X1-X2)-2*R1**2*X1*(2-X1-X2)
     &       +X1**2*(2-X1-X2)-(2-X1-X2)**2-R1**2*(2-X1-X2)**2+R1*R2*(2
     &       -X1-X2)**2+X1*(2-X1-X2)**2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
        RFO1=RFO1-1.D0*(-1+2*R1**2+R1**4+6*R1*R2+6*R1**3*R2-2*R2**2
     &       -6*R1**2*R2**2+6*R1*R2**3+R2**4-X1-2*R1**2*X1-6*R1*R2*X1
     &       +8*R2**2*X1+X1**2-2*R2**2*X1**2-R1**2*(2-X1-X2)+R2**2*(2
     &       -X1-X2)-R1**2*X1*(2-X1-X2)+R2**2*X1*(2-X1-X2)+X1**2*
     &       (2-X1-X2)+X2)/(-1-R1**2+R2**2+X1)**2
        RFO1=RFO1/2.D0
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(2-R1**2-R1**4-6*R1*R2-R2**2+2*R1**2*R2**2-R2**4)/2.D0
        RFO2=-1*(3+6*R1**2+R1**4+6*R1*R2-6*R1**3*R2-2*R2**2
     &       -6*R1**2*R2**2-6*R1*R2**3+R2**4-3*X1-6*R1*R2*X1+2*R2**2*X1
     &       +X1**2-2*R1**2*X1**2+3*R1**2*(2-X1-X2)-6*R1*R2*(2-X1-X2)
     &       -R2**2*(2-X1-X2)-2*X1*(2-X1-X2)-5*R1**2*X1*(2-X1-X2)
     &       +R2**2*X1*(2-X1-X2)+X1**2*(2-X1-X2)-3*(2-X1-X2)**2
     &       -3*R1**2*(2-X1-X2)**2+R2**2*(2-X1-X2)**2+2*X1*(2-X1-X2)**2
     &       +(2-X1-X2)**3-X2)/(-1+R1**2-R2**2+X2)**2
        RFO2=RFO2-2*(-3+R1**2+6*R1*R2-6*R1**3*R2+3*R2**2-4*R1**2*R2**2
     &       -6*R1*R2**3+2*X1+3*R1**2*X1+R2**2*X1-X1**2-R1**2*X1**2
     &       -R2**2*X1**2+4*(2-X1-X2)+2*R1**2*(2-X1-X2)-3*R1*R2*(2-X1
     &       -X2)-R2**2*(2-X1-X2)-3*X1*(2-X1-X2)-2*R1**2*X1*(2-X1-X2)
     &       +X1**2*(2-X1-X2)-(2-X1-X2)**2-R1**2*(2-X1-X2)**2-R1*R2*(2
     &       -X1-X2)**2+X1*(2-X1-X2)**2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
        RFO2=RFO2-1*(-1+2*R1**2+R1**4-6*R1*R2-6*R1**3*R2-2*R2**2
     &       -6*R1**2*R2**2-6*R1*R2**3+R2**4-X1-2*R1**2*X1+6*R1*R2*X1
     &       +8*R2**2*X1+X1**2-2*R2**2*X1**2-R1**2*(2-X1-X2)+R2**2*(2-X1
     &       -X2)-R1**2*X1*(2-X1-X2)+R2**2*X1*(2-X1-X2)+X1**2*(2-X1-X2)
     &       +X2)/(-1-R1**2+R2**2+X1)**2
        RFO2=RFO2/2.D0
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(2D0-R1**2-R1**4-R2**2+2D0*R1**2*R2**2-R2**4)/2D0
        RFO4=(1-R1**4+6*R1**2*R2**2-R2**4+X1+3*R1**2*X1-9*R2**2*X1
     &       -3*X1**2-R1**2*X1**2+3*R2**2*X1**2+X1**3-X2-R1**2*X2
     &       +R2**2*X2-R1**2*X1*X2+R2**2*X1*X2+X1**2*X2)/
     &       (-1-R1**2+R2**2+X1)**2
        RFO4=RFO4
     &       -2*(1+R1**2+R2**2-4*R1**2*R2**2+R1**2*X1+2*R2**2*X1-X1**2
     &       -R2**2*X1**2+2*R1**2*X2+R2**2*X2-3*X1*X2+X1**2*X2-X2**2
     &       -R1**2*X2**2+X1*X2**2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
        RFO4=RFO4+(1-R1**4+6*R1**2*R2**2-R2**4-X1+R1**2*X1-R2**2*X1+X2
     &       -9*R1**2*X2+3*R2**2*X2+R1**2*X1*X2-R2**2*X1*X2-3*X2**2
     &       +3*R1**2*X2**2-R2**2*X2**2+X1*X2**2+X2**3)/
     &       (-1+R1**2-R2**2+X2)**2
        RFO4=RFO4/2.D0
        ISSET4=1
        ENDIF
 
C...q -> q V.
      ELSEIF(ICLASS.EQ.3) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0-2D0*R1**2+R1**4+R2**2-6D0*R1*R2**2
     &        +R1**2*R2**2-2D0*R2**4)
        RFO1=2*(-1+R1-2*R1**2+2*R1**3-R1**4+R1**5-R2**2+R1*R2**2
     &       -5*R1**2*R2**2+R1**3*R2**2-2*R1*R2**4+2*X1-2*R1*X1
     &       +2*R1**2*X1-2*R1**3*X1+2*R2**2*X1+5*R1*R2**2*X1
     &       +R1**2*R2**2*X1+2*R2**4*X1-X1**2+R1*X1**2-R2**2*X1**2+3*X2
     &       +4*R1**2*X2+R1**4*X2+2*R2**2*X2+2*R1**2*R2**2*X2-4*X1*X2
     &       -2*R1**2*X1*X2-R2**2*X1*X2+X1**2*X2-2*X2**2
     &       -2*R1**2*X2**2+X1*X2**2)/(1-R1**2+R2**2-X2)/(-2+X1+X2)
        RFO1=RFO1+(2*R2**2+6*R1*R2**2-6*R1**2*R2**2+6*R1**3*R2**2
     &       +2*R2**4+6*R1*R2**4-R2**2*X1+R1**2*R2**2*X1-R2**4*X1+X2
     &       -R1**4*X2-3*R2**2*X2-6*R1*R2**2*X2+9*R1**2*R2**2*X2
     &       -2*R2**4*X2-X1*X2+R1**2*X1*X2-X2**2-3*R1**2*X2**2
     &       +2*R2**2*X2**2+X1*X2**2)/(-1+R1**2-R2**2+X2)**2
        RFO1=RFO1+(-4-8*R1**2-4*R1**4+4*R2**2-4*R1**2*R2**2+8*R2**4
     &       +9*X1+10*R1**2*X1+R1**4*X1-3*R2**2*X1+6*R1*R2**2*X1
     &       +R1**2*R2**2*X1-2*R2**4*X1-6*X1**2-2*R1**2*X1**2+X1**3
     &       +7*X2+8*R1**2*X2+R1**4*X2-7*R2**2*X2+6*R1*R2**2*X2
     &       +R1**2*R2**2*X2-2*R2**4*X2-9*X1*X2-3*R1**2*X1*X2
     &       +2*R2**2*X1*X2+2*X1**2*X2-3*X2**2-R1**2*X2**2
     &       +2*R2**2*X2**2+X1*X2**2)/(-2+X1+X2)**2
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-2D0*R1**2+R1**4+R2**2+6D0*R1*R2**2
     &        +R1**2*R2**2-2D0*R2**4)
        RFO2=2*(1+R1+2*R1**2+2*R1**3+R1**4+R1**5+R2**2+R1*R2**2
     &       +5*R1**2*R2**2+R1**3*R2**2-2*R1*R2**4-2*X1-2*R1*X1
     &       -2*R1**2*X1-2*R1**3*X1-2*R2**2*X1+5*R1*R2**2*X1
     &       -R1**2*R2**2*X1-2*R2**4*X1+X1**2+R1*X1**2+R2**2*X1**2-3*X2
     &       -4*R1**2*X2-R1**4*X2-2*R2**2*X2-2*R1**2*R2**2*X2+4*X1*X2
     &       +2*R1**2*X1*X2+R2**2*X1*X2-X1**2*X2+2*X2**2+2*R1**2*X2**2
     &       -X1*X2**2)/(-1+R1**2-R2**2+X2)/(-2+X1+X2)
        RFO2=RFO2+(2*R2**2-6*R1*R2**2-6*R1**2*R2**2-6*R1**3*R2**2
     &       +2*R2**4-6*R1*R2**4-R2**2*X1+R1**2*R2**2*X1-R2**4*X1+X2
     &       -R1**4*X2-3*R2**2*X2+6*R1*R2**2*X2+9*R1**2*R2**2*X2
     &       -2*R2**4*X2-X1*X2+R1**2*X1*X2-X2**2-3*R1**2*X2**2
     &       +2*R2**2*X2**2+X1*X2**2)/(-1+R1**2-R2**2+X2)**2
        RFO2=RFO2+(-4-8*R1**2-4*R1**4+4*R2**2-4*R1**2*R2**2+8*R2**4+9*X1
     &       +10*R1**2*X1+R1**4*X1-3*R2**2*X1-6*R1*R2**2*X1
     &       +R1**2*R2**2*X1-2*R2**4*X1-6*X1**2-2*R1**2*X1**2+X1**3
     &       +7*X2+8*R1**2*X2+R1**4*X2-7*R2**2*X2-6*R1*R2**2*X2
     &       +R1**2*R2**2*X2-2*R2**4*X2-9*X1*X2-3*R1**2*X1*X2
     &       +2*R2**2*X1*X2+2*X1**2*X2-3*X2**2-R1**2*X2**2+2*R2**2*X2**2
     &       +X1*X2**2)/(-2+X1+X2)**2
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1.D0-2.D0*R1**2+R1**4+R2**2+R1**2*R2**2-2.D0*R2**4)
        RFO4=2*(1+2*R1**2+R1**4+R2**2+5*R1**2*R2**2-2*X1-2*R1**2*X1
     &       -2*R2**2*X1-R1**2*R2**2*X1-2*R2**4*X1+X1**2+R2**2*X1**2
     &       -3*X2-4*R1**2*X2-R1**4*X2-2*R2**2*X2-2*R1**2*R2**2*X2
     &       +4*X1*X2+2*R1**2*X1*X2+R2**2*X1*X2-X1**2*X2+2*X2**2
     &       +2*R1**2*X2**2-X1*X2**2)/(-1+R1**2-R2**2+X2)/(-2+X1+X2)
        RFO4=RFO4+(2*R2**2-6*R1**2*R2**2+2*R2**4-R2**2*X1+R1**2*R2**2*X1
     &       -R2**4*X1+X2-R1**4*X2-3*R2**2*X2+9*R1**2*R2**2*X2
     &       -2*R2**4*X2-X1*X2+R1**2*X1*X2-X2**2-3*R1**2*X2**2
     &       +2*R2**2*X2**2+X1*X2**2)/(-1+R1**2-R2**2+X2)**2
        RFO4=RFO4+(-4-8*R1**2-4*R1**4+4*R2**2-4*R1**2*R2**2+8*R2**4+9*X1
     &       +10*R1**2*X1+R1**4*X1-3*R2**2*X1+R1**2*R2**2*X1-2*R2**4*X1
     &       -6*X1**2-2*R1**2*X1**2+X1**3+7*X2+8*R1**2*X2+R1**4*X2
     &       -7*R2**2*X2+R1**2*R2**2*X2-2*R2**4*X2-9*X1*X2-3*R1**2*X1*X2
     &       +2*R2**2*X1*X2+2*X1**2*X2-3*X2**2-R1**2*X2**2+2*R2**2*X2**2
     &       +X1*X2**2)/(2-X1-X2)**2
        ISSET4=1
        ENDIF
 
C...S -> q qbar    (S = h0/H0/A0/H+-/...).
      ELSEIF(ICLASS.EQ.4) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0-R1**2-R2**2-2D0*R1*R2)
        RFO1=-(-1+R1**4-2*R1*R2-2*R1**3*R2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+2*R1*R2*X1+3*R2**2*X1+X2+R1**2*X2
     &       -R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2
     &       -2*(R1**2+R1**4-2*R1**3*R2+R2**2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4-R1**2*X1+R1*R2*X1+2*R2**2*X1+2*R1**2*X2+R1*R2*X2
     &       -R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
     &       -(-1+R1**4-2*R1*R2-2*R1**3*R2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2+2*R1*R2*X2
     &       -R2**2*X2-X1*X2)/(-1+R1**2-R2**2+X2)**2
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-R1**2-R2**2+2D0*R1*R2)
        RFO2=-(-1+R1**4+2*R1*R2+2*R1**3*R2-6*R1**2*R2**2+2*R1*R2**3
     &       +R2**4+X1-R1**2*X1-2*R1*R2*X1+3*R2**2*X1+X2+R1**2*X2
     &       -R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2
     &       -(-1+R1**4+2*R1*R2+2*R1**3*R2-6*R1**2*R2**2+2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2-2*R1*R2*X2
     &       -R2**2*X2-X1*X2)/(-1+R1**2-R2**2+X2)**2
     &       +2*(-R1**2-R1**4-2*R1**3*R2-R2**2+6*R1**2*R2**2
     &       -2*R1*R2**3-R2**4+R1**2*X1+R1*R2*X1-2*R2**2*X1
     &       -2*R1**2*X2+R1*R2*X2+R2**2*X2+X1*X2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0-R1**2-R2**2)
        RFO4=-(-1+R1**4-6*R1**2*R2**2+R2**4+X1-R1**2*X1+3*R2**2*X1+X2
     &       +R1**2*X2-R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2
     &       -2*(R1**2+R1**4+R2**2-6*R1**2*R2**2+R2**4-R1**2*X1
     &       +2*R2**2*X1+2*R1**2*X2-R2**2*X2-X1*X2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
     &       -(-1+R1**4-6*R1**2*R2**2+R2**4+X1-R1**2*X1+R2**2*X1
     &       +X2+3*R1**2*X2-R2**2*X2-X1*X2)/(-1+R1**2-R2**2+X2)**2
        ISSET4=1
        ENDIF
 
C...q -> q S.
      ELSEIF(ICLASS.EQ.5) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0+R1**2-R2**2+2D0*R1)
        RFO1=(4-4*R1**2+4*R2**2-3*X1-2*R1*X1+R1**2*X1-R2**2*X1-5*X2
     &       -2*R1*X2+R1**2*X2-R2**2*X2+X1*X2+X2**2)/(-2+X1+X2)**2
     &       +2*(3-R1-5*R1**2-R1**3+3*R2**2+R1*R2**2-2*X1-R1*X1
     &       +R1**2*X1-4*X2+2*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (1-R1**2+R2**2-X2)/(-2+X1+X2)
     &       +(2-2*R1-6*R1**2-2*R1**3+2*R2**2-2*R1*R2**2-X1+R1**2*X1
     &       -R2**2*X1-3*X2+2*R1*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (-1+R1**2-R2**2+X2)**2
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0+R1**2-R2**2-2D0*R1)
        RFO2=(4-4*R1**2+4*R2**2-3*X1+2*R1*X1+R1**2*X1-R2**2*X1-5*X2
     &       +2*R1*X2+R1**2*X2-R2**2*X2+X1*X2+X2**2)/(-2+X1+X2)**2
     &       +2*(3+R1-5*R1**2+R1**3+3*R2**2-R1*R2**2-2*X1+R1*X1
     &       +R1**2*X1-4*X2+2*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (1-R1**2+R2**2-X2)/(-2+X1+X2)
     &       +(2+2*R1-6*R1**2+2*R1**3+2*R2**2+2*R1*R2**2-X1+R1**2*X1
     &       -R2**2*X1-3*X2-2*R1*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (-1+R1**2-R2**2+X2)**2
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0+R1**2-R2**2)
        RFO4=(4-4*R1**2+4*R2**2-3*X1+R1**2*X1-R2**2*X1-5*X2+R1**2*X2
     &       -R2**2*X2+X1*X2+X2**2)/(-2+X1+X2)**2
     &       +2*(3-5*R1**2+3*R2**2-2*X1+R1**2*X1-4*X2+2*R1**2*X2
     &       -R2**2*X2+X1*X2+X2**2)/(1-R1**2+R2**2-X2)/(-2+X1+X2)
     &       +(2-6*R1**2+2*R2**2-X1+R1**2*X1-R2**2*X1-3*X2+3*R1**2*X2
     &       -R2**2*X2+X1*X2+X2**2)/(-1+R1**2-R2**2+X2)**2
        ISSET4=1
        ENDIF
 
C...V -> ~q ~qbar  (~q = squark).
      ELSEIF(ICLASS.EQ.6) THEN
        RLO1=PS*(1D0-2D0*R1**2+R1**4-2D0*R2**2-2D0*R1**2*R2**2+R2**4)
        RFO1=2D0*3D0+(1+R1**2+R2**2-X1)*(4*R1**2-X1**2)/
     &       (-1-R1**2+R2**2+X1)**2
     &       -2D0*(-1-3*R1**2-R2**2+X1+X1**2/2+X2-X1*X2/2)/
     &       (-1-R1**2+R2**2+X1)
     &       +(1+R1**2+R2**2-X2)*(4*R2**2-X2**2)
     &       /(-1+R1**2-R2**2+X2)**2
     &       -2D0*(-1-R1**2-3*R2**2+X1+X2-X1*X2/2+X2**2/2)/
     &       (-1+R1**2-R2**2+X2)
     &       -(-4*R1**2-4*R1**4-4*R2**2-8*R1**2*R2**2-4*R2**4+2*X1
     &       +6*R1**2*X1+6*R2**2*X1-2*X1**2+2*X2+6*R1**2*X2+6*R2**2*X2
     &       -4*X1*X2-2*R1**2*X1*X2-2*R2**2*X1*X2+X1**2*X2-2*X2**2
     &       +X1*X2**2)/(-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
        ISSET1=1
 
C...~q -> ~q V.
      ELSEIF(ICLASS.EQ.7) THEN
        RLO1=PS*(1D0-2D0*R1**2+R1**4-2D0*R2**2-2D0*R1**2*R2**2+R2**4)
        RFO1=16*R2**2+8*(4*R2**2+2*R2**2*X1+X2+R1**2*X2+R2**2*X2-X1*X2
     &       -2*X2**2)/(3*(-1+R1**2-R2**2+X2))+8*(1+R1**2+R2**2-X2)*
     &       (4*R2**2-X2**2)/(3*(-1+R1**2-R2**2+X2)**2)+8*(X1+X2)*
     &       (-1-2*R1**2-R1**4-2*R2**2+2*R1**2*R2**2-R2**4+2*X1
     &       +2*R1**2*X1+2*R2**2*X1-X1**2+2*X2+2*R1**2*X2+2*R2**2*X2
     &       -2*X1*X2-X2**2)/(3*(-2+X1+X2)**2)+8*(-1-R1**2+R2**2-X1)*
     &       (2*R2**2*X1+X2+R1**2*X2+R2**2*X2-X1*X2-X2**2)/
     &       (3*(-1+R1**2-R2**2+X2)*(-2+X1+X2))+8*(1+2*R1**2+R1**4
     &       +2*R2**2-2*R1**2*R2**2+R2**4-2*X1-2*R1**2*X1-4*R2**2*X1
     &       +X1**2-3*X2-3*R1**2*X2-3*R2**2*X2+3*X1*X2+2*X2**2)/
     &       (3*(-2+X1+X2))
        RFO1=3D0*RFO1/8D0
        ISSET1=1
 
C...S -> ~q ~qbar.
      ELSEIF(ICLASS.EQ.8) THEN
        RLO1=PS
        RFO1=(-1-2*R1**2-R1**4-2*R2**2+2*R1**2*R2**2-R2**4+2*X1
     &       +2*R1**2*X1+2*R2**2*X1-X1**2-R2**2*X1**2+2*X2+2*R1**2*X2
     &       +2*R2**2*X2-3*X1*X2-R1**2*X1*X2-R2**2*X1*X2+X1**2*X2-X2**2
     &       -R1**2*X2**2+X1*X2**2)/
     &       (1+R1**2-R2**2-X1)**2/(-1+R1**2-R2**2+X2)**2
        RFO1=2D0*RFO1
        ISSET1=1
 
C...~q -> ~q S.
      ELSEIF(ICLASS.EQ.9) THEN
        RLO1=PS
        RFO1=(-1-R1**2-R2**2+X2)/(-1+R1**2-R2**2+X2)**2
     &       +(1+R1**2-R2**2+X1)/(-1+R1**2-R2**2+X2)/(-2+X1+X2)
     &       -(X1+X2)/(-2+X1+X2)**2
        ISSET1=1
 
C...chi -> q ~qbar   (chi = neutralino/chargino).
      ELSEIF(ICLASS.EQ.10) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0+R1**2-R2**2+2D0*R1)
        RFO1=(2*R1+X1)*(-1-R1**2-R2**2+X1)/(-1-R1**2+R2**2+X1)**2
     &       +2*(-1-R1**2-2*R1**3-R2**2-2*R1*R2**2+3*X1/2+R1*X1
     &       -R1**2*X1/2-R2**2*X1/2+X2+R1*X2+R1**2*X2-X1*X2/2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
     &       +(2-2*R1-6*R1**2-2*R1**3+2*R2**2-2*R1*R2**2-X1+R1**2*X1
     &       -R2**2*X1-3*X2+2*R1*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (-1+R1**2-R2**2+X2)**2
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-2D0*R1+R1**2-R2**2)
        RFO2=(2*R1-X1)*(1+R1**2+R2**2-X1)/(-1-R1**2+R2**2+X1)**2
     &       +2*(-1-R1**2+2*R1**3-R2**2+2*R1*R2**2+3*X1/2-R1*X1
     &       -R1**2*X1/2-R2**2*X1/2+X2-R1*X2+R1**2*X2-X1*X2/2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
     &       +(2+2*R1-6*R1**2+2*R1**3+2*R2**2+2*R1*R2**2-X1+R1**2*X1
     &       -R2**2*X1-3*X2-2*R1*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (-1+R1**2-R2**2+X2)**2
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1+R1**2-R2**2)
        RFO4=X1*(-1-R1**2-R2**2+X1)/(-1-R1**2+R2**2+X1)**2
     &       +2D0*(-1-R1**2-R2**2+3*X1/2-R1**2*X1/2-R2**2*X1/2
     &       +X2+R1**2*X2-X1*X2/2)/
     &       (-1-R1**2+R2**2+X1)/(-1+R1**2-R2**2+X2)
     &       +(2-6*R1**2+2*R2**2-X1+R1**2*X1-R2**2*X1-3*X2+3*R1**2*X2
     &       -R2**2*X2+X1*X2+X2**2)/(-1+R1**2-R2**2+X2)**2
        ISSET4=1
        ENDIF
 
C...~q -> q chi.
      ELSEIF(ICLASS.EQ.11) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0-(R1+R2)**2)
        RFO1=(1+R1**2+2*R1*R2+R2**2-X1-X2)*(X1+X2)/(-2+X1+X2)**2
     &       -(-1+R1**4-2*R1*R2-2*R1**3*R2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2+2*R1*R2*X2
     &       -R2**2*X2-X1*X2)/(-1+R1**2-R2**2+X2)**2
     &       +(-1-2*R1**2-R1**4-2*R1*R2-2*R1**3*R2+2*R1*R2**3+R2**4
     &       +X1+R1**2*X1-2*R1*R2*X1-3*R2**2*X1+2*R1**2*X2-2*R2**2*X2
     &       +X1*X2+X2**2)/(-1+R1**2-R2**2+X2)/(-2+X1+X2)
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-(R1-R2)**2)
        RFO2=(1+R1**2-2*R1*R2+R2**2-X1-X2)*(X1+X2)/
     &       (-2+X1+X2)**2
     &       -(-1+R1**4+2*R1*R2+2*R1**3*R2-6*R1**2*R2**2+2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2-2*R1*R2*X2
     &       -R2**2*X2-X1*X2)/(-1+R1**2-R2**2+X2)**2
     &       +(-1-2*R1**2-R1**4+2*R1*R2+2*R1**3*R2-2*R1*R2**3+R2**4
     &       +X1+R1**2*X1+2*R1*R2*X1-3*R2**2*X1+2*R1**2*X2-2*R2**2*X2
     &       +X1*X2+X2**2)/(-1+R1**2-R2**2+X2)/(-2+X1+X2)
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0-R1**2-R2**2)
        RFO4=(1+R1**2+R2**2-X1-X2)*(X1+X2)/(-2+X1+X2)**2
     &       -(-1+R1**4-6*R1**2*R2**2+R2**4+X1-R1**2*X1+R2**2*X1+X2
     &       +3*R1**2*X2-R2**2*X2-X1*X2)/
     &       (-1+R1**2-R2**2+X2)**2
     &       -(-1-2*R1**2-R1**4+R2**4+X1+R1**2*X1-3*R2**2*X1
     &       +2*R1**2*X2-2*R2**2*X2+X1*X2+X2**2)/
     &       (2-X1-X2)/(-1+R1**2-R2**2+X2)
        ISSET4=1
        ENDIF
 
C...q -> ~q chi.
      ELSEIF(ICLASS.EQ.12) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0-R1**2+R2**2+2D0*R2)
        RFO1=(2*R2+X2)*(-1-R1**2-R2**2+X2)/(-1+R1**2-R2**2+X2)**2
     &       +(4+4*R1**2-4*R2**2-5*X1-R1**2*X1-2*R2*X1+R2**2*X1+X1**2
     &       -3*X2-R1**2*X2-2*R2*X2+R2**2*X2+X1*X2)/
     &       (-2+X1+X2)**2-2*(-1-R1**2+R2+R1**2*R2-R2**2-R2**3+X1
     &       +R2*X1+R2**2*X1+2*X2+R1**2*X2-X1*X2/2-X2**2/2)/
     &       (2-X1-X2)/(-1+R1**2-R2**2+X2)
        ISSET1=1
        END IF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-R1**2+R2**2-2D0*R2)
        RFO2=(2*R2-X2)*(1+R1**2+R2**2-X2)/(-1+R1**2-R2**2+X2)**2
     &       +(4+4*R1**2-4*R2**2-5*X1-R1**2*X1+2*R2*X1+R2**2*X1+X1**2
     &       -3*X2-R1**2*X2+2*R2*X2+R2**2*X2+X1*X2)/
     &       (-2+X1+X2)**2-2*(-1-R1**2-R2-R1**2*R2-R2**2+R2**3+X1
     &       -R2*X1+R2**2*X1+2*X2+R1**2*X2-X1*X2/2-X2**2/2)/
     &       (2-X1-X2)/(-1+R1**2-R2**2+X2)
        ISSET2=1
        END IF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0-R1**2+R2**2)
        RFO4=X2*(-1-R1**2-R2**2+X2)/(-1+R1**2-R2**2+X2)**2
     &       +(4+4*R1**2-4*R2**2-5*X1-R1**2*X1+R2**2*X1+X1**2
     &       -3*X2-R1**2*X2+R2**2*X2+X1*X2)/
     &       (-2+X1+X2)**2-2*(-1-R1**2-R2**2+X1+R2**2*X1+2*X2
     &       +R1**2*X2-X1*X2/2-X2**2/2)/
     &       (2-X1-X2)/(-1+R1**2-R2**2+X2)
        ISSET4=1
        END IF
 
C...~g -> q ~qbar.
      ELSEIF(ICLASS.EQ.13) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0+R1**2-R2**2+2D0*R1)
        RFO1=4*(2*R1+X1)*(-1-R1**2-R2**2+X1)/(3*(-1-R1**2+R2**2+X1)**2)
     &       -(-1-R1**2-2*R1**3-R2**2-2*R1*R2**2+3*X1/2+R1*X1-R1**2*X1/2
     &       -R2**2*X1/2+X2+R1*X2+R1**2*X2-X1*X2/2)/(3*(-1-R1**2+R2**2
     &       +X1)*(-1+R1**2-R2**2+X2))-3*(-1+R1-R1**2-R1**3-R2**2
     &       +R1*R2**2+2*X1+R2**2*X1-X1**2/2+X2+R1*X2+R1**2*X2-X1*X2/2)/
     &       ((-1-R1**2+R2**2+X1)*(2-X1-X2))+3*(4-4*R1**2+4*R2**2-3*X1
     &       -2*R1*X1+R1**2*X1-R2**2*X1-5*X2-2*R1*X2+R1**2*X2-R2**2*X2
     &       +X1*X2+X2**2)/(-2+X1+X2)**2+3*(3-R1-5*R1**2-R1**3+3*R2**2
     &       +R1*R2**2-2*X1-R1*X1+R1**2*X1-4*X2+2*R1**2*X2-R2**2*X2
     &       +X1*X2+X2**2)/((1-R1**2+R2**2-X2)*(-2+X1+X2))+4*(2-2*R1
     &       -6*R1**2-2*R1**3+2*R2**2-2*R1*R2**2-X1+R1**2*X1-R2**2*X1
     &       -3*X2+2*R1*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (3*(-1+R1**2-R2**2+X2)**2)
        RFO1=3D0*RFO1/4D0
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0+R1**2-R2**2-2D0*R1)
        RFO2=4*(2*R1-X1)*(1+R1**2+R2**2-X1)/(3*(-1-R1**2+R2**2+X1)**2)
     &       -3*(-1-R1-R1**2+R1**3-R2**2-R1*R2**2+2*X1+R2**2*X1-X1**2/2
     &       +X2-R1*X2+R1**2*X2-X1*X2/2)/((-1-R1**2+R2**2+X1)*(2-X1-X2))
     &       +(2+2*R1**2-4*R1**3+2*R2**2-4*R1*R2**2-3*X1+2*R1*X1
     &       +R1**2*X1+R2**2*X1-2*X2+2*R1*X2-2*R1**2*X2+X1*X2)/
     &       (6*(-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))+3*(4-4*R1**2
     &       +4*R2**2-3*X1+2*R1*X1+R1**2*X1-R2**2*X1-5*X2+2*R1*X2
     &       +R1**2*X2-R2**2*X2+X1*X2+X2**2)/(-2+X1+X2)**2+3*(3+R1
     &       -5*R1**2+R1**3+3*R2**2-R1*R2**2-2*X1+R1*X1+R1**2*X1-4*X2
     &       +2*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       ((1-R1**2+R2**2-X2)*(-2+X1+X2))+4*(2+2*R1-6*R1**2+2*R1**3
     &       +2*R2**2+2*R1*R2**2-X1+R1**2*X1-R2**2*X1-3*X2-2*R1*X2
     &       +3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (3*(-1+R1**2-R2**2+X2)**2)
        RFO2=3D0*RFO2/4D0
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0+R1**2-R2**2)
        RFO4=8*X1*(-1-R1**2-R2**2+X1)/(3*(-1-R1**2+R2**2+X1)**2)-6*(-1
     &       -R1**2-R2**2+2*X1+R2**2*X1-X1**2/2+X2+R1**2*X2-X1*X2/2)/
     &       ((-1-R1**2+R2**2+X1)*(2-X1-X2))+(2+2*R1**2+2*R2**2-3*X1
     &       +R1**2*X1+R2**2*X1-2*X2-2*R1**2*X2+X1*X2)/(3*(-1-R1**2
     &       +R2**2+X1)*(-1+R1**2-R2**2+X2))+6*(4-4*R1**2+4*R2**2-3*X1
     &       +R1**2*X1-R2**2*X1-5*X2+R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (-2+X1+X2)**2+6*(3-5*R1**2+3*R2**2-2*X1+R1**2*X1-4*X2
     &       +2*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       ((1-R1**2+R2**2-X2)*(-2+X1+X2))+8*(2-6*R1**2+2*R2**2-X1
     &       +R1**2*X1-R2**2*X1-3*X2+3*R1**2*X2-R2**2*X2+X1*X2+X2**2)/
     &       (3*(-1+R1**2-R2**2+X2)**2)
        RFO4=3D0*RFO4/8D0
        ISSET4=1
        ENDIF
 
C...~q -> q ~g.
      ELSEIF(ICLASS.EQ.14) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1-R1**2-R2**2-2D0*R1*R2)
        RFO1=64*(1+R1**2+2*R1*R2+R2**2-X1-X2)*(X1+X2)/(9*(-2+X1+X2)**2)
     &       -16*(-1+R1**4-2*R1*R2-2*R1**3*R2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+2*R1*R2*X1+3*R2**2*X1+X2+R1**2*X2
     &       -R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2-16*(R1**2+R1**4
     &       -2*R1**3*R2+R2**2-6*R1**2*R2**2-2*R1*R2**3+R2**4
     &       -R1**2*X1+R1*R2*X1+2*R2**2*X1+2*R1**2*X2+R1*R2*X2-R2**2*X2
     &       -X1*X2)/((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))
     &       -64*(-1+R1**4-2*R1*R2-2*R1**3*R2-6*R1**2*R2**2-2*R1*R2**3
     &       +R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2+2*R1*R2*X2
     &       -R2**2*X2-X1*X2)/(9*(-1+R1**2-R2**2+X2)**2)
     &       +8*(-1+R1**4-2*R1*R2+2*R1**3*R2-2*R2**2-2*R1*R2**3-R2**4
     &       -2*R1**2*X1+2*R2**2*X1+X1**2+X2-3*R1**2*X2-2*R1*R2*X2
     &       +R2**2*X2+X1*X2)/((-1-R1**2+R2**2+X1)*(-2+X1+X2))
        RFO1=RFO1
     &       +8*(-1-2*R1**2-R1**4-2*R1*R2-2*R1**3*R2+2*R1*R2**3+R2**4
     &       +X1+R1**2*X1-2*R1*R2*X1-3*R2**2*X1+2*R1**2*X2-2*R2**2*X2
     &       +X1*X2+X2**2)/(9*(2-X1-X2)*(-1+R1**2-R2**2+X2))
        RFO1=9D0*RFO1/64D0
        ISSET1=1
        ENDIF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1-R1**2-R2**2+2D0*R1*R2)
        RFO2=64*(1+R1**2-2*R1*R2+R2**2-X1-X2)*(X1+X2)/(9*(-2+X1+X2)**2)
     &       -16*(-1+R1**4+2*R1*R2+2*R1**3*R2-6*R1**2*R2**2+2*R1*R2**3
     &       +R2**4+X1-R1**2*X1-2*R1*R2*X1+3*R2**2*X1+X2+R1**2*X2
     &       -R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2-64*(-1+R1**4
     &       +2*R1*R2+2*R1**3*R2-6*R1**2*R2**2+2*R1*R2**3+R2**4+X1
     &       -R1**2*X1+R2**2*X1+X2+3*R1**2*X2-2*R1*R2*X2-R2**2*X2
     &       -X1*X2)/(9*(-1+R1**2-R2**2+X2)**2)+16*(-R1**2-R1**4
     &       -2*R1**3*R2-R2**2+6*R1**2*R2**2-2*R1*R2**3-R2**4+R1**2*X1
     &       +R1*R2*X1-2*R2**2*X1-2*R1**2*X2+R1*R2*X2+R2**2*X2+X1*X2)/
     &       ((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))
        RFO2=RFO2
     &       +8*(-1+R1**4+2*R1*R2-2*R1**3*R2-2*R2**2+2*R1*R2**3-R2**4
     &       -2*R1**2*X1+2*R2**2*X1+X1**2+X2-3*R1**2*X2+2*R1*R2*X2
     &       +R2**2*X2+X1*X2)/((-1-R1**2+R2**2+X1)*(-2+X1+X2))
     &       +8*(-1-2*R1**2-R1**4+2*R1*R2+2*R1**3*R2-2*R1*R2**3
     &       +R2**4+X1+R1**2*X1+2*R1*R2*X1-3*R2**2*X1+2*R1**2*X2
     &       -2*R2**2*X2+X1*X2+X2**2)/(9*(2-X1-X2)*(-1+R1**2-R2**2+X2))
        RFO2=9D0*RFO2/64D0
        ISSET2=1
        ENDIF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1-R1**2-R2**2)
        RFO4=128*(1+R1**2+R2**2-X1-X2)*(X1+X2)/(9*(-2+X1+X2)**2)-32*(-1
     &       +R1**4-6*R1**2*R2**2+R2**4+X1-R1**2*X1+3*R2**2*X1+X2
     &       +R1**2*X2-R2**2*X2-X1*X2)/(-1-R1**2+R2**2+X1)**2
     &       -32*(R1**2+R1**4+R2**2-6*R1**2*R2**2+R2**4-R1**2*X1
     &       +2*R2**2*X1+2*R1**2*X2-R2**2*X2-X1*X2)/
     &       ((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))-128*(-1+R1**4
     &       -6*R1**2*R2**2+R2**4+X1-R1**2*X1+R2**2*X1+X2+3*R1**2*X2
     &       -R2**2*X2-X1*X2)/(9*(-1+R1**2-R2**2+X2)**2)
     &       +16*(-1+R1**4-2*R2**2-R2**4-2*R1**2*X1+2*R2**2*X1+X1**2
     &       +X2-3*R1**2*X2+R2**2*X2+X1*X2)/
     &       ((-1-R1**2+R2**2+X1)*(-2+X1+ X2))
        RFO4=RFO4+16*(-1-2*R1**2-R1**4+R2**4+X1+R1**2*X1-3*R2**2*X1
     &       +2*R1**2*X2-2*R2**2*X2+X1*X2+X2**2)/
     &       (9*(1-R1**2+R2**2-X2)*(-2+X1+X2))
        RFO4=9D0*RFO4/128D0
        ISSET4=1
        ENDIF
 
C...q -> ~q ~g.
      ELSEIF(ICLASS.EQ.15) THEN
        IF(ICOMBI.EQ.1.OR.ICOMBI.EQ.3) THEN
        RLO1=PS*(1D0-R1**2+R2**2+2D0*R2)
        RFO1=32*(2*R2+X2)*(-1-R1**2-R2**2+X2)/(9*(-1+R1**2-R2**2+X2)**2)
     &       +8*(-1-R1**2-2*R1**2*R2-R2**2-2*R2**3+X1+R2*X1+R2**2*X1
     &       +3*X2/2-R1**2*X2/2+R2*X2-R2**2*X2/2-X1*X2/2)/
     &       ((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))+8*(2+2*R1**2-2*R2
     &       -2*R1**2*R2-6*R2**2-2*R2**3-3*X1-R1**2*X1+2*R2*X1
     &       +3*R2**2*X1+X1**2-X2-R1**2*X2+R2**2*X2+X1*X2)/
     &       (-1-R1**2+R2**2+X1)**2+32*(4+4*R1**2-4*R2**2-5*X1
     &       -R1**2*X1-2*R2*X1+R2**2*X1+X1**2-3*X2-R1**2*X2-2*R2*X2
     &       +R2**2*X2+X1*X2)/(9*(-2+X1+X2)**2)
        RFO1=RFO1+8*(3+3*R1**2-R2+R1**2*R2-5*R2**2-R2**3-4*X1-R1**2*X1
     &       +2*R2**2*X1+X1**2-2*X2-R2*X2+R2**2*X2+X1*X2)/
     &       ((-1-R1**2+R2**2+X1)*(2-X1-X2))+8*(-1-R1**2+R2+R1**2*R2
     &       -R2**2-R2**3+X1+R2*X1+R2**2*X1+2*X2+R1**2*X2-X1*X2/2
     &       -X2**2/2)/(9*(2-X1-X2)*(-1+R1**2-R2**2+X2))
        RFO1=9D0*RFO1/32D0
        ISSET1=1
        END IF
        IF(ICOMBI.EQ.2.OR.ICOMBI.EQ.3) THEN
        RLO2=PS*(1D0-R1**2+R2**2-2D0*R2)
        RFO2=32*(2*R2-X2)*(1+R1**2+R2**2-X2)/(9*(-1+R1**2-R2**2+X2)**2)
     &       +8*(-1-R1**2+2*R1**2*R2-R2**2+2*R2**3+X1-R2*X1+R2**2*X1
     &       +3*X2/2-R1**2*X2/2-R2*X2-R2**2*X2/2-X1*X2/2)/
     &       ((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))+8*(2+2*R1**2+2*R2
     &       +2*R1**2*R2-6*R2**2+2*R2**3-3*X1-R1**2*X1-2*R2*X1
     &       +3*R2**2*X1+X1**2-X2-R1**2*X2+R2**2*X2+X1*X2)/
     &       (-1-R1**2+R2**2+X1)**2+8*(3+3*R1**2+R2-R1**2*R2-5*R2**2
     &       +R2**3-4*X1-R1**2*X1+2*R2**2*X1+X1**2-2*X2+R2*X2+R2**2*X2
     &       +X1*X2)/((-1-R1**2+R2**2+X1)*(2-X1-X2))
        RFO2=RFO2+32*(4+4*R1**2-4*R2**2-5*X1-R1**2*X1+2*R2*X1+R2**2*X1
     &       +X1**2-3*X2-R1**2*X2+2*R2*X2+R2**2*X2+X1*X2)/
     &       (9*(-2+X1+X2)**2)+8*(-1-R1**2-R2-R1**2*R2-R2**2+R2**3+X1
     &       -R2*X1+R2**2*X1+2*X2+R1**2*X2-X1*X2/2-X2**2/2)/
     &       (9*(2-X1-X2)*(-1+R1**2-R2**2+X2))
        RFO2=9D0*RFO2/32D0
        ISSET2=1
        END IF
        IF(ICOMBI.EQ.4) THEN
        RLO4=PS*(1D0-R1**2+R2**2)
        RFO4=64*X2*(-1-R1**2-R2**2+X2)/(9*(-1+R1**2-R2**2+X2)**2)
     &       +16*(-1-R1**2-R2**2+X1+R2**2*X1+3*X2/2-R1**2*X2/2
     &       -R2**2*X2/2-X1*X2/2)/
     &       ((-1-R1**2+R2**2+X1)*(-1+R1**2-R2**2+X2))+16*(3+3*R1**2
     &       -5*R2**2-4*X1-R1**2*X1+2*R2**2*X1+X1**2-2*X2+R2**2*X2
     &       +X1*X2)/((-1-R1**2+R2**2+X1)*(2-X1-X2))
     &       +64*(4+4*R1**2-4*R2**2-5*X1-R1**2*X1+R2**2*X1+X1**2-3*X2
     &       -R1**2*X2+R2**2*X2+X1*X2)/(9*(-2+X1+X2)**2)
        RFO4=RFO4+16*(2+2*R1**2-6*R2**2-3*X1-R1**2*X1+3*R2**2*X1+X1**2
     &       -X2-R1**2*X2+R2**2*X2+X1*X2)/(-1-R1**2+R2**2+X1)**2
     &       +16*(-1-R1**2-R2**2+X1+R2**2*X1+2*X2+R1**2*X2-X1*X2/2
     &       -X2**2/2)/(9*(2-X1-X2)*(-1+R1**2-R2**2+X2))
        RFO4=9D0*RFO4/64D0
        ISSET4=1
        END IF
 
C...g -> ~g ~g. Use (9/4)*eikonal. May be changed in the future.
      ELSEIF(ICLASS.EQ.16) THEN
        RLO=PS
        IF(ICOMBI.EQ.0.OR.ICOMBI.EQ.1) THEN
          ANUM=0D0
        ELSEIF(ICOMBI.EQ.2) THEN
          ANUM=(2D0-X1-X2)**2
        ELSEIF(ICOMBI.EQ.3) THEN
          ANUM=ALPCOR*(2D0-X1-X2)**2
        ELSE
          ANUM=0.5D0*(2D0-X1-X2)**2
        ENDIF
        RFO=PS*2D0*((X1+X2-1D0+ANUM-R1**2-R2**2)/
     &       ((1D0+R1**2-R2**2-X1)*(1D0+R2**2-R1**2-X2))-
     &       R1**2/(1D0+R2**2-R1**2-X2)**2-
     &       R2**2/(1D0+R1**2-R2**2-X1)**2)
        RFO=9D0*RFO/4D0
        ICOMBI=0
      ENDIF
 
C...Find relevant LO and FO expression.
      IF(ICOMBI.EQ.0) THEN
      ELSEIF(ICOMBI.EQ.1.AND.ISSET1.EQ.1) THEN
        RLO=RLO1
        RFO=RFO1
      ELSEIF(ICOMBI.EQ.2.AND.ISSET2.EQ.1) THEN
        RLO=RLO2
        RFO=RFO2
      ELSEIF(ICOMBI.EQ.3.AND.ISSET1.EQ.1.AND.ISSET2.EQ.1) THEN
        RLO=ALPCOR*RLO1+(1D0-ALPCOR)*RLO2
        RFO=ALPCOR*RFO1+(1D0-ALPCOR)*RFO2
      ELSEIF(ISSET4.EQ.1) THEN
        RLO=RLO4
        RFO=RFO4
      ELSEIF(ICOMBI.EQ.4.AND.ISSET1.EQ.1.AND.ISSET2.EQ.1) THEN
        RLO=0.5D0*(RLO1+RLO2)
        RFO=0.5D0*(RFO1+RFO2)
      ELSEIF(ISSET1.EQ.1) THEN
        RLO=RLO1
        RFO=RFO1
      ELSE
        CALL PYERRM(16,'(PYMAEL:) not implemented ME code')
        RLO=1D0
        RFO=0D0
      ENDIF
 
C...Output.
      PYMAEL=RFO/RLO
 
      RETURN
      END
