#include "uostr.h"

#if defined(__STDC__)
#  include <stdarg.h>
#  define VA_START(args, lastarg) va_start(args, lastarg)
#else
#  include <varargs.h>
#  define VA_START(args, lastarg) va_start(args)
#endif

uostr_t *
#if defined(__STDC__) && __STDC__
uostr_dup_cstrmulti(uostr_t *u,...)
#else
uostr_dup_cstrmulti (u,va_alist)
	uostr_t * u;
	va_dcl
#endif
{
	va_list args;
	const char *arg;
	if (u->data) u->len=0;
	VA_START (args, u);
	while ((arg = va_arg (args, const char *)) != 0) {
		if (!uostr_add_mem(u,arg,strlen(arg))) return 0;
	}
	return u;
}
uostr_t *
#if defined(__STDC__) && __STDC__
uostr_xdup_cstrmulti(uostr_t *u,...)
#else
uostr_xdup_cstrmulti (u,va_alist)
	uostr_t * u;
	va_dcl
#endif
{
	va_list args;
	const char *arg;
	if (u->data) u->len=0;
	VA_START (args, u);
	while ((arg = va_arg (args, const char *)) != 0)
		uostr_xadd_mem(u,arg,strlen(arg));
	return u;
}

uostr_t *
#if defined(__STDC__) && __STDC__
uostr_add_cstrmulti (uostr_t * u,...)
#else
uostr_add_cstrmulti (u,va_alist)
	uostr_t * u;
	va_dcl
#endif
{
	va_list args;
	const char *arg;
	VA_START (args, u);
	while ((arg = va_arg (args, const char *)) != 0) {
		if (!uostr_add_mem (u, arg, strlen (arg)))
			return 0;
	}
	return u;
}

uostr_t *
#if defined(__STDC__) && __STDC__
uostr_xadd_cstrmulti (uostr_t * u,...)
#else
uostr_xadd_cstrmulti (u,va_alist)
	uostr_t * u;
	va_dcl
#endif
{
	va_list args;
	const char *arg;
	VA_START (args, u);
	while ((arg = va_arg (args, const char *)) != 0)
		 uostr_xadd_mem (u, arg, strlen (arg));
	return u;
}


