# Release Notes - v2.8.35

**Date**: 2026-02-02

## 📝 Executive Summary

```text
2.8.35 2026-02-02

- feat: modernize version check using `HTTP::Tiny` with robust fallback to `curl`/`wget` (PR #18 and #17).
- feat: integrate `perltidy` in `release-preflight` workflow and enforce script formatting (issue #19).
- fix: resolve inaccurate `innodb_log_file_size` recommendations caused by integer rounding (issue #770).
- fix: ensure percentage returns 100.00% instead of 0% on idle or fresh servers, preventing unwarranted `innodb_log_buffer_size` recommendations (issue #783).
- test: add dedicated unit test `tests/test_version_regex.t` for version extraction verification.
- test: add regression test `tests/issue_770.t` to verify `innodb_log_file_size` recommendation precision.
- test: add regression test `tests/issue_783.t` to verify `innodb_log_buffer_size` recommendation on idle servers.
- docs: replace generic `SECURITY.md` template with project-specific policy and contact info (Issue #771, credit @bfontaine).
- style: run `perltidy` on `mysqltuner.pl` to ensure code consistency.
# MySQLTuner Changelog
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 12 | 0 | 🛡️ |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 2 | 0 | 🛡️ |
| Information Points | 10 | 0 | 🛡️ |

## 🛠️ Internal Commit History

- feat: release 2.8.35 (including all missing files) (7f2f57a)
- style: run perltidy on mysqltuner.pl (7516f0b)
- docs: include Bug #783 fix in Changelog and v2.8.35 release notes (28f7c65)
- fix(core): ensure percentage returns 100.00% instead of 0% on idle servers Fixes #783 (3ad0b78)
- docs: update Changelog and regenerate v2.8.35 release notes (5de44d5)
- fix(innodb): fix incorrect innodb_log_file_size recommendation due to rounding Fixes #770 (51ea6ef)
- chore: bump version to 2.8.35 (b717166)

## ⚙️ Technical Evolutions

*Internal logic hardening (no interface or diagnostic changes).*

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
