# Release Notes - v2.8.38

**Date**: 2026-02-14

## 📝 Executive Summary

```text
2.8.38 2026-02-14

- chore: bump version to 2.8.38.
- feat: implement authentication plugin security checks to detect insecure or deprecated plugins like mysql_native_password and sha256_password.
- feat: add MySQL 9.x readiness diagnostics for eliminated authentication methods.
- feat: update MariaDB recommendations to suggest ed25519 and unix_socket for enhanced security.
- feat: detect removed InnoDB variables in MariaDB and MySQL and provide actionable recommendations.
- feat: implement native parsing for /proc/cpuinfo, /proc/meminfo, /proc/sys/vm/swappiness and /etc/resolv.conf.
- feat: add support for --login-path in CLI metadata and mysql_setup for enhanced authentication flexibility.
- feat: add automatic detection of systemd journal and syslog fallbacks for MariaDB/MySQL logs (Issue #440).
- fix: prevent creation of unauthorized directory "0" when --dumpdir is not explicitly set or set to 0 (Issue #20).
- fix: robust, version-agnostic detection of password column in mysql.user via schema inspection (Issue #22).
- fix: refactor mysql_setup to correctly handle --defaults-file and --defaults-extra-file with credentials (Issue #605).
- fix: resolve MariaDB socket authentication regression and restore automatic credential discovery (Issue #875).
- fix: remediate Prototype Pollution vulnerability in lodash (CVE-2021-23341) by forcing update to 4.17.23.
- test: add integrated test suite for authentication plugin auditing (tests/auth_plugin_checks.t).
- test: add regression test for MariaDB and MySQL removed InnoDB variables (tests/removed_innodb_vars.t).
- test: add reproduction test for authentication discovery chain (tests/issue_875_regression.t).
- test: add comprehensive test suite for password column detection (tests/repro_issue_22.t).
- test: add reproduction test for credentials and defaults files handling (tests/repro_issue_605.t).
- test: add verification suite for syslog and systemd journal detection (tests/syslog_journal_detection.t).
- refactor: replace massive system calls (awk, grep, uname, getconf, sysctl) with native Core Perl functions for Linux.
- refactor: optimize CPU core count, logical CPU detection, and OS memory setup for local environments.
- refactor: use POSIX::uname and POSIX::sysconf for standardized system and architecture reporting.
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 12 | 0 | 🛡️ |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 2 | 0 | 🛡️ |
| Information Points | 10 | 0 | 🛡️ |

## 🛠️ Internal Commit History

- feat(release): release 2.8.38 (e5400ec)
- style: tidy mysqltuner.pl (efa6494)
- docs: generate USAGE.md (ae7f08e)
- docs: generate FEATURES.md (691786a)
- feat(release): release 2.8.37 (cd403db)
- Merge pull request #28 from lewart3/each (747ac86)
- Make Storage Engine Statistics output deterministic (00b3473)

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--login-path`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
