#include "UserTestTraits.hpp"
#include "t051lexer.hpp"

#include <sys/types.h>

#include <iostream>
#include <sstream>
#include <fstream>

using namespace Antlr3Test;
using namespace std;

static t051lexer* lxr;

static string slurp(string const& fileName);
static void parseFile(const char* fName);

int main (int argc, char *argv[])
{
	if (argc < 2 || argv[1] == NULL)
	{
		parseFile("./t051.input"); // Note in VS2005 debug, working directory must be configured
	}
	else
	{
		for (int i = 1; i < argc; i++)
		{
			parseFile(argv[i]);
		}
	}

	printf("finished parsing OK\n");	// Finnish parking is pretty good - I think it is all the snow

	return 0;
}

void parseFile(const char* fName)
{
	t051lexerTraits::InputStreamType* input;
	t051lexerTraits::TokenStreamType* tstream;
	
	string data = slurp(fName);

	input	= new t051lexerTraits::InputStreamType((const ANTLR_UINT8 *)data.c_str(),
						       ANTLR_ENC_8BIT,
						       data.length(), //strlen(data.c_str()),
						       (ANTLR_UINT8*)fName);

	input->setUcaseLA(true);

	// Our input stream is now open and all set to go, so we can create a new instance of our
	// lexer and set the lexer input to our input stream:
	//  (file | memory | ?) --> inputstream -> lexer --> tokenstream --> parser ( --> treeparser )?
	//
	if (lxr == NULL)
	{
		lxr = new t051lexer(input);	    // javaLexerNew is generated by ANTLR
	}
	else
	{
		lxr->setCharStream(input);
	}

	tstream = new t051lexerTraits::TokenStreamType(ANTLR_SIZE_HINT, lxr->get_tokSource());

	putc('L', stdout); fflush(stdout);
	{
		ANTLR_INT32 T = 0;
		while	(T != t051lexer::EOF_TOKEN)
		{
			T = tstream->_LA(1);
			t051lexerTraits::CommonTokenType const* token = tstream->_LT(1);
			  
			printf("%d\t\"%s\"\n",
			       T,
			       tstream->_LT(1)->getText().c_str()
				);
			tstream->consume();
		}
	}

	tstream->_LT(1);	// Don't do this mormally, just causes lexer to run for timings here

	delete tstream; 
	delete lxr; lxr = NULL;
	delete input; 
}

string slurp(string const& fileName)
{
	ifstream ifs(fileName.c_str(), ios::in | ios::binary | ios::ate);
	ifstream::pos_type fileSize = ifs.tellg();
	ifs.seekg(0, ios::beg);

	stringstream sstr;
	sstr << ifs.rdbuf();
	return sstr.str();
}
