// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_GLAREA_H
#define _GTKMM_GLAREA_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2015 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gtkmm/widget.h>


#include <gdkmm/glcontext.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkGLArea = struct _GtkGLArea;
using GtkGLAreaClass = struct _GtkGLAreaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API GLArea_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A widget used for drawing with [OpenGL](https://en.wikipedia.org/wiki/OpenGL).
 *
 * %Gtk::GLArea sets up its own Gdk::GLContext, and creates a custom
 * GL framebuffer that the widget will do GL rendering onto. It also ensures
 * that this framebuffer is the default GL rendering target when rendering.
 * The completed rendering is integrated into the larger GTK scene graph as
 * a texture.
 *
 * In order to draw, you have to connect to signal_render().
 *
 * The %Gtk::GLArea widget ensures that the Gdk::GLContext is associated with
 * the widget's drawing area, and it is kept updated when the size and
 * position of the drawing area changes.
 *
 * ## Drawing with Gtk::GLArea
 *
 * The simplest way to draw using OpenGL commands in a %Gtk::GLArea is to
 * create a widget instance and connect to signal_render().
 *
 * Your `my_render_handler()` signal handler will be called when the %Gtk::GLArea is ready
 * for you to draw its content.
 *
 * The initial contents of the framebuffer are transparent.
 *
 * @code
 * bool my_render_handler(const Glib::RefPtr<Gdk::GLContext>& context)
 * {
 *   // Inside this function it's safe to use GL; the given
 *   // Gdk::GLContext has been made current to the drawable
 *   // surface used by the Gtk::GLArea and the viewport has
 *   // already been set to be the size of the allocation.
 *
 *   // We can start by clearing the buffer.
 *   glClearColor(0, 0, 0, 0);
 *   glClear(GL_COLOR_BUFFER_BIT);
 *
 *   // Draw your object.
 *   // draw_an_object();
 *
 *   // We completed our drawing; the draw commands will be
 *   // flushed at the end of the signal emission chain, and
 *   // the buffers will be drawn on the window.
 *   return true;
 * }
 * @endcode
 *
 * If you need to initialize OpenGL state, e.g. buffer objects or
 * shaders, you should use Gtk::Widget::signal_realize();
 * you can use Gtk::Widget::signal_unrealize() to clean up.
 * Since the Gdk::GLContext creation and initialization may fail, you
 * will need to check for errors, using has_error() and/or throw_if_error().
 *
 * An example of how to safely initialize the GL state is:
 *
 * @code
 * void my_realize_handler()
 * {
 *   // We need to make the context current if we want to call GL API.
 *   m_GLArea.make_current();
 *
 *   try
 *   {
 *     // If there were errors during the initialization or
 *     // when trying to make the context current, this
 *     // function will throw.
 *     m_GLArea.throw_if_error();
 *
 *     init_buffers();
 *     init_shaders();
 *   }
 *   catch (const Gdk::GLError& gle)
 *   {
 *     std::cerr << "An error occured making the context current during realize:" << std::endl;
 *     std::cerr << gle.domain() << "-" << gle.code() << "-" << gle.what() << std::endl;
 *   }
 * }
 * @endcode
 *
 * If you need to change the options for creating the Gdk::GLContext,
 * you should use signal_create_context().
 *
 * A demo program shows the use of %Gtk::GLArea in more detail.
 *
 * @newin{3,18}
 * @ingroup Widgets
 */

class GTKMM_API GLArea : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef GLArea CppObjectType;
  typedef GLArea_Class CppClassType;
  typedef GtkGLArea BaseObjectType;
  typedef GtkGLAreaClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  GLArea(GLArea&& src) noexcept;
  GLArea& operator=(GLArea&& src) noexcept;

  // noncopyable
  GLArea(const GLArea&) = delete;
  GLArea& operator=(const GLArea&) = delete;

  ~GLArea() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend GTKMM_API class GLArea_Class;
  static CppClassType glarea_class_;

protected:
  explicit GLArea(const Glib::ConstructParams& construct_params);
  explicit GLArea(GtkGLArea* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkGLArea*       gobj()       { return reinterpret_cast<GtkGLArea*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkGLArea* gobj() const { return reinterpret_cast<GtkGLArea*>(gobject_); }

private:

public:

  GLArea();

  
  /** Retrieves the `Gdk::GLContext` used by @a area.
   * 
   * @newin{3,18}
   * 
   * @return The `Gdk::GLContext`.
   */
  Glib::RefPtr<Gdk::GLContext> get_context();
  
  /** Retrieves the `Gdk::GLContext` used by @a area.
   * 
   * @newin{3,18}
   * 
   * @return The `Gdk::GLContext`.
   */
  Glib::RefPtr<const Gdk::GLContext> get_context() const;
  
  /** Ensures that the `Gdk::GLContext` used by @a area is associated with
   * the `Gtk::GLArea`.
   * 
   * This function is automatically called before emitting the
   * signal_render() signal, and doesn't normally need
   * to be called by application code.
   * 
   * @newin{3,18}
   */
  void make_current();
  
  /** Marks the currently rendered data (if any) as invalid, and queues
   * a redraw of the widget.
   * 
   * This ensures that the signal_render() signal
   * is emitted during the draw.
   * 
   * This is only needed when set_auto_render() has
   * been called with a <tt>false</tt> value. The default behaviour is to
   * emit signal_render() on each draw.
   * 
   * @newin{3,18}
   */
  void queue_render();
  
  /** Binds buffers to the framebuffer.
   * 
   * Ensures that the @a area framebuffer object is made the current draw
   * and read target, and that all the required buffers for the @a area
   * are created and bound to the framebuffer.
   * 
   * This function is automatically called before emitting the
   * signal_render() signal, and doesn't normally need to be
   * called by application code.
   * 
   * @newin{3,18}
   */
  void attach_buffers();
  /** Check if any error is currently set on this <i>area</i>.
   *
   * The error may be obtained by using throw_if_error() and
   * set using set_error().
   *
   * @newin{3,18}
   *
   * @return true if an error is currently set.
   */
  bool has_error() const;

  
  /** Will throw the correct Glib::Error subclass if
   * any is currently set on this <i>area</i>.
   *
   * @newin{3,18}
   *
   * @throw Throws any currently set error (e.g. Gdk::GLError).
   */
  void throw_if_error() const;

 
  /** Sets an error on the <i>area</i> which will be shown
   * instead of GL rendering.
   *
   * This is useful in the signal_create_context() handler
   * if GL context creation fails.
   *
   * @newin{3,18}
   *
   * @param error The error to set on the <i>area</i>.
   */
  void set_error(const Glib::Error& error);
  /** Clears any previous set error on this <i>area</i> made with set_error().
   *
   * @newin{3,18}
   */
  void unset_error();
  
  /** Returns whether the area has a depth buffer.
   * 
   * @newin{3,18}
   * 
   * @return <tt>true</tt> if the @a area has a depth buffer, <tt>false</tt> otherwise.
   */
  bool get_has_depth_buffer() const;
  
  /** Sets whether the `Gtk::GLArea` should use a depth buffer.
   * 
   * If @a has_depth_buffer is <tt>true</tt> the widget will allocate and
   * enable a depth buffer for the target framebuffer. Otherwise
   * there will be none.
   * 
   * @newin{3,18}
   * 
   * @param has_depth_buffer <tt>true</tt> to add a depth buffer.
   */
  void set_has_depth_buffer(bool has_depth_buffer =  true);
  
  /** Returns whether the area has a stencil buffer.
   * 
   * @newin{3,18}
   * 
   * @return <tt>true</tt> if the @a area has a stencil buffer, <tt>false</tt> otherwise.
   */
  bool get_has_stencil_buffer() const;
  
  /** Sets whether the `Gtk::GLArea` should use a stencil buffer.
   * 
   * If @a has_stencil_buffer is <tt>true</tt> the widget will allocate and
   * enable a stencil buffer for the target framebuffer. Otherwise
   * there will be none.
   * 
   * @newin{3,18}
   * 
   * @param has_stencil_buffer <tt>true</tt> to add a stencil buffer.
   */
  void set_has_stencil_buffer(bool has_stencil_buffer =  true);
  
  /** Returns whether the area is in auto render mode or not.
   * 
   * @newin{3,18}
   * 
   * @return <tt>true</tt> if the @a area is auto rendering, <tt>false</tt> otherwise.
   */
  bool get_auto_render() const;
  
  /** Sets whether the `Gtk::GLArea` is in auto render mode.
   * 
   * If @a auto_render is <tt>true</tt> the signal_render() signal will
   * be emitted every time the widget draws. This is the default and is
   * useful if drawing the widget is faster.
   * 
   * If @a auto_render is <tt>false</tt> the data from previous rendering is kept
   * around and will be used for drawing the widget the next time,
   * unless the window is resized. In order to force a rendering
   * queue_render() must be called. This mode is
   * useful when the scene changes seldom, but takes a long time to redraw.
   * 
   * @newin{3,18}
   * 
   * @param auto_render A boolean.
   */
  void set_auto_render(bool auto_render =  true);
  
  /** Retrieves the required version of OpenGL.
   * 
   * See set_required_version().
   * 
   * @newin{3,18}
   * 
   * @param major Return location for the required major version.
   * @param minor Return location for the required minor version.
   */
  void get_required_version(int& major, int& minor) const;
  
  /** Sets the required version of OpenGL to be used when creating
   * the context for the widget.
   * 
   * This function must be called before the area has been realized.
   * 
   * @newin{3,18}
   * 
   * @param major The major version.
   * @param minor The minor version.
   */
  void set_required_version(int major, int minor);
     

  /** Sets the allowed APIs to create a context with.
   * 
   * You should check property_api() before drawing
   * with either API.
   * 
   * By default, all APIs are allowed.
   * 
   * @newin{4,12}
   * 
   * @param apis The allowed APIs.
   */
  void set_allowed_apis(Gdk::GLApi apis);
  
  /** Gets the allowed APIs.
   * 
   * See set_allowed_apis().
   * 
   * @newin{4,12}
   * 
   * @return The allowed APIs.
   */
  Gdk::GLApi get_allowed_apis() const;
  
  /** Gets the API that is currently in use.
   * 
   * If the GL area has not been realized yet, 0 is returned.
   * 
   * @newin{4,12}
   * 
   * @return The currently used API.
   */
  Gdk::GLApi get_api() const;
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns whether the `Gtk::GLArea` should use OpenGL ES.
   * 
   * See set_use_es().
   * 
   * Deprecated: 4.12: Use get_api()
   * 
   * @deprecated Use get_api() instead.
   * 
   * @return <tt>true</tt> if the `Gtk::GLArea` should create an OpenGL ES context
   * and <tt>false</tt> otherwise.
   */
  bool get_use_es() const;
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets whether the @a area should create an OpenGL or an OpenGL ES context.
   * 
   * You should check the capabilities of the `Gdk::GLContext` before drawing
   * with either API.
   * 
   * Deprecated: 4.12: Use set_allowed_apis()
   * 
   * @deprecated Use set_allowed_apis() instead.
   * 
   * @param use_es Whether to use OpenGL or OpenGL ES.
   */
  void set_use_es(bool use_es =  true);
#endif // GTKMM_DISABLE_DEPRECATED


  /** If set to <tt>true</tt> the signal_render() signal will be emitted every time
   * the widget draws.
   * 
   * This is the default and is useful if drawing the widget is faster.
   * 
   * If set to <tt>false</tt> the data from previous rendering is kept around and will
   * be used for drawing the widget the next time, unless the window is resized.
   * In order to force a rendering Gtk::GLArea::queue_render() must be called.
   * This mode is useful when the scene changes seldom, but takes a long time
   * to redraw.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_auto_render() ;

/** If set to <tt>true</tt> the signal_render() signal will be emitted every time
   * the widget draws.
   * 
   * This is the default and is useful if drawing the widget is faster.
   * 
   * If set to <tt>false</tt> the data from previous rendering is kept around and will
   * be used for drawing the widget the next time, unless the window is resized.
   * In order to force a rendering Gtk::GLArea::queue_render() must be called.
   * This mode is useful when the scene changes seldom, but takes a long time
   * to redraw.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_auto_render() const;

  /** The `Gdk::GLContext` used by the `Gtk::GLArea` widget.
   * 
   * The `Gtk::GLArea` widget is responsible for creating the `Gdk::GLContext`
   * instance. If you need to render with other kinds of buffers (stencil,
   * depth, etc), use render buffers.
   * 
   * @newin{3,18}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::GLContext> > property_context() const;


  /** If set to <tt>true</tt> the widget will allocate and enable a depth buffer for the
   * target framebuffer.
   * 
   * Setting this property will enable GL's depth testing as a side effect. If
   * you don't need depth testing, you should call `glDisable(GL_DEPTH_TEST)`
   * in your `GtkGLArea::render` handler.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_depth_buffer() ;

/** If set to <tt>true</tt> the widget will allocate and enable a depth buffer for the
   * target framebuffer.
   * 
   * Setting this property will enable GL's depth testing as a side effect. If
   * you don't need depth testing, you should call `glDisable(GL_DEPTH_TEST)`
   * in your `GtkGLArea::render` handler.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_depth_buffer() const;

  /** If set to <tt>true</tt> the widget will allocate and enable a stencil buffer for the
   * target framebuffer.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_stencil_buffer() ;

/** If set to <tt>true</tt> the widget will allocate and enable a stencil buffer for the
   * target framebuffer.
   * 
   * @newin{3,18}
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_stencil_buffer() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** If set to <tt>true</tt> the widget will try to create a `Gdk::GLContext` using
   * OpenGL ES instead of OpenGL.
   * 
   * Deprecated: 4.12: Use property_allowed_apis()
   * 
   * @deprecated Use property_allowed_apis() instead.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_es() ;

/** If set to <tt>true</tt> the widget will try to create a `Gdk::GLContext` using
   * OpenGL ES instead of OpenGL.
   * 
   * Deprecated: 4.12: Use property_allowed_apis()
   * 
   * @deprecated Use property_allowed_apis() instead.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_es() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** The allowed APIs.
   * 
   * @newin{4,12}
   *
   * Default value: Gdk::GLApi::GL | Gdk::GLApi::GLES
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::GLApi > property_allowed_apis() ;

/** The allowed APIs.
   * 
   * @newin{4,12}
   *
   * Default value: Gdk::GLApi::GL | Gdk::GLApi::GLES
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::GLApi > property_allowed_apis() const;

  /** The API currently in use.
   * 
   * @newin{4,12}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::GLApi > property_api() const;


  /**
   * @par Slot Prototype:
   * <tt>Glib::RefPtr<Gdk::GLContext> on_my_%create_context()</tt>
   *
   * Flags: Run Last
   *
   * Emitted when the widget is being realized.
   * 
   * This allows you to override how the GL context is created.
   * This is useful when you want to reuse an existing GL context,
   * or if you want to try creating different kinds of GL options.
   * 
   * If context creation fails then the signal handler can use
   * Gtk::GLArea::set_error() to register a more detailed error
   * of how the construction failed.
   * 
   * @newin{3,18}
   * 
   * @return A newly created `Gdk::GLContext`;
   * the `Gtk::GLArea` widget will take ownership of the returned value.
   */

  Glib::SignalProxy<Glib::RefPtr<Gdk::GLContext>()> signal_create_context();

 
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%render(const Glib::RefPtr<Gdk::GLContext>& context)</tt>
   *
   * Flags: Run Last
   *
   * Emitted every time the contents of the `Gtk::GLArea` should be redrawn.
   * 
   * The @a context is bound to the @a area prior to emitting this function,
   * and the buffers are painted to the window once the emission terminates.
   * 
   * @newin{3,18}
   * 
   * @param context The `Gdk::GLContext` used by @a area.
   * @return <tt>true</tt> to stop other handlers from being invoked for the event.
   * <tt>false</tt> to propagate the event further.
   */

  Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::GLContext>&)> signal_render();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%resize(int width, int height)</tt>
   *
   * Flags: Run Last
   *
   * Emitted once when the widget is realized, and then each time the widget
   * is changed while realized.
   * 
   * This is useful in order to keep GL state up to date with the widget size,
   * like for instance camera properties which may depend on the width/height
   * ratio.
   * 
   * The GL context for the area is guaranteed to be current when this signal
   * is emitted.
   * 
   * The default handler sets up the GL viewport.
   * 
   * @newin{3,18}
   * 
   * @param width The width of the viewport.
   * @param height The height of the viewport.
   */

  Glib::SignalProxy<void(int, int)> signal_resize();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_create_context().
  virtual Glib::RefPtr<Gdk::GLContext> on_create_context();
  /// This is a default handler for the signal signal_render().
  virtual bool on_render(const Glib::RefPtr<Gdk::GLContext>& context);
  /// This is a default handler for the signal signal_resize().
  virtual void on_resize(int width, int height);


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::GLArea
   */
  GTKMM_API
  Gtk::GLArea* wrap(GtkGLArea* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_GLAREA_H */

