/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.YList;
import com.intellij.openapi.graph.geom.YDimension;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.MouseInputEditor;
import com.intellij.openapi.graph.view.MouseInputEditorProvider;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.SizeConstraintProvider;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;

public interface GenericNodeRealizer
extends NodeRealizer,
MouseInputEditorProvider {
    public void setStyleProperty(String var1, Object var2);

    public Object getStyleProperty(String var1);

    public Set getStyleProperties();

    public void removeStyleProperty(String var1);

    public String getConfiguration();

    public void setConfiguration(String var1);

    @Override
    public NodeRealizer createCopy(NodeRealizer var1);

    public void paintNode(Graphics2D var1);

    @Override
    public YList getPortCandidates(double var1);

    @Override
    public byte getLayer();

    @Override
    public void setLayer(byte var1);

    @Override
    public void paint(Graphics2D var1);

    @Override
    public void paintSloppy(Graphics2D var1);

    @Override
    public boolean contains(double var1, double var3);

    @Override
    public byte hotSpotHit(double var1, double var3);

    @Override
    public boolean findIntersection(double var1, double var3, double var5, double var7, Point2D var9);

    @Override
    public void paintHotSpots(Graphics2D var1);

    @Override
    public void calcUnionRect(Rectangle2D var1);

    @Override
    public NodeLabel createNodeLabel();

    @Override
    public void read(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public void write(ObjectOutputStream var1) throws IOException;

    public Object getUserData();

    public void setUserData(Object var1);

    @Override
    public MouseInputEditorProvider getMouseInputEditorProvider();

    @Override
    public MouseInputEditor findMouseInputEditor(Graph2DView var1, double var2, double var4, HitInfo var6);

    @Override
    public SizeConstraintProvider getSizeConstraintProvider();

    public static class Statics {
        public static Factory getFactory() {
            return GraphManager.getGraphManager()._GenericNodeRealizer_getFactory();
        }
    }

    public static interface ContainsTest {
        public boolean contains(NodeRealizer var1, double var2, double var4);
    }

    public static interface IntersectionTest {
        public boolean findIntersection(NodeRealizer var1, double var2, double var4, double var6, double var8, Point2D var10);
    }

    public static interface Painter {
        public void paint(NodeRealizer var1, Graphics2D var2);

        public void paintSloppy(NodeRealizer var1, Graphics2D var2);
    }

    public static interface GenericSizeConstraintProvider {
        public YDimension getMinimumSize(NodeRealizer var1);

        public YDimension getMaximumSize(NodeRealizer var1);
    }

    public static interface Initializer {
        public void initialize(NodeRealizer var1);
    }

    public static interface GenericMouseInputEditorProvider {
        public MouseInputEditor findMouseInputEditor(NodeRealizer var1, Graph2DView var2, double var3, double var5, HitInfo var7);
    }

    public static interface HotSpotPainter {
        public void paintHotSpots(NodeRealizer var1, Graphics2D var2);
    }

    public static interface UnionRectCalculator {
        public void calcUnionRect(NodeRealizer var1, Rectangle2D var2);
    }

    public static interface BoundsChangedHandler {
        public void boundsChanged(NodeRealizer var1);
    }

    public static interface LabelBoundsChangedHandler {
        public void labelBoundsChanged(NodeRealizer var1, NodeLabel var2);
    }

    public static interface PortCandidateListProvider {
        public YList getPortCandidates(NodeRealizer var1, double var2);
    }

    public static interface HotSpotHitTest {
        public byte hotSpotHit(NodeRealizer var1, double var2, double var4);
    }

    public static interface SelectionChangeHandler {
        public void selectionChanged(NodeRealizer var1);
    }

    public static interface UserDataHandler {
        public void storeUserData(NodeRealizer var1, Object var2, ObjectOutputStream var3) throws IOException;

        public Object readUserData(NodeRealizer var1, ObjectInputStream var2) throws IOException;

        public Object copyUserData(NodeRealizer var1, Object var2, NodeRealizer var3);
    }

    public static interface LayerHandler {
        public byte getLayer(NodeRealizer var1);

        public void setLayer(NodeRealizer var1, byte var2);
    }

    public static interface LabelFactory {
        public NodeLabel createNodeLabel(NodeRealizer var1);
    }

    public static interface Factory {
        public Map createDefaultConfigurationMap();

        public void addConfiguration(String var1, Map var2);

        public Object getImplementation(String var1, Class var2);

        public void configure(GenericNodeRealizer var1, String var2);

        public Set getAvailableConfigurations();

        public void removeConfiguration(String var1);
    }
}

