/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesKt;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002+,B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J-\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010'J*\u0010(\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0*2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;Lcom/intellij/vcs/log/impl/VcsLogManager;)V", "isLogDisposing", "", "futureToolWindow", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/wm/ToolWindow;", "tabs", "", "", "getTabs", "()Ljava/util/Set;", "createTabs", "", "createTabs$intellij_platform_vcs_log_impl", "disposeTabs", "disposeTabs$intellij_platform_vcs_log_impl", "toolWindowShown", "toolWindow", "toolWindowShown$intellij_platform_vcs_log_impl", "openAnotherLogTab", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "location", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "openEditorLogTab", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "tabId", "focus", "(Ljava/lang/String;ZLcom/intellij/vcs/log/VcsLogFilterCollection;)[Lcom/intellij/openapi/fileEditor/FileEditor;", "openToolWindowLogTab", "getPersistentVcsLogUiFactory", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "PersistentVcsLogUiFactory", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n503#2,7:162\n503#2,7:169\n188#3,3:176\n1863#4,2:179\n1863#4,2:181\n*S KotlinDebug\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n*L\n45#1:162,7\n46#1:169,7\n48#1:176,3\n56#1:179,2\n64#1:181,2\n*E\n"})
public final class VcsLogTabsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogProjectTabsProperties uiProperties;
    @NotNull
    private final VcsLogManager logManager;
    private boolean isLogDisposing;
    @NotNull
    private final CompletableFuture<ToolWindow> futureToolWindow;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TabGroupId TAB_GROUP_ID;

    public VcsLogTabsManager(@NotNull Project project, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull VcsLogManager logManager2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        this.project = project;
        this.uiProperties = uiProperties;
        this.logManager = logManager2;
        this.futureToolWindow = new CompletableFuture();
    }

    @ApiStatus.Internal
    @NotNull
    public final Set<String> getTabs() {
        return this.uiProperties.getTabs().keySet();
    }

    public final void createTabs$intellij_platform_vcs_log_impl() {
        boolean bl;
        Set toolWindowTabs;
        Set editorTabs;
        block9: {
            Map<String, VcsLogTabLocation> savedTabs = this.uiProperties.getTabs();
            if (savedTabs.isEmpty()) {
                return;
            }
            Map<String, VcsLogTabLocation> $this$filterValues$iv = savedTabs;
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv.entrySet()) {
                VcsLogTabLocation vcsLogTabLocation = entry.getValue();
                boolean bl2 = false;
                if (!(vcsLogTabLocation == VcsLogTabLocation.EDITOR)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            editorTabs = ((Map)result$iv).keySet();
            Map<String, VcsLogTabLocation> $this$filterValues$iv2 = savedTabs;
            boolean $i$f$filterValues2 = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv2 = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv2.entrySet()) {
                VcsLogTabLocation it2 = entry.getValue();
                boolean bl3 = false;
                if (!(it2 == VcsLogTabLocation.TOOL_WINDOW)) continue;
                result$iv2.put(entry.getKey(), entry.getValue());
            }
            toolWindowTabs = ((Map)result$iv2).keySet();
            Map<String, VcsLogTabLocation> $this$any$iv = savedTabs;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, VcsLogTabLocation>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, VcsLogTabLocation> entry;
                    Map.Entry<String, VcsLogTabLocation> entry2 = entry = iterator.next();
                    boolean bl4 = false;
                    if (!(entry2.getValue() == VcsLogTabLocation.STANDALONE)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            LOG.warn("Reopening standalone tabs is not supported");
        }
        if (!((Collection)editorTabs).isEmpty()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> VcsLogTabsManager.createTabs$lambda$4(this, editorTabs));
        }
        if (!((Collection)toolWindowTabs).isEmpty()) {
            this.futureToolWindow.thenAccept(arg_0 -> VcsLogTabsManager.createTabs$lambda$7(arg_0 -> VcsLogTabsManager.createTabs$lambda$6(this, toolWindowTabs, arg_0), arg_0));
        }
        ToolWindowManager.Companion.getInstance(this.project).invokeLater(() -> VcsLogTabsManager.createTabs$lambda$9(this));
    }

    public final void disposeTabs$intellij_platform_vcs_log_impl() {
        this.isLogDisposing = true;
    }

    public final void toolWindowShown$intellij_platform_vcs_log_impl(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.futureToolWindow.complete(toolWindow);
    }

    @NotNull
    public final MainVcsLogUi openAnotherLogTab(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogTabLocation location) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        String tabId = VcsLogTabsUtil.INSTANCE.generateTabId(this.logManager);
        this.uiProperties.resetState(tabId);
        if (location == VcsLogTabLocation.EDITOR) {
            FileEditor[] editors = this.openEditorLogTab(tabId, true, filters);
            MainVcsLogUi mainVcsLogUi = VcsLogEditorUtil.findVcsLogUi(editors, MainVcsLogUi.class);
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            return mainVcsLogUi;
        }
        if (location == VcsLogTabLocation.TOOL_WINDOW) {
            ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindowOrThrow$intellij_platform_vcs_log_impl(this.project);
            this.futureToolWindow.complete(toolWindow);
            return this.openToolWindowLogTab(toolWindow, tabId, true, filters);
        }
        throw new UnsupportedOperationException("Only log in editor or tool window is supported");
    }

    private final FileEditor[] openEditorLogTab(String tabId, boolean focus, VcsLogFilterCollection filters) {
        VirtualFile file = VcsLogVirtualFileSystem.Holder.getInstance().createVcsLogFile(this.project, tabId, filters);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).openFile(file, focus, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        return fileEditorArray;
    }

    private final MainVcsLogUi openToolWindowLogTab(ToolWindow toolWindow, String tabId, boolean focus, VcsLogFilterCollection filters) {
        VcsLogManager.VcsLogUiFactory<MainVcsLogUi> factory = this.getPersistentVcsLogUiFactory(tabId, VcsLogTabLocation.TOOL_WINDOW, filters);
        MainVcsLogUi ui = VcsLogContentUtil.INSTANCE.openLogTab$intellij_platform_vcs_log_impl(this.logManager, factory, toolWindow, TAB_GROUP_ID, VcsLogTabsManager::openToolWindowLogTab$lambda$10, focus);
        Companion.onDisplayNameChange(ui, (Function0<Unit>)((Function0)() -> VcsLogTabsManager.openToolWindowLogTab$lambda$11(this, ui)));
        return ui;
    }

    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    public final VcsLogManager.VcsLogUiFactory<MainVcsLogUi> getPersistentVcsLogUiFactory(@NotNull String tabId, @NotNull VcsLogTabLocation location, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> vcsLogUiFactory = this.logManager.getMainLogUiFactory(tabId, filters);
        Intrinsics.checkNotNullExpressionValue(vcsLogUiFactory, (String)"getMainLogUiFactory(...)");
        return new PersistentVcsLogUiFactory(vcsLogUiFactory, location);
    }

    private static final Unit createTabs$lambda$4(VcsLogTabsManager this$0, Set $editorTabs) {
        if (this$0.logManager.isDisposed()) {
            return Unit.INSTANCE;
        }
        LOG.debug("Reopening editor tabs with ids: " + $editorTabs);
        Iterable $this$forEach$iv = $editorTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this$0.openEditorLogTab(it, false, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTabs$lambda$6(VcsLogTabsManager this$0, Set $toolWindowTabs, ToolWindow toolWindow) {
        if (!LOG.assertTrue(!this$0.logManager.isDisposed(), (Object)"Attempting to open tabs on disposed VcsLogManager")) {
            return Unit.INSTANCE;
        }
        LOG.debug("Reopening toolwindow tabs with ids: " + $toolWindowTabs);
        Iterable $this$forEach$iv = $toolWindowTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)toolWindow);
            this$0.openToolWindowLogTab(toolWindow, it, false, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createTabs$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createTabs$lambda$9(VcsLogTabsManager this$0) {
        if (this$0.logManager.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindow$intellij_platform_vcs_log_impl(this$0.project);
        if (toolWindow == null) {
            VcsLogTabsManager $this$createTabs_u24lambda_u249_u24lambda_u248 = this$0;
            boolean bl = false;
            LOG.error("Could not find tool window by id Version Control");
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2.isVisible()) {
            this$0.futureToolWindow.complete(toolWindow2);
        }
    }

    private static final String openToolWindowLogTab$lambda$10(MainVcsLogUi u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return VcsLogTabsUtil.INSTANCE.generateShortDisplayName(u);
    }

    private static final Unit openToolWindowLogTab$lambda$11(VcsLogTabsManager this$0, MainVcsLogUi $ui) {
        VcsLogContentUtil.updateLogUiName(this$0.project, $ui);
        return Unit.INSTANCE;
    }

    private static final String TAB_GROUP_ID$lambda$12() {
        return VcsLogBundle.message("vcs.log.tab.name", new Object[0]);
    }

    static {
        Logger logger = Logger.getInstance(VcsLogTabsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TAB_GROUP_ID = new TabGroupId("Log", VcsLogTabsManager::TAB_GROUP_ID$lambda$12, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TAB_GROUP_ID", "Lcom/intellij/ui/content/TabGroupId;", "getTAB_GROUP_ID", "()Lcom/intellij/ui/content/TabGroupId;", "onDisplayNameChange", "", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "block", "Lkotlin/Function0;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TabGroupId getTAB_GROUP_ID() {
            return TAB_GROUP_ID;
        }

        public final void onDisplayNameChange(@NotNull MainVcsLogUi $this$onDisplayNameChange, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$onDisplayNameChange, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this$onDisplayNameChange.getFilterUi().addFilterListener(() -> Companion.onDisplayNameChange$lambda$0(block));
            MainVcsLogUiProperties mainVcsLogUiProperties = $this$onDisplayNameChange.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUiProperties, (String)"getProperties(...)");
            VcsLogUiPropertiesKt.onPropertyChange(mainVcsLogUiProperties, $this$onDisplayNameChange, arg_0 -> Companion.onDisplayNameChange$lambda$1(block, arg_0));
        }

        private static final void onDisplayNameChange$lambda$0(Function0 $block) {
            $block.invoke();
        }

        private static final Unit onDisplayNameChange$lambda$1(Function0 $block, VcsLogUiProperties.VcsLogUiProperty it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (Intrinsics.areEqual((Object)it, MainVcsLogUiProperties.GRAPH_OPTIONS)) {
                $block.invoke();
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory;", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "factory", "logTabLocation", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "<init>", "(Lcom/intellij/vcs/log/impl/VcsLogTabsManager;Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;Lcom/intellij/vcs/log/impl/VcsLogTabLocation;)V", "createLogUi", "project", "Lcom/intellij/openapi/project/Project;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "intellij.platform.vcs.log.impl"})
    private final class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory;
        @NotNull
        private final VcsLogTabLocation logTabLocation;

        public PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory, VcsLogTabLocation logTabLocation) {
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)((Object)logTabLocation), (String)"logTabLocation");
            this.factory = factory;
            this.logTabLocation = logTabLocation;
        }

        @Override
        @NotNull
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            MainVcsLogUi ui = this.factory.createLogUi(project, logData);
            VcsLogProjectTabsProperties vcsLogProjectTabsProperties = VcsLogTabsManager.this.uiProperties;
            String string = ui.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            vcsLogProjectTabsProperties.addTab(string, this.logTabLocation);
            Disposer.register((Disposable)ui, () -> PersistentVcsLogUiFactory.createLogUi$lambda$0(VcsLogTabsManager.this, ui));
            Intrinsics.checkNotNull((Object)ui);
            return ui;
        }

        private static final void createLogUi$lambda$0(VcsLogTabsManager this$0, MainVcsLogUi $ui) {
            if (this$0.project.isDisposed() || this$0.isLogDisposing) {
                return;
            }
            VcsLogProjectTabsProperties vcsLogProjectTabsProperties = this$0.uiProperties;
            String string = $ui.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            vcsLogProjectTabsProperties.removeTab(string);
        }
    }
}

