/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u0012JL\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader;", "", "bytesPerChunk", "", "maxThreads", "<init>", "(II)V", "download", "", "url", "", "headers", "", "expectedSize", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "Lkotlin/Function1;", "Ljava/io/InputStream;", "submitRangeDownloads", "Ljava/util/ArrayList;", "Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "Lkotlin/collections/ArrayList;", "executor", "Ljava/util/concurrent/ExecutorService;", "Companion", "ChunkFuture", "CombiningInputStream", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nChunkedDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkedDownloader.kt\ncom/intellij/indexing/shared/util/ChunkedDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1863#2,2:144\n216#3,2:146\n1#4:148\n*S KotlinDebug\n*F\n+ 1 ChunkedDownloader.kt\ncom/intellij/indexing/shared/util/ChunkedDownloader\n*L\n49#1:144,2\n74#1:146,2\n*E\n"})
public final class ChunkedDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bytesPerChunk;
    private final int maxThreads;
    @NotNull
    private static final Logger LOG;

    public ChunkedDownloader(int bytesPerChunk, int maxThreads) {
        this.bytesPerChunk = bytesPerChunk;
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void download(@NotNull String url, @NotNull Map<String, String> headers, long expectedSize, @NotNull ProgressIndicator indicator, @NotNull Function1<? super InputStream, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        LOG.trace("Downloading " + url + " using " + this.maxThreads + " and a chunk size of " + this.bytesPerChunk);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Shared index chunk downloader", (Executor)ProcessIOExecutorService.INSTANCE, (int)this.maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        ExecutorService executor = executorService;
        ArrayList<ChunkFuture> chunkFutures = this.submitRangeDownloads(executor, url, expectedSize, headers, indicator);
        try {
            Closeable closeable = new CombiningInputStream(chunkFutures, indicator);
            Throwable throwable = null;
            try {
                Object it = (CombiningInputStream)closeable;
                boolean bl = false;
                handler.invoke(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            executor.shutdownNow();
            Iterable $this$forEach$iv = chunkFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkFuture it = (ChunkFuture)element$iv;
                boolean bl = false;
                FileUtil.delete((Path)it.getTmpFile());
            }
        }
    }

    private final ArrayList<ChunkFuture> submitRangeDownloads(ExecutorService executor, String url, long expectedSize, Map<String, String> headers, ProgressIndicator indicator) {
        int numOfChunks = (int)Math.ceil((double)expectedSize / (double)this.bytesPerChunk);
        ArrayList<ChunkFuture> chunkFutures = new ArrayList<ChunkFuture>();
        long l = this.bytesPerChunk;
        if (l <= 0L) {
            throw new IllegalArgumentException("Step must be positive, was: " + l + ".");
        }
        long l2 = 0L;
        long l3 = ProgressionUtilKt.getProgressionLastElement((long)0L, (long)expectedSize, (long)l);
        long l4 = l;
        int n = 0;
        if (l2 <= l3) {
            while (true) {
                int i = n++;
                long start = l2;
                long end = Math.min(start + (long)this.bytesPerChunk - 1L, expectedSize - 1L);
                String range = start + "-" + end;
                Path tmpFile = Files.createTempFile(StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), "part." + i, new FileAttribute[0]);
                Future<?> future = executor.submit(() -> ChunkedDownloader.submitRangeDownloads$lambda$7(i, numOfChunks, indicator, url, range, headers, tmpFile));
                Intrinsics.checkNotNull(future);
                Intrinsics.checkNotNull((Object)tmpFile);
                chunkFutures.add(new ChunkFuture(future, tmpFile));
                if (start == l3) break;
                l2 += l4;
            }
        }
        return chunkFutures;
    }

    private static final void submitRangeDownloads$lambda$7$lambda$3(Map $headers, URLConnection tuner) {
        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
        Map $this$forEach$iv = $headers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            tuner.addRequestProperty(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit submitRangeDownloads$lambda$7$lambda$6(ProgressIndicator $indicator, Path $tmpFile, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $indicator.checkCanceled();
        Intrinsics.checkNotNull((Object)$tmpFile);
        Closeable closeable = PathKt.outputStream$default((Path)$tmpFile, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = it.getInputStream();
            Throwable throwable2 = null;
            try {
                InputStream it2 = (InputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                ByteStreamsKt.copyTo$default((InputStream)it2, (OutputStream)os, (int)0, (int)2, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void submitRangeDownloads$lambda$7(int $i, int $numOfChunks, ProgressIndicator $indicator, String $url, String $range, Map $headers, Path $tmpFile) {
        LOG.trace("Downloading chunk " + $i + " of " + $numOfChunks);
        $indicator.checkCanceled();
        HttpRequests.requestWithRange((String)$url, (String)$range).productNameAsUserAgent().tuner(arg_0 -> ChunkedDownloader.submitRangeDownloads$lambda$7$lambda$3($headers, arg_0)).accept("application/octet-stream, application/xz, application/x-xz").throwStatusCodeException(true).connect(arg_0 -> ChunkedDownloader.submitRangeDownloads$lambda$7$lambda$6($indicator, $tmpFile, arg_0));
    }

    static {
        Logger logger = Logger.getInstance(ChunkedDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "", "future", "Ljava/util/concurrent/Future;", "tmpFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/concurrent/Future;Ljava/nio/file/Path;)V", "getFuture", "()Ljava/util/concurrent/Future;", "getTmpFile", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class ChunkFuture {
        @NotNull
        private final Future<?> future;
        @NotNull
        private final Path tmpFile;

        public ChunkFuture(@NotNull Future<?> future, @NotNull Path tmpFile) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
            this.future = future;
            this.tmpFile = tmpFile;
        }

        @NotNull
        public final Future<?> getFuture() {
            return this.future;
        }

        @NotNull
        public final Path getTmpFile() {
            return this.tmpFile;
        }

        @NotNull
        public final Future<?> component1() {
            return this.future;
        }

        @NotNull
        public final Path component2() {
            return this.tmpFile;
        }

        @NotNull
        public final ChunkFuture copy(@NotNull Future<?> future, @NotNull Path tmpFile) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
            return new ChunkFuture(future, tmpFile);
        }

        public static /* synthetic */ ChunkFuture copy$default(ChunkFuture chunkFuture, Future future, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                future = chunkFuture.future;
            }
            if ((n & 2) != 0) {
                path = chunkFuture.tmpFile;
            }
            return chunkFuture.copy(future, path);
        }

        @NotNull
        public String toString() {
            return "ChunkFuture(future=" + this.future + ", tmpFile=" + this.tmpFile + ")";
        }

        public int hashCode() {
            int result = this.future.hashCode();
            result = result * 31 + ((Object)this.tmpFile).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChunkFuture)) {
                return false;
            }
            ChunkFuture chunkFuture = (ChunkFuture)other;
            if (!Intrinsics.areEqual(this.future, chunkFuture.future)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tmpFile, (Object)chunkFuture.tmpFile);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0001H\u0002R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$CombiningInputStream;", "Ljava/io/InputStream;", "chunkFutures", "Ljava/util/ArrayList;", "Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "Lkotlin/collections/ArrayList;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Ljava/util/ArrayList;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getChunkFutures", "()Ljava/util/ArrayList;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "currentInputStream", "Lkotlin/Lazy;", "getCurrentInputStream", "()Lkotlin/Lazy;", "setCurrentInputStream", "(Lkotlin/Lazy;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "read", "b", "", "off", "len", "close", "", "getNextStream", "intellij.indexing.shared"})
    private static final class CombiningInputStream
    extends InputStream {
        @NotNull
        private final ArrayList<ChunkFuture> chunkFutures;
        @NotNull
        private final ProgressIndicator indicator;
        @NotNull
        private Lazy<? extends InputStream> currentInputStream;
        private int index;

        public CombiningInputStream(@NotNull ArrayList<ChunkFuture> chunkFutures, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter(chunkFutures, (String)"chunkFutures");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.chunkFutures = chunkFutures;
            this.indicator = indicator;
            this.currentInputStream = LazyKt.lazy(() -> CombiningInputStream.currentInputStream$lambda$0(this));
        }

        @NotNull
        public final ArrayList<ChunkFuture> getChunkFutures() {
            return this.chunkFutures;
        }

        @NotNull
        public final ProgressIndicator getIndicator() {
            return this.indicator;
        }

        @NotNull
        public final Lazy<InputStream> getCurrentInputStream() {
            return this.currentInputStream;
        }

        public final void setCurrentInputStream(@NotNull Lazy<? extends InputStream> lazy) {
            Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
            this.currentInputStream = lazy;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int read() {
            byte[] tmp = new byte[1];
            if (this.read(tmp, 0, 1) != 1) {
                return -1;
            }
            return tmp[0] & 0xFF;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.indicator.checkCanceled();
            int result = ((InputStream)this.currentInputStream.getValue()).read(b, off, len);
            if (result == -1) {
                if (this.chunkFutures.size() <= this.index) {
                    return result;
                }
                ((InputStream)this.currentInputStream.getValue()).close();
                this.currentInputStream = LazyKt.lazyOf((Object)this.getNextStream());
                return this.read(b, off, len);
            }
            return result;
        }

        @Override
        public void close() {
            ((InputStream)this.currentInputStream.getValue()).close();
        }

        private final InputStream getNextStream() {
            ProgressIndicatorUtils.awaitWithCheckCanceled(this.chunkFutures.get(this.index).getFuture(), (ProgressIndicator)this.indicator);
            int n = this.index;
            this.index = n + 1;
            File file = this.chunkFutures.get(n).getTmpFile().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Object object = file;
            object = new FileInputStream((File)object);
            n = 0x100000;
            return object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        }

        private static final InputStream currentInputStream$lambda$0(CombiningInputStream this$0) {
            return this$0.getNextStream();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

