/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPickManager;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VcsCherryPickAction
extends DumbAwareAction {
    public VcsCherryPickAction() {
        super(DvcsBundle.messagePointer("cherry.pick.action.text", new Object[0]), DvcsBundle.messagePointer("cherry.pick.action.description", new Object[0]), DvcsImplIcons.CherryPick);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            VcsCherryPickAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsCherryPickAction.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        VcsCherryPickManager.getInstance(project).cherryPick(selection);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsCherryPickAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        e.getPresentation().setVisible(true);
        Project project = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (selection == null || project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsCherryPickManager cherryPickManager = VcsCherryPickManager.getInstance(project);
        List<VcsCherryPicker> cherryPickers = VcsCherryPickAction.getActiveCherryPickersForProject(project);
        if (cherryPickers.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List commits = ContainerUtil.getFirstItems((List)selection.getCommits(), (int)1000);
        if (commits.isEmpty() || cherryPickManager.isCherryPickAlreadyStartedFor(commits)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Map<VirtualFile, List<Hash>> groupedByRoot = VcsCherryPickAction.groupByRoot(commits);
        VcsCherryPicker activeCherryPicker = VcsCherryPickAction.getActiveCherryPicker(cherryPickers, groupedByRoot.keySet());
        e.getPresentation().setEnabled(activeCherryPicker != null);
        e.getPresentation().setText(activeCherryPicker == null ? VcsCherryPickAction.concatActionNamesForAllAvailable(cherryPickers) : activeCherryPicker.getActionTitle());
        e.getPresentation().setDescription(activeCherryPicker != null ? "" : DvcsBundle.message("cherry.pick.action.description", new Object[0]));
    }

    @Nullable
    private static VcsCherryPicker getActiveCherryPicker(@NotNull List<? extends VcsCherryPicker> cherryPickers, @NotNull Collection<? extends VirtualFile> roots) {
        if (cherryPickers == null) {
            VcsCherryPickAction.$$$reportNull$$$0(3);
        }
        if (roots == null) {
            VcsCherryPickAction.$$$reportNull$$$0(4);
        }
        return (VcsCherryPicker)ContainerUtil.find(cherryPickers, picker -> picker.canHandleForRoots(roots));
    }

    @NotNull
    private static Map<VirtualFile, List<Hash>> groupByRoot(@NotNull List<CommitId> details) {
        if (details == null) {
            VcsCherryPickAction.$$$reportNull$$$0(5);
        }
        HashMap<VirtualFile, List<Hash>> result = new HashMap<VirtualFile, List<Hash>>();
        for (CommitId commit : details) {
            ArrayList<Hash> hashes = (ArrayList<Hash>)result.get(commit.getRoot());
            if (hashes == null) {
                hashes = new ArrayList<Hash>();
                result.put(commit.getRoot(), hashes);
            }
            hashes.add(commit.getHash());
        }
        HashMap<VirtualFile, List<Hash>> hashMap = result;
        if (hashMap == null) {
            VcsCherryPickAction.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @Nls
    @NotNull
    private static String concatActionNamesForAllAvailable(@NotNull List<? extends VcsCherryPicker> pickers) {
        if (pickers == null) {
            VcsCherryPickAction.$$$reportNull$$$0(7);
        }
        String string = StringUtil.join(pickers, VcsCherryPicker::getActionTitle, (String)"/");
        if (string == null) {
            VcsCherryPickAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static List<VcsCherryPicker> getActiveCherryPickersForProject(@Nullable Project project) {
        if (project != null) {
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            Object[] vcss = projectLevelVcsManager.getAllActiveVcss();
            List list = ContainerUtil.mapNotNull((Object[])vcss, vcs -> vcs != null ? VcsCherryPickManager.getInstance(project).getCherryPickerFor(vcs.getKeyInstanceMethod()) : null);
            if (list == null) {
                VcsCherryPickAction.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VcsCherryPickAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/cherrypick/VcsCherryPickAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cherryPickers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pickers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "concatActionNamesForAllAvailable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveCherryPickersForProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveCherryPicker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "concatActionNamesForAllAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

