/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.index.JSImplicitElementsIndexFileTypeProvider;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSImplicitElementsIndex
extends FileBasedIndexExtension<String, Collection<JSElementProxy>> {
    public static final ID<String, Collection<JSElementProxy>> INDEX_ID = ID.create((String)"js.implicit.elements.index");
    private final DataIndexer<String, Collection<JSElementProxy>, FileContent> myIndexer = new DataIndexer<String, Collection<JSElementProxy>, FileContent>(){

        @NotNull
        public Map<String, Collection<JSElementProxy>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            Map<String, Collection<JSElementProxy>> map2 = JSIndexContent.indexFile(inputData).getImplicitElements();
            if (map2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public ID<String, Collection<JSElementProxy>> getName() {
        ID<String, Collection<JSElementProxy>> iD = INDEX_ID;
        if (iD == null) {
            JSImplicitElementsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<JSElementProxy>, FileContent> getIndexer() {
        DataIndexer<String, Collection<JSElementProxy>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JSImplicitElementsIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JSImplicitElementsIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<JSElementProxy>> getValueExternalizer() {
        return new DataExternalizer<Collection<JSElementProxy>>(){

            public void save(@NotNull DataOutput out, Collection<JSElementProxy> value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)0);
                    return;
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (JSElementProxy proxy : value) {
                    proxy.serialize(out);
                }
            }

            public Collection<JSElementProxy> read(@NotNull DataInput in) throws IOException {
                int size;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((size = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
                    return null;
                }
                ArrayList<JSElementProxy> result2 = new ArrayList<JSElementProxy>(size);
                for (int i = 0; i < size; ++i) {
                    JSElementProxy proxy = JSElementProxy.deserialize(in);
                    result2.add(proxy);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/index/JSImplicitElementsIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(((List)JSImplicitElementsIndexFileTypeProvider.FILE_TYPES.getValue()).toArray(FileType.EMPTY_ARRAY));
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return JSFileElementType.getVersion(3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/index/JSImplicitElementsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class JSElementProxy {
        private final int myOffset;
        private final JSImplicitElementImpl.Builder myElement;

        public JSElementProxy(JSImplicitElementImpl.Builder builder2, int offset) {
            assert (builder2.getProvider() == null) : "provider must be null to have equal deserialized elements";
            this.myElement = builder2;
            this.myOffset = offset;
        }

        @NotNull
        public JSOffsetBasedImplicitElement toOffsetBasedImplicitElement(@NotNull PsiFile file) {
            if (file == null) {
                JSElementProxy.$$$reportNull$$$0(0);
            }
            return new JSOffsetBasedImplicitElement(this.myElement.copy(), this.myOffset, file);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSElementProxy proxy = (JSElementProxy)o;
            if (this.myOffset != proxy.myOffset) {
                return false;
            }
            return this.myElement.equals(proxy.myElement);
        }

        public int hashCode() {
            int result2 = this.myOffset;
            result2 = 31 * result2 + this.myElement.hashCode();
            return result2;
        }

        public void serialize(DataOutput out) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOffset);
            this.myElement.toImplicitElement().getStructure().serialize(out);
        }

        public static JSElementProxy deserialize(DataInput in) throws IOException {
            int offset = DataInputOutputUtil.readINT((DataInput)in);
            JSImplicitElementStructureImpl element = JSImplicitElementStructureImpl.deserialize(in);
            JSImplicitElementImpl.Builder builder2 = element.toBuilder();
            return new JSElementProxy(builder2, offset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$JSElementProxy", "toOffsetBasedImplicitElement"));
        }
    }

    public static final class Holder {
        public static boolean containFileType(FileType type2) {
            return ((List)JSImplicitElementsIndexFileTypeProvider.FILE_TYPES.getValue()).contains(type2);
        }
    }
}

