/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001BG\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00012\u0016\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J \u0010\"\u001a\u00020\u00012\u0016\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "xLim", "Lkotlin/Pair;", "", "yLim", "flipped", "", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "(Lkotlin/Pair;Lkotlin/Pair;ZLorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;)V", "getFlipped", "()Z", "isLinear", "isPolar", "getProjection", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "getXLim", "()Lkotlin/Pair;", "getYLim", "adjustDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "dataDomain", "adjustXYDomains", "xDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yDomain", "createCoordinateMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "withXlimOverride", "xlimOverride", "withYlimOverride", "ylimOverride", "plot-builder"})
public abstract class CoordProviderBase
implements CoordProvider {
    @NotNull
    private final Pair<Double, Double> xLim;
    @NotNull
    private final Pair<Double, Double> yLim;
    private final boolean flipped;
    @NotNull
    private final Projection projection;
    private final boolean isLinear;
    private final boolean isPolar;

    /*
     * Unable to fully structure code
     */
    public CoordProviderBase(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean flipped, @NotNull Projection projection) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        super();
        this.xLim = xLim;
        this.yLim = yLim;
        this.flipped = flipped;
        this.projection = projection;
        if (this.xLim.getFirst() == null || this.xLim.getSecond() == null) ** GOTO lbl-1000
        v0 = this.xLim.getSecond();
        Intrinsics.checkNotNull((Object)v0);
        v1 = ((Number)v0).doubleValue();
        v2 = this.xLim.getFirst();
        Intrinsics.checkNotNull((Object)v2);
        if (v1 > ((Number)v2).doubleValue()) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        if (!v3) {
            $i$a$-require-CoordProviderBase$1 = false;
            $i$a$-require-CoordProviderBase$1 = "Invalid coord x-limits: " + this.xLim + ' ';
            throw new IllegalArgumentException($i$a$-require-CoordProviderBase$1.toString());
        }
        if (this.yLim.getFirst() == null || this.yLim.getSecond() == null) ** GOTO lbl-1000
        v4 = this.yLim.getSecond();
        Intrinsics.checkNotNull((Object)v4);
        v5 = ((Number)v4).doubleValue();
        v6 = this.yLim.getFirst();
        Intrinsics.checkNotNull((Object)v6);
        if (v5 > ((Number)v6).doubleValue()) lbl-1000:
        // 2 sources

        {
            v7 = true;
        } else {
            v7 = false;
        }
        if (!v7) {
            $i$a$-require-CoordProviderBase$2 = false;
            var5_8 = "Invalid coord y-limits: " + this.yLim;
            throw new IllegalArgumentException(var5_8.toString());
        }
        this.isLinear = this.projection.getNonlinear() == false;
    }

    public /* synthetic */ CoordProviderBase(Pair pair2, Pair pair3, boolean bl, Projection projection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            projection = ProjectionsKt.identity();
        }
        this((Pair<Double, Double>)pair2, (Pair<Double, Double>)pair3, bl, projection);
    }

    @NotNull
    protected final Pair<Double, Double> getXLim() {
        return this.xLim;
    }

    @NotNull
    protected final Pair<Double, Double> getYLim() {
        return this.yLim;
    }

    @Override
    public boolean getFlipped() {
        return this.flipped;
    }

    @NotNull
    protected final Projection getProjection() {
        return this.projection;
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    @NotNull
    public CoordProvider withXlimOverride(@NotNull Pair<Double, Double> xlimOverride) {
        Double d;
        Intrinsics.checkNotNullParameter(xlimOverride, (String)"xlimOverride");
        if (xlimOverride.getFirst() == null && xlimOverride.getSecond() == null) {
            return this;
        }
        Double d2 = (Double)xlimOverride.getFirst();
        if (d2 == null) {
            d2 = (Double)this.xLim.getFirst();
        }
        if ((d = (Double)xlimOverride.getSecond()) == null) {
            d = (Double)this.xLim.getSecond();
        }
        Pair newXLim = new Pair((Object)d2, (Object)d);
        return this.with((Pair<Double, Double>)newXLim, this.yLim, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordProvider withYlimOverride(@NotNull Pair<Double, Double> ylimOverride) {
        Double d;
        Intrinsics.checkNotNullParameter(ylimOverride, (String)"ylimOverride");
        if (ylimOverride.getFirst() == null && ylimOverride.getSecond() == null) {
            return this;
        }
        Double d2 = (Double)ylimOverride.getFirst();
        if (d2 == null) {
            d2 = (Double)this.xLim.getFirst();
        }
        if ((d = (Double)ylimOverride.getSecond()) == null) {
            d = (Double)this.xLim.getSecond();
        }
        Pair newYLim = new Pair((Object)d2, (Object)d);
        return this.with(this.xLim, (Pair<Double, Double>)newYLim, this.getFlipped());
    }

    @Override
    @NotNull
    public final DoubleRectangle adjustDomain(@NotNull DoubleRectangle dataDomain) {
        Intrinsics.checkNotNullParameter((Object)dataDomain, (String)"dataDomain");
        Double d = (Double)this.xLim.getFirst();
        Double d2 = (Double)this.xLim.getSecond();
        DoubleSpan xSpan = new DoubleSpan(d != null ? d.doubleValue() : dataDomain.getLeft(), d2 != null ? d2.doubleValue() : dataDomain.getRight());
        Double d3 = (Double)this.yLim.getFirst();
        Double d4 = (Double)this.yLim.getSecond();
        DoubleSpan ySpan = new DoubleSpan(d3 != null ? d3.doubleValue() : dataDomain.getTop(), d4 != null ? d4.doubleValue() : dataDomain.getBottom());
        return this.adjustXYDomains(xSpan, ySpan);
    }

    @NotNull
    protected DoubleRectangle adjustXYDomains(@NotNull DoubleSpan xDomain, @NotNull DoubleSpan yDomain) {
        Intrinsics.checkNotNullParameter((Object)xDomain, (String)"xDomain");
        Intrinsics.checkNotNullParameter((Object)yDomain, (String)"yDomain");
        DoubleRectangle dataDomain = new DoubleRectangle(xDomain, yDomain);
        DoubleRectangle validDomain = this.projection.validDomain().intersect(dataDomain);
        if (validDomain == null || !(validDomain.getHeight() > 0.0) || !(validDomain.getWidth() > 0.0)) {
            throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("Can't create a valid domain.\n                |  data bbox: " + dataDomain + "\n                |  x-lim: " + this.xLim + "\n                |  y-lim: " + this.yLim + "\n            "), null, (int)1, null));
        }
        return validDomain;
    }

    @Override
    @NotNull
    public CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        return CoordinatesMapper.Companion.create(adjustedDomain, clientSize, this.projection, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordinateSystem createCoordinateSystem(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        return CoordProvider.DefaultImpls.createCoordinateSystem(this, adjustedDomain, clientSize);
    }
}

