/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataBoundsFix;
import org.jetbrains.letsPlot.core.plot.builder.interact.context.DataSelectionStrategy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/MouseWheelSelectionStrategy;", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/context/DataSelectionStrategy;", "()V", "clientRectToDataBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clientRect", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "plot-builder"})
public final class MouseWheelSelectionStrategy
implements DataSelectionStrategy {
    @Override
    @NotNull
    public DoubleRectangle clientRectToDataBounds(@NotNull DoubleRectangle clientRect, @NotNull CoordinateSystem coord) {
        Intrinsics.checkNotNullParameter((Object)clientRect, (String)"clientRect");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        DoubleVector doubleVector = coord.fromClient(clientRect.getOrigin());
        if (doubleVector == null) {
            throw new IllegalStateException(("Can't translate client " + clientRect.getOrigin() + " to data domain.").toString());
        }
        DoubleVector domainPoint0 = doubleVector;
        DoubleVector clientBottomRight = clientRect.getOrigin().add(clientRect.getDimension());
        DoubleVector doubleVector2 = coord.fromClient(clientBottomRight);
        if (doubleVector2 == null) {
            throw new IllegalStateException(("Can't translate client " + clientBottomRight + " to data domain.").toString());
        }
        DoubleVector domainPoint1 = doubleVector2;
        DoubleRectangle it = DoubleRectangle.Companion.span(domainPoint0, domainPoint1);
        boolean bl = false;
        DoubleRectangle dataBounds = DataBoundsFix.INSTANCE.unImplode(it);
        return dataBounds;
    }
}

