/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsRequestLevel;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import com.jetbrains.thinclient.services.ThinClientPermissionInteractionManager;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/thinclient/terminal/NoAccessTab;", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "settingsProvider", "Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/JBTerminalSystemSettingsProvider;Lcom/intellij/openapi/Disposable;)V", "panel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "kotlin.jvm.PlatformType", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "getComponent", "Ljavax/swing/JComponent;", "updateEmptyText", "", "isForFollowing", "", "updateEmptyText$intellij_terminal_frontend_split", "intellij.terminal.frontend.split"})
public final class NoAccessTab
extends ShellTerminalWidget {
    private final JBPanelWithEmptyText panel;

    public NoAccessTab(@NotNull Project project, @NotNull JBTerminalSystemSettingsProvider settingsProvider, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, settingsProvider, parent);
        this.panel = (JBPanelWithEmptyText)new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withBorder((Border)JBUI.Borders.empty());
        NoAccessTab.updateEmptyText$intellij_terminal_frontend_split$default(this, false, 1, null);
    }

    @NotNull
    public JComponent getComponent() {
        JBPanelWithEmptyText jBPanelWithEmptyText = this.panel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"panel");
        return (JComponent)jBPanelWithEmptyText;
    }

    public final void updateEmptyText$intellij_terminal_frontend_split(boolean isForFollowing) {
        this.panel.getEmptyText().clear();
        Pair pair = !ThinClientPermissionHost.Companion.getInstance().hasReadAccessToTerminal() ? TuplesKt.to((Object)CodeWithMeFrontendBundle.INSTANCE.message("terminal.message.access.denied.label", new Object[0]), (Object)true) : (isForFollowing ? TuplesKt.to((Object)CodeWithMeFrontendBundle.INSTANCE.message("terminal.session.unavailable", new Object[0]), (Object)false) : TuplesKt.to((Object)CodeWithMeFrontendBundle.INSTANCE.message("terminal.creation.is.not.allowed.label", new Object[0]), (Object)true));
        String reason = (String)pair.component1();
        boolean shouldShowAskingAction = (Boolean)pair.component2();
        this.panel.getEmptyText().appendLine(reason);
        if (shouldShowAskingAction) {
            this.panel.getEmptyText().appendLine(CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.tooltip", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, NoAccessTab::updateEmptyText$lambda$0);
        }
    }

    public static /* synthetic */ void updateEmptyText$intellij_terminal_frontend_split$default(NoAccessTab noAccessTab, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        noAccessTab.updateEmptyText$intellij_terminal_frontend_split(bl);
    }

    private static final void updateEmptyText$lambda$0(ActionEvent it) {
        ThinClientPermissionInteractionManager.Companion.askForPermissions(PermissionsRequestLevel.FULL_ACCESS, "ToolwindowContent");
    }
}

