/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.daemon;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/daemon/TextAttributesKeysStorage;", "", "<init>", "()V", "keysCache", "Ljava/util/HashMap;", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lkotlin/collections/HashMap;", "preloadedPlatformKeys", "", "register", "modelKey", "preloadPlatformKeys", "", "registerKeysSausage", "model", "printKeysSausage", "", "key", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nTextAttributesKeysStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextAttributesKeysStorage.kt\ncom/jetbrains/rd/platform/daemon/TextAttributesKeysStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n1#2:82\n15#3:83\n*S KotlinDebug\n*F\n+ 1 TextAttributesKeysStorage.kt\ncom/jetbrains/rd/platform/daemon/TextAttributesKeysStorage\n*L\n18#1:83\n*E\n"})
public final class TextAttributesKeysStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<TextAttributesKeyModel, TextAttributesKey> keysCache = new HashMap();
    private boolean preloadedPlatformKeys;
    @NotNull
    private static final Logger logger;

    @NotNull
    public final TextAttributesKey register(@NotNull TextAttributesKeyModel modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        if (!this.preloadedPlatformKeys) {
            this.preloadPlatformKeys();
            this.preloadedPlatformKeys = true;
        }
        return this.registerKeysSausage(modelKey);
    }

    private final void preloadPlatformKeys() {
        for (ColorSettingsPage colorSettingsPage : (ColorSettingsPage[])ColorSettingsPage.EP_NAME.getExtensions()) {
            List list = ColorSettingsUtil.getAllAttributeDescriptors((ColorAndFontDescriptorsProvider)((ColorAndFontDescriptorsProvider)colorSettingsPage));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttributeDescriptors(...)");
            CollectionsKt.toList((Iterable)list);
        }
    }

    private final TextAttributesKey registerKeysSausage(TextAttributesKeyModel model) {
        TextAttributesKey textAttributesKey;
        TextAttributesKey fallbackKey;
        TextAttributesKeyModel fallbackKeyModel;
        TextAttributesKey textAttributesKey2 = this.keysCache.get(model);
        if (textAttributesKey2 != null) {
            TextAttributesKey it = textAttributesKey2;
            boolean bl = false;
            return it;
        }
        IdeaTextAttributesKey ideaTextAttributesKey = model instanceof IdeaTextAttributesKey ? (IdeaTextAttributesKey)model : null;
        TextAttributesKeyModel textAttributesKeyModel = fallbackKeyModel = ideaTextAttributesKey != null ? ideaTextAttributesKey.getFallback() : null;
        TextAttributesKey textAttributesKey3 = fallbackKey = textAttributesKeyModel != null ? this.registerKeysSausage(textAttributesKeyModel) : null;
        if (fallbackKey == null) {
            textAttributesKey = TextAttributesKey.createTextAttributesKey((String)model.getExternalName());
        } else {
            TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)model.getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(...)");
            TextAttributesKey probablyExistingKey = textAttributesKey4;
            if (probablyExistingKey.getFallbackAttributeKey() != null) {
                textAttributesKey = probablyExistingKey;
            } else {
                TextAttributesKey textAttributesKey5 = TextAttributesKey.createTextAttributesKey((String)model.getExternalName(), (TextAttributesKey)fallbackKey);
                Intrinsics.checkNotNull((Object)textAttributesKey5);
                textAttributesKey = textAttributesKey5;
            }
        }
        TextAttributesKey textAttributesKey6 = textAttributesKey;
        Intrinsics.checkNotNull((Object)textAttributesKey6);
        TextAttributesKey resultTextAttributesKey = textAttributesKey6;
        if (resultTextAttributesKey.getFallbackAttributeKey() != null && fallbackKey != null && !Intrinsics.areEqual((Object)resultTextAttributesKey.getFallbackAttributeKey(), (Object)fallbackKey)) {
            logger.warn("Fallback keys sausage was not registered properly for TextAttributesKey " + resultTextAttributesKey + ": keys sausage for actual registered key = " + this.printKeysSausage(resultTextAttributesKey) + ", keys sausage for model fallback key = " + this.printKeysSausage(fallbackKey));
        }
        ((Map)this.keysCache).put(model, resultTextAttributesKey);
        return resultTextAttributesKey;
    }

    private final String printKeysSausage(TextAttributesKey key) {
        TextAttributesKey textAttributesKey = key;
        return textAttributesKey == null ? "null" : textAttributesKey + "-->" + this.printKeysSausage(key.getFallbackAttributeKey());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TextAttributesKeysStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TextAttributesKeysStorage.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/daemon/TextAttributesKeysStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

