/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor;

import com.intellij.formatting.FormattingMode;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedLineIndentProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/py/editor/JupyterLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "<init>", "()V", "isTestMode", "", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "intellij.jupyter.py"})
public final class JupyterLineIndentProvider
implements LineIndentProvider {
    private final boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();

    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        boolean isConsoleEditor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean bl = isConsoleEditor = !this.isTestMode && editor.getEditorKind() == EditorKind.UNTYPED;
        if (language == null || !Intrinsics.areEqual((Object)editor.getVirtualFile().getExtension(), (Object)JupyterFileType.INSTANCE.getDefaultExtension()) || isConsoleEditor) {
            return (String)WriteIntentReadAction.compute(() -> JupyterLineIndentProvider.getLineIndent$lambda$0(project, editor, language, offset));
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        NotebookCellLines.Interval cell = NotebookVisualizationUiUtilKt.getCellByOffset((Editor)editor, (int)offset);
        CharSequence text = NotebookCellLinesUtilsKt.getContentText((Document)document2, (NotebookCellLines.Interval)cell);
        PsiFile psiFile2 = PsiFileFactory.getInstance((Project)project).createFileFromText("cell.py", (FileType)PythonFileType.INSTANCE, text);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"createFileFromText(...)");
        PsiFile psiFile3 = psiFile2;
        int offSetOfCell = document2.getLineStartOffset(cell.getFirstContentLine());
        return CodeStyleManager.getInstance((Project)project).getLineIndent(psiFile3, offset - offSetOfCell, FormattingMode.ADJUST_INDENT_ON_ENTER);
    }

    public boolean isSuitableFor(@Nullable Language language) {
        Language language2 = language;
        return language2 != null ? language2.isKindOf((Language)PythonLanguage.INSTANCE) : false;
    }

    private static final String getLineIndent$lambda$0(Project $project, Editor $editor, Language $language, int $offset) {
        return new FormatterBasedLineIndentProvider().getLineIndent($project, $editor, $language, $offset);
    }
}

