/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.hub;

import com.intellij.llmInstaller.AiAutoEnableManager;
import com.intellij.llmInstaller.InstallationState;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.UtilsKt;
import com.intellij.llmInstaller.ui.hub.AIAssistantHubExtension;
import com.intellij.llmInstaller.ui.hub.AIHubNotInstalledManager;
import com.intellij.llmInstaller.ui.hub.states.AIHubIncompatibleAssistant;
import com.intellij.llmInstaller.ui.hub.states.AIHubNotInstalled;
import com.intellij.llmInstaller.ui.hub.statistics.AIHubInstallerLogger;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.popup.WizardPopup;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/llmInstaller/ui/hub/DefaultAIAssistantHubExtension;", "Lcom/intellij/llmInstaller/ui/hub/AIAssistantHubExtension;", "<init>", "()V", "getContentActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "getContent", "Ljavax/swing/JComponent;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "actionGroupContent", "updatePresentation", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.llmInstaller"})
final class DefaultAIAssistantHubExtension
implements AIAssistantHubExtension {
    @Override
    @NotNull
    public ActionGroup getContentActionGroup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String groupId = "AIHub.NotInstalled";
        ActionGroup actionGroup = ActionUtil.getActionGroup((String)groupId);
        if (actionGroup == null) {
            throw new IllegalStateException("Action group " + groupId + " not found");
        }
        return actionGroup;
    }

    @Override
    @NotNull
    public JComponent getContent(@NotNull Project project, @NotNull WizardPopup popup2, @NotNull JComponent actionGroupContent) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)actionGroupContent, (String)"actionGroupContent");
        AIHubInstallerLogger.INSTANCE.logHubInstallerIconClicked(project);
        if (UtilsKt.getLLMPluginInstallationState() == InstallationState.ENABLED) {
            jComponent = new AIHubIncompatibleAssistant(project, popup2).getContent();
        } else {
            Runnable enableAction = () -> DefaultAIAssistantHubExtension.getContent$lambda$0(project);
            jComponent = new AIHubNotInstalled(project, popup2, enableAction, actionGroupContent).getContent();
        }
        return jComponent;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setText(LLMInstallerBundle.INSTANCE.message("ai.hub.tooltip.text", new Object[0]));
        presentation.setDescription(LLMInstallerBundle.INSTANCE.message("ai.hub.tooltip.description", new Object[0]));
        AIHubNotInstalledManager.Companion.getInstance();
    }

    private static final void getContent$lambda$0(Project $project) {
        AIHubInstallerLogger.INSTANCE.logLetsGoButtonClicked($project);
        AiAutoEnableManager.launchAutoEnable$default(AiAutoEnableManager.Companion.getInstance($project), false, 1, null);
    }
}

