/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"getConfirmedPackages", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "packageNames", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.community.impl"})
public final class PyPackageInstallUtilsKt {
    @NotNull
    public static final Set<PyRequirement> getConfirmedPackages(@NotNull List<? extends PyRequirement> packageNames, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean confirmationEnabled = PropertiesComponent.getInstance().getBoolean("python.confirm.package.installation", true);
        if (!confirmationEnabled || packageNames.isEmpty()) {
            return CollectionsKt.toSet((Iterable)packageNames);
        }
        PyChooseRequirementsDialog<? extends PyRequirement> dialog2 = new PyChooseRequirementsDialog<PyRequirement>(project, packageNames, PyPackageInstallUtilsKt::getConfirmedPackages$lambda$0);
        if (!dialog2.showAndGet()) {
            PyPackagesUsageCollector.installAllCanceledEvent.log();
            return SetsKt.emptySet();
        }
        return CollectionsKt.toSet((Iterable)dialog2.getMarkedElements());
    }

    private static final String getConfirmedPackages$lambda$0(PyRequirement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentableTextWithoutVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableTextWithoutVersion(...)");
        return string;
    }
}

