/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split.diff;

import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\f\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/vcs/backend/split/diff/DiffRequestDirectTransferEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "file", "Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "processor", "Lcom/intellij/diff/impl/DiffEditorViewer;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/diff/editor/DiffViewerVirtualFile;Lcom/intellij/diff/impl/DiffEditorViewer;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getFile", "()Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "getProcessor", "()Lcom/intellij/diff/impl/DiffEditorViewer;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "isValid", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "intellij.platform.vcs.backend.split"})
final class DiffRequestDirectTransferEditor
extends FileEditorBase {
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final DiffViewerVirtualFile file;
    @NotNull
    private final DiffEditorViewer processor;

    public DiffRequestDirectTransferEditor(@NotNull ClientProjectSession session, @NotNull DiffViewerVirtualFile file, @NotNull DiffEditorViewer processor) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.session = session;
        this.file = file;
        this.processor = processor;
        Disposer.register((Disposable)((Disposable)this.processor.getDisposable()), () -> DiffRequestDirectTransferEditor._init_$lambda$0(this));
        this.processor.fireProcessorActivated();
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final DiffViewerVirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final DiffEditorViewer getProcessor() {
        return this.processor;
    }

    public void dispose() {
        Runnable explicitDisposable = (Runnable)this.processor.getContext().getUserData(DiffUserDataKeysEx.DIFF_IN_EDITOR_WITH_EXPLICIT_DISPOSABLE);
        if (explicitDisposable != null) {
            explicitDisposable.run();
        } else {
            Disposer.dispose((Disposable)((Disposable)this.processor.getDisposable()));
        }
        super.dispose();
    }

    @NotNull
    public JComponent getComponent() {
        return new JLabel(this.toString());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public boolean isValid() {
        return !Disposer.isDisposed((Disposable)((Disposable)this)) && !this.processor.getDisposable().isDisposed();
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final void _init_$lambda$0(DiffRequestDirectTransferEditor this$0) {
        String string = FileEditor.getPropValid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropValid(...)");
        this$0.firePropertyChange(string, true, false);
    }
}

