/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.RunAutomaton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/swagger/core/index/SwTokenSearchParameters;", "", "searchedKeys", "", "", "onlyTopLevel", "", "<init>", "(Ljava/util/Set;Z)V", "getSearchedKeys", "()Ljava/util/Set;", "getOnlyTopLevel", "()Z", "automaton", "Ldk/brics/automaton/RunAutomaton;", "mayContainKey", "text", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nswLexerBasedSpecificationRecognition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 swLexerBasedSpecificationRecognition.kt\ncom/intellij/swagger/core/index/SwTokenSearchParameters\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,95:1\n37#2:96\n36#2,3:97\n*S KotlinDebug\n*F\n+ 1 swLexerBasedSpecificationRecognition.kt\ncom/intellij/swagger/core/index/SwTokenSearchParameters\n*L\n18#1:96\n18#1:97,3\n*E\n"})
public final class SwTokenSearchParameters {
    @NotNull
    private final Set<String> searchedKeys;
    private final boolean onlyTopLevel;
    @NotNull
    private final RunAutomaton automaton;

    public SwTokenSearchParameters(@NotNull Set<String> searchedKeys, boolean onlyTopLevel) {
        Intrinsics.checkNotNullParameter(searchedKeys, (String)"searchedKeys");
        this.searchedKeys = searchedKeys;
        this.onlyTopLevel = onlyTopLevel;
        Collection $this$toTypedArray$iv = this.searchedKeys;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        this.automaton = new RunAutomaton(BasicAutomata.makeStringUnion((CharSequence[])Arrays.copyOf(stringArray, stringArray.length)));
    }

    @NotNull
    public final Set<String> getSearchedKeys() {
        return this.searchedKeys;
    }

    public final boolean getOnlyTopLevel() {
        return this.onlyTopLevel;
    }

    public final boolean mayContainKey(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.automaton.newMatcher(text).find();
    }

    @NotNull
    public final Set<String> component1() {
        return this.searchedKeys;
    }

    public final boolean component2() {
        return this.onlyTopLevel;
    }

    @NotNull
    public final SwTokenSearchParameters copy(@NotNull Set<String> searchedKeys, boolean onlyTopLevel) {
        Intrinsics.checkNotNullParameter(searchedKeys, (String)"searchedKeys");
        return new SwTokenSearchParameters(searchedKeys, onlyTopLevel);
    }

    public static /* synthetic */ SwTokenSearchParameters copy$default(SwTokenSearchParameters swTokenSearchParameters, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = swTokenSearchParameters.searchedKeys;
        }
        if ((n & 2) != 0) {
            bl = swTokenSearchParameters.onlyTopLevel;
        }
        return swTokenSearchParameters.copy(set, bl);
    }

    @NotNull
    public String toString() {
        return "SwTokenSearchParameters(searchedKeys=" + this.searchedKeys + ", onlyTopLevel=" + this.onlyTopLevel + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.searchedKeys).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.onlyTopLevel);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwTokenSearchParameters)) {
            return false;
        }
        SwTokenSearchParameters swTokenSearchParameters = (SwTokenSearchParameters)other;
        if (!Intrinsics.areEqual(this.searchedKeys, swTokenSearchParameters.searchedKeys)) {
            return false;
        }
        return this.onlyTopLevel == swTokenSearchParameters.onlyTopLevel;
    }
}

