/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.DbmsExtension;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface DomainRegistry {
    public static final DbmsExtension<DomainRegistry> EP = new DbmsExtension("com.intellij.database.domainRegistry");
    public static final Function<Domain, Comparator<Domain>> COMPARATOR_GENERATOR = domain -> (o1, o2) -> {
        Compatibility first2 = o1.getCompatibility((Domain)domain);
        Compatibility second = o2.getCompatibility((Domain)domain);
        return first2.compareTo(second);
    };

    @Nullable
    public Domain getDomain(@NotNull ColumnDescriptor var1);

    @NotNull
    public @Unmodifiable Collection<Domain> getDomains();

    public static class VersionedDomainRegistry
    implements DomainRegistry {
        private final DomainRegistry myDelegate;
        private final Version myVersion;

        public VersionedDomainRegistry(@NotNull DomainRegistry delegate, @NotNull Version version) {
            if (delegate == null) {
                VersionedDomainRegistry.$$$reportNull$$$0(0);
            }
            if (version == null) {
                VersionedDomainRegistry.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myVersion = version;
        }

        @Override
        @Nullable
        public Domain getDomain(@NotNull ColumnDescriptor descriptor2) {
            if (descriptor2 == null) {
                VersionedDomainRegistry.$$$reportNull$$$0(2);
            }
            return (Domain)ContainerUtil.find(this.myDelegate.getDomains(), domain -> domain.isSuitable(descriptor2) && domain.supportedIn(this.myVersion));
        }

        @Override
        @NotNull
        public @Unmodifiable Collection<Domain> getDomains() {
            List list = ContainerUtil.filter(this.myDelegate.getDomains(), domain -> domain.supportedIn(this.myVersion));
            if (list == null) {
                VersionedDomainRegistry.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DomainRegistry$VersionedDomainRegistry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DomainRegistry$VersionedDomainRegistry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDomains";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDomain";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class CommonLimits {
        public static final double BIGINT_UNSIGNED_MAX = Math.pow(2.0, 64.0) - 1.0;
    }

    public static class Limits {
        private final Limit[] myLimits;

        public Limits(Limit ... limits) {
            if (limits == null) {
                Limits.$$$reportNull$$$0(0);
            }
            this.myLimits = limits;
            Arrays.sort(this.myLimits);
        }

        @NotNull
        public Number minValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(1);
            }
            return this.get(parameterValue, (Function<Limit, Number>)((Function)Limit::getMinValue));
        }

        @NotNull
        public Number maxValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(2);
            }
            return this.get(parameterValue, (Function<Limit, Number>)((Function)Limit::getMaxValue));
        }

        @NotNull
        public Number min() {
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMinValue();
            if (number == null) {
                Limits.$$$reportNull$$$0(3);
            }
            return number;
        }

        @NotNull
        public Number max() {
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxValue();
            if (number == null) {
                Limits.$$$reportNull$$$0(4);
            }
            return number;
        }

        @NotNull
        public Number parameterValueFromMax(@NotNull Number maxValue) {
            if (maxValue == null) {
                Limits.$$$reportNull$$$0(5);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxValue().doubleValue(), maxValue.doubleValue()) < 0) continue;
                Number number = limit.getMaxParameter();
                if (number == null) {
                    Limits.$$$reportNull$$$0(6);
                }
                return number;
            }
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxParameter();
            if (number == null) {
                Limits.$$$reportNull$$$0(7);
            }
            return number;
        }

        @NotNull
        public Number minParameterValue(@NotNull Number parameterValue) {
            if (parameterValue == null) {
                Limits.$$$reportNull$$$0(8);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxParameter().doubleValue(), parameterValue.doubleValue()) < 0) continue;
                Number number = limit.getMaxParameter();
                if (number == null) {
                    Limits.$$$reportNull$$$0(9);
                }
                return number;
            }
            Number number = Objects.requireNonNull((Limit)ArrayUtil.getLastElement((Object[])this.myLimits)).getMaxParameter();
            if (number == null) {
                Limits.$$$reportNull$$$0(10);
            }
            return number;
        }

        @NotNull
        private Number get(@NotNull Number parameter, @NotNull Function<Limit, Number> getter) {
            if (parameter == null) {
                Limits.$$$reportNull$$$0(11);
            }
            if (getter == null) {
                Limits.$$$reportNull$$$0(12);
            }
            for (Limit limit : this.myLimits) {
                if (Double.compare(limit.getMaxParameter().doubleValue(), parameter.doubleValue()) < 0) continue;
                Number number = (Number)getter.fun((Object)limit);
                if (number == null) {
                    Limits.$$$reportNull$$$0(13);
                }
                return number;
            }
            Number number = (Number)getter.fun((Object)((Limit)ArrayUtil.getFirstElement((Object[])this.myLimits)));
            if (number == null) {
                Limits.$$$reportNull$$$0(14);
            }
            return number;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 7, 9, 10, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "limits";
                    break;
                }
                case 1: 
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DomainRegistry$Limits";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxValue";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DomainRegistry$Limits";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "min";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "max";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parameterValueFromMax";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "minParameterValue";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "minValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "maxValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parameterValueFromMax";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "minParameterValue";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6, 7, 9, 10, 13, 14 -> new IllegalStateException(string);
            };
        }
    }

    public static class Limit
    implements Comparable<Limit> {
        private final Number myMaxParameter;
        private final Number myMaxValue;
        private final Number myMinValue;

        public Limit(@NotNull Number maxParameter, @NotNull Number minValue, @NotNull Number maxValue) {
            if (maxParameter == null) {
                Limit.$$$reportNull$$$0(0);
            }
            if (minValue == null) {
                Limit.$$$reportNull$$$0(1);
            }
            if (maxValue == null) {
                Limit.$$$reportNull$$$0(2);
            }
            this.myMaxParameter = maxParameter;
            this.myMaxValue = maxValue;
            this.myMinValue = minValue;
        }

        @NotNull
        public Number getMaxParameter() {
            Number number = this.myMaxParameter;
            if (number == null) {
                Limit.$$$reportNull$$$0(3);
            }
            return number;
        }

        @NotNull
        public Number getMaxValue() {
            Number number = this.myMaxValue;
            if (number == null) {
                Limit.$$$reportNull$$$0(4);
            }
            return number;
        }

        @NotNull
        public Number getMinValue() {
            Number number = this.myMinValue;
            if (number == null) {
                Limit.$$$reportNull$$$0(5);
            }
            return number;
        }

        @Override
        public int compareTo(@NotNull Limit o) {
            if (o == null) {
                Limit.$$$reportNull$$$0(6);
            }
            return Double.compare(this.myMaxParameter.doubleValue(), o.myMaxParameter.doubleValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxParameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "minValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DomainRegistry$Limit";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DomainRegistry$Limit";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

