/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.dialects.oracle.debugger.OraBaseSession;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\tJ\u0010\u0010\"\u001a\u00020\u001e2\b\b\u0002\u0010#\u001a\u00020\rJ\u0006\u0010$\u001a\u00020\u001eJ\r\u0010%\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u001eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OraBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "requestOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/console/client/DatabaseSessionClient;)V", "value", "", "debugId", "getDebugId", "()Ljava/lang/String;", "", "underDebug", "getUnderDebug", "()Z", "turningDebugON", "getTurningDebugON", "turningDebugOFF", "getTurningDebugOFF", "executing", "getExecuting", "alteredToDebuggable", "debugImmediate", "_active", "Ljava/util/concurrent/atomic/AtomicBoolean;", "active", "getActive", "initRemote", "", "makeSessionDebuggable", "performTargetStatement", "statement", "turnDebugON", "immediate", "turnDebugOFF", "executionBegin", "executionBegin$intellij_database_dialects_oracle_ex", "executionEnded", "executionEnded$intellij_database_dialects_oracle_ex", "disconnectAndAbandonConnection", "deactivateDataSource", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraExecutingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraExecutingSession.kt\ncom/intellij/database/dialects/oracle/debugger/OraExecutingSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class OraExecutingSession
extends OraBaseSession {
    @Nullable
    private final DatabaseSessionClient requestOwner;
    @Nullable
    private String debugId;
    private volatile boolean underDebug;
    private volatile boolean turningDebugON;
    private volatile boolean turningDebugOFF;
    private volatile boolean executing;
    private boolean alteredToDebuggable;
    private boolean debugImmediate;
    @NotNull
    private final AtomicBoolean _active;

    public OraExecutingSession(@NotNull DatabaseConnection connection2, @Nullable DatabaseSessionClient requestOwner) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        super(connection2);
        this.requestOwner = requestOwner;
        this._active = new AtomicBoolean(false);
    }

    @Nullable
    public final String getDebugId() {
        return this.debugId;
    }

    public final boolean getUnderDebug() {
        return this.underDebug;
    }

    public final boolean getTurningDebugON() {
        return this.turningDebugON;
    }

    public final boolean getTurningDebugOFF() {
        return this.turningDebugOFF;
    }

    public final boolean getExecuting() {
        return this.executing;
    }

    public final boolean getActive() {
        return this._active.get();
    }

    @Override
    public void initRemote() {
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
    }

    public final void makeSessionDebuggable() {
        if (!this.alteredToDebuggable) {
            this.trace("alter session set plsql_debug = true");
            this.call("alter session set plsql_debug = true", new Object[0]);
            this.alteredToDebuggable = true;
        }
        if (this.debugId == null) {
            this.trace("sys.dbms_debug.initialize");
            this.debugId = (String)this.callFunction("sys.dbms_debug.initialize", new StringOutParam(1, 60, null, 4, null), new Object[0]);
            this.trace("Debug id: " + this.debugId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performTargetStatement(@NotNull String statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.turnDebugON(this.debugImmediate);
        this.trace("Starting the target statement");
        this._active.set(true);
        try {
            this.call(statement2, new Object[0]);
        }
        finally {
            this._active.set(false);
        }
        this.trace("The target statement is completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnDebugON(boolean immediate) {
        if (this.underDebug) {
            return;
        }
        String procedure = "sys.dbms_debug.debug_on(immediate => " + immediate + ")";
        this.trace(procedure);
        try {
            this.turningDebugON = true;
            try {
                this.callProcedure(procedure, new Object[0]);
                this.underDebug = true;
            }
            finally {
                this.turningDebugON = false;
            }
        }
        catch (Throwable exception) {
            Throwable e = OraConnectionHelperKt.unwrapException(exception);
            String message = OraConnectionHelperKt.prepareGoodMessage(e, "Cannot turn debugging ON");
            this.trace(message);
        }
    }

    public static /* synthetic */ void turnDebugON$default(OraExecutingSession oraExecutingSession, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        oraExecutingSession.turnDebugON(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnDebugOFF() {
        if (!this.underDebug) {
            return;
        }
        String procedure = "sys.dbms_debug.debug_off";
        this.trace(procedure);
        try {
            this.turningDebugOFF = true;
            try {
                this.callProcedure(procedure, new Object[0]);
                this.underDebug = false;
            }
            finally {
                this.turningDebugOFF = false;
            }
        }
        catch (Throwable exception) {
            Throwable e = OraConnectionHelperKt.unwrapException(exception);
            String message = OraConnectionHelperKt.prepareGoodMessage(e, "Cannot turn debugging OFF");
            this.trace(message);
            this.disconnectAndAbandonConnection();
        }
    }

    public final void executionBegin$intellij_database_dialects_oracle_ex() {
        this.executing = true;
    }

    public final void executionEnded$intellij_database_dialects_oracle_ex() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnectAndAbandonConnection() {
        this.trace("Disconnecting");
        try {
            this.getConnection().getRemoteConnection().close();
        }
        finally {
            this.underDebug = false;
        }
    }

    public final void deactivateDataSource() {
        boolean bl;
        boolean bl2 = bl = this.requestOwner != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cannot deactivate data source when session is not specified";
            throw new AssertionError((Object)string);
        }
        DatabaseSessionClient databaseSessionClient = this.requestOwner;
        Intrinsics.checkNotNull((Object)databaseSessionClient);
        Object s = databaseSessionClient.getSession();
        Intrinsics.checkNotNullExpressionValue(s, (String)"<get-session>(...)");
        SessionsUtil.deactivateDataSourceAsync((DatabaseSession)s);
    }
}

