/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlSideEffectsInspection
extends SqlInspectionBase {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    ExecutionFlowAnalyzer.FlowTransformer<@InspectionMessage String> TRANSFORMER = new ExecutionFlowAnalyzer.FlowTransformer<String>(){

        @InspectionMessage
        public String common() {
            return SqlBundle.message((String)"inspection.message.this.statement.may.cause.side.effects", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String dml() {
            return SqlBundle.message((String)"inspection.message.this.statement.will.lead.to.modification.data", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String ddl() {
            return SqlBundle.message((String)"inspection.message.this.statement.will.lead.to.modification.database", (Object[])new Object[0]);
        }

        @InspectionMessage
        public String routine() {
            return SqlBundle.message((String)"inspection.message.this.routine.may.cause.side.effects", (Object[])new Object[0]);
        }
    };

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            @Override
            public void visitSqlElement(SqlElement o) {
                LocalDataSource dataSource;
                super.visitSqlElement(o);
                ExecutionFlowAnalyzer analyzer = SqlPsiFacade.getInstance((Project)o.getProject()).getExecutionFlowAnalyzer(o.getLanguage());
                if (analyzer == null) {
                    return;
                }
                VirtualFile file = o.getContainingFile().getVirtualFile();
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(o.getProject(), file);
                LocalDataSource localDataSource = dataSource = console == null ? null : console.getDataSource();
                if (dataSource == null || !dataSource.isReadOnly() || !analyzer.isAcceptable((PsiElement)o)) {
                    return;
                }
                ExecutionFlowAnalyzer.Flow flow = analyzer.analyze((PsiElement)o);
                if (flow.isPure() == ThreeState.YES) {
                    return;
                }
                String reason = (String)flow.transform(TRANSFORMER);
                if (reason == null) {
                    return;
                }
                MakeDataSourceWritable fix = new MakeDataSourceWritable(dataSource);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, reason, true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[]{fix}));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MakeDataSourceWritable
    implements LocalQuickFix,
    DumbAware {
        @FileModifier.SafeFieldForPreview
        private final LocalDataSource myDataSource;

        public MakeDataSourceWritable(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(2);
            }
            this.myDataSource.setReadOnly(false);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"disable.read.only.mode", (Object[])new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 7 -> new IllegalStateException(string);
            };
        }
    }
}

