/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class ConflictMarker
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        Map stats = (Map)context.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        IdentityHashMap<DependencyNode, Object> nodes2 = new IdentityHashMap<DependencyNode, Object>(1024);
        HashMap<Object, ConflictGroup> groups = new HashMap<Object, ConflictGroup>(1024);
        this.analyze(node, nodes2, groups, new int[]{0});
        long time2 = System.nanoTime();
        Map<DependencyNode, Object> conflictIds = this.mark(nodes2.keySet(), groups);
        context.put(TransformationContextKeys.CONFLICT_IDS, conflictIds);
        if (stats != null) {
            long time3 = System.nanoTime();
            stats.put("ConflictMarker.analyzeTime", time2 - time1);
            stats.put("ConflictMarker.markTime", time3 - time2);
            stats.put("ConflictMarker.nodeCount", nodes2.size());
        }
        return node;
    }

    private void analyze(DependencyNode node, Map<DependencyNode, Object> nodes2, Map<Object, ConflictGroup> groups, int[] counter) {
        if (nodes2.put(node, Boolean.TRUE) != null) {
            return;
        }
        Set<Object> keys = this.getKeys(node);
        if (!keys.isEmpty()) {
            ConflictGroup group = null;
            boolean fixMappings = false;
            for (Object key2 : keys) {
                Set<Object> newKeys;
                ConflictGroup g = groups.get(key2);
                if (group == g) continue;
                if (group == null) {
                    newKeys = this.merge(g.keys, keys);
                    if (newKeys == g.keys) {
                        group = g;
                        break;
                    }
                    int n = counter[0];
                    counter[0] = n + 1;
                    group = new ConflictGroup(newKeys, n);
                    fixMappings = true;
                    continue;
                }
                if (g == null) {
                    fixMappings = true;
                    continue;
                }
                newKeys = this.merge(g.keys, group.keys);
                if (newKeys == g.keys) {
                    group = g;
                    fixMappings = false;
                    break;
                }
                if (newKeys == group.keys) continue;
                int n = counter[0];
                counter[0] = n + 1;
                group = new ConflictGroup(newKeys, n);
                fixMappings = true;
            }
            if (group == null) {
                int n = counter[0];
                counter[0] = n + 1;
                group = new ConflictGroup(keys, n);
                fixMappings = true;
            }
            if (fixMappings) {
                for (Object key2 : group.keys) {
                    groups.put(key2, group);
                }
            }
        }
        for (DependencyNode child : node.getChildren()) {
            this.analyze(child, nodes2, groups, counter);
        }
    }

    private Set<Object> merge(Set<Object> keys1, Set<Object> keys2) {
        int size2;
        int size1 = keys1.size();
        if (size1 < (size2 = keys2.size())) {
            if (keys2.containsAll(keys1)) {
                return keys2;
            }
        } else if (keys1.containsAll(keys2)) {
            return keys1;
        }
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(keys1);
        keys.addAll(keys2);
        return keys;
    }

    private Set<Object> getKeys(DependencyNode node) {
        Set<Object> keys;
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            keys = Collections.emptySet();
        } else {
            Object key2 = ConflictMarker.toKey(dependency.getArtifact());
            if (node.getRelocations().isEmpty() && node.getAliases().isEmpty()) {
                keys = Collections.singleton(key2);
            } else {
                keys = new HashSet<Object>();
                keys.add(key2);
                for (Artifact artifact : node.getRelocations()) {
                    key2 = ConflictMarker.toKey(artifact);
                    keys.add(key2);
                }
                for (Artifact artifact : node.getAliases()) {
                    key2 = ConflictMarker.toKey(artifact);
                    keys.add(key2);
                }
            }
        }
        return keys;
    }

    private Map<DependencyNode, Object> mark(Collection<DependencyNode> nodes2, Map<Object, ConflictGroup> groups) {
        IdentityHashMap<DependencyNode, Object> conflictIds = new IdentityHashMap<DependencyNode, Object>(nodes2.size() + 1);
        for (DependencyNode node : nodes2) {
            Dependency dependency = node.getDependency();
            if (dependency == null) continue;
            Object key2 = ConflictMarker.toKey(dependency.getArtifact());
            conflictIds.put(node, groups.get((Object)key2).index);
        }
        return conflictIds;
    }

    private static Object toKey(Artifact artifact) {
        return new Key(artifact);
    }

    static class ConflictGroup {
        final Set<Object> keys;
        final int index;

        ConflictGroup(Set<Object> keys, int index) {
            this.keys = keys;
            this.index = index;
        }

        public String toString() {
            return String.valueOf(this.keys);
        }
    }

    static class Key {
        private final Artifact artifact;

        Key(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object obj2) {
            if (obj2 == this) {
                return true;
            }
            if (!(obj2 instanceof Key)) {
                return false;
            }
            Key that = (Key)obj2;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.artifact.getArtifactId().hashCode();
            hash = hash * 31 + this.artifact.getGroupId().hashCode();
            hash = hash * 31 + this.artifact.getClassifier().hashCode();
            hash = hash * 31 + this.artifact.getExtension().hashCode();
            return hash;
        }

        public String toString() {
            return this.artifact.getGroupId() + ':' + this.artifact.getArtifactId() + ':' + this.artifact.getClassifier() + ':' + this.artifact.getExtension();
        }
    }
}

