/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class RegExpBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpBuiltin> {
    public static final TruffleString INPUT = Strings.constant("input");
    public static final JSBuiltinsContainer BUILTINS = new RegExpBuiltins();

    protected RegExpBuiltins() {
        super(JSRegExp.CLASS_NAME, RegExpBuiltin.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpBuiltin builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetInputNodeGen.create(context2, builtin, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 1: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultSetInputNodeGen.create(context2, builtin, RegExpBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 2: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context2, builtin, 0, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 3: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLastParenNodeGen.create(context2, builtin, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 4: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultLeftContextNodeGen.create(context2, builtin, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 5: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultRightContextNodeGen.create(context2, builtin, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 6: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultMultilineNodeGen.create(context2, builtin, RegExpBuiltins.args().createArgumentNodes(context2));
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return RegExpBuiltinsFactory.JSRegExpStaticResultGetGroupNodeGen.create(context2, builtin, builtinEnum.name().charAt(1) - 48, RegExpBuiltins.args().createArgumentNodes(context2));
            }
        }
        return null;
    }

    static void checkStaticRegexResultPropertyGet(JSContext context2, JSRealm realm, Object thisValue) {
        CompilerAsserts.partialEvaluationConstant(context2);
        if (!context2.isOptionV8CompatibilityMode() && (thisValue != realm.getRegExpConstructor() || realm.isRegexResultInvalidated())) {
            throw Errors.createTypeError("Static RegExp result properties cannot be used with subclasses of RegExp.");
        }
    }

    static void checkStaticRegexResultPropertySet(JSContext context2, JSRealm realm, Object thisValue) {
        CompilerAsserts.partialEvaluationConstant(context2);
        if (!context2.isOptionV8CompatibilityMode() && thisValue != realm.getRegExpConstructor()) {
            throw Errors.createTypeError("Static RegExp result properties cannot be used with subclasses of RegExp.");
        }
    }

    public static enum RegExpBuiltin implements BuiltinEnum<RegExpBuiltin>
    {
        input(0),
        set_input(1, INPUT),
        lastMatch(0),
        lastParen(0),
        leftContext(0),
        rightContext(0),
        multiline(0),
        $1(0),
        $2(0),
        $3(0),
        $4(0),
        $5(0),
        $6(0),
        $7(0),
        $8(0),
        $9(0);

        private final TruffleString key;
        private final int length;

        private RegExpBuiltin(int length2) {
            this.key = Strings.fromJavaString(this.name());
            this.length = length2;
        }

        private RegExpBuiltin(int length2, TruffleString key) {
            this.key = key;
            this.length = length2;
        }

        @Override
        public TruffleString getKey() {
            return this.key;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this.getLength() == 0;
        }

        @Override
        public boolean isSetter() {
            return this.getLength() == 1;
        }
    }

    static abstract class JSRegExpStaticResultGetInputNode
    extends JSBuiltinNode {
        JSRegExpStaticResultGetInputNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        TruffleString getInputProp(VirtualFrame frame) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj(frame));
            return this.getRealm().getStaticRegexResultInputString();
        }
    }

    static abstract class JSRegExpStaticResultSetInputNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toStringNode = JSToStringNode.create();

        JSRegExpStaticResultSetInputNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        Object setInputProp(VirtualFrame frame, Object val) {
            RegExpBuiltins.checkStaticRegexResultPropertySet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj(frame));
            this.getRealm().setStaticRegexResultInputString(this.toStringNode.executeString(val));
            return Undefined.instance;
        }
    }

    static abstract class JSRegExpStaticResultGetGroupNode
    extends JSRegExpStaticResultPropertyNode {
        private final int groupNumber;

        JSRegExpStaticResultGetGroupNode(JSContext context2, JSBuiltin builtin, int groupNumber) {
            super(context2, builtin);
            assert (groupNumber >= 0);
            this.groupNumber = groupNumber;
        }

        @Specialization
        TruffleString getGroup(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            int start2;
            JSRealm realm = this.getRealm();
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), realm, JSFrameUtil.getThisObj(frame));
            Object result2 = this.getResultNode.execute();
            if (this.isMatchResult(result2, readIsMatch) && this.groupCount(realm.getStaticRegexResultCompiledRegex(), readGroupCount) > this.groupNumber && (start2 = this.captureGroupStart(result2, this.groupNumber, getStart)) >= 0) {
                return Strings.substring(this.getContext(), substringNode, this.getInput(), start2, this.captureGroupEnd(result2, this.groupNumber, getEnd) - start2);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultLastParenNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLastParenNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        TruffleString lastParen(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            int start2;
            int groupNumber;
            JSRealm realm = this.getRealm();
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), realm, JSFrameUtil.getThisObj(frame));
            Object result2 = this.getResultNode.execute();
            if (this.isMatchResult(result2, readIsMatch) && (groupNumber = this.groupCount(realm.getStaticRegexResultCompiledRegex(), readGroupCount) - 1) > 0 && (start2 = this.captureGroupStart(result2, groupNumber, getStart)) >= 0) {
                return Strings.substring(this.getContext(), substringNode, this.getInput(), start2, this.captureGroupEnd(result2, groupNumber, getEnd) - start2);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultLeftContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultLeftContextNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        TruffleString leftContext(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj(frame));
            Object result2 = this.getResultNode.execute();
            if (this.isMatchResult(result2, readIsMatch)) {
                int start2 = this.captureGroupStart(result2, 0, getStart);
                return Strings.substring(this.getContext(), substringNode, this.getInput(), 0, start2);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultRightContextNode
    extends JSRegExpStaticResultPropertyNode {
        JSRegExpStaticResultRightContextNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        TruffleString rightContext(VirtualFrame frame, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            RegExpBuiltins.checkStaticRegexResultPropertyGet(this.getContext(), this.getRealm(), JSFrameUtil.getThisObj(frame));
            Object result2 = this.getResultNode.execute();
            if (this.isMatchResult(result2, readIsMatch)) {
                int end = this.captureGroupEnd(result2, 0, getEnd);
                return Strings.substring(this.getContext(), substringNode, this.getInput(), end);
            }
            return Strings.EMPTY_STRING;
        }
    }

    static abstract class JSRegExpStaticResultMultilineNode
    extends JSBuiltinNode {
        JSRegExpStaticResultMultilineNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization(guards={"getContext().isOptionNashornCompatibilityMode()"})
        boolean getMultilineLazyNashorn() {
            return false;
        }

        @Specialization(assumptions={"getStaticResultUnusedAssumption()"}, guards={"!getContext().isOptionNashornCompatibilityMode()"})
        boolean getMultilineLazy(@Cached @Cached.Shared(value="multiline") TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getMultilineFlag) {
            Object compiledRegex = this.getRealm().getStaticRegexResultCompiledRegex();
            if (compiledRegex != null) {
                return getMultilineFlag.execute(this, compiledRegex, "multiline");
            }
            return false;
        }

        @Specialization
        boolean getMultilineEager(@Bind(value="this") Node node, @Cached(value="create(getContext())") GetStaticRegExpResultNode getResultNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared(value="multiline") TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getMultilineFlag) {
            Object compiledRegex = this.getRealm().getStaticRegexResultCompiledRegex();
            Object result2 = getResultNode.execute();
            if (TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch) && !this.getContext().isOptionNashornCompatibilityMode()) {
                return getMultilineFlag.execute(node, compiledRegex, "multiline");
            }
            return false;
        }

        Assumption getStaticResultUnusedAssumption() {
            return this.getContext().getRegExpStaticResultUnusedAssumption();
        }
    }

    static abstract class JSRegExpStaticResultPropertyNode
    extends JSBuiltinNode {
        @Node.Child
        GetStaticRegExpResultNode getResultNode;

        JSRegExpStaticResultPropertyNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getResultNode = RegExpBuiltinsFactory.GetStaticRegExpResultNodeGen.create(context2);
        }

        protected final TruffleString getInput() {
            return this.getRealm().getStaticRegexResultOriginalInputString();
        }

        protected final boolean isMatchResult(Object result2, TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            return TRegexUtil.TRegexResultAccessor.isMatch(result2, this, readIsMatch);
        }

        protected final int groupCount(Object compiledRegex, TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            return TRegexUtil.TRegexCompiledRegexAccessor.groupCount(compiledRegex, this, readGroupCount);
        }

        protected final int captureGroupStart(Object result2, int groupNumber, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart) {
            return TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, groupNumber, this, getStart);
        }

        protected final int captureGroupEnd(Object result2, int groupNumber, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            return TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, groupNumber, this, getEnd);
        }
    }

    static abstract class GetStaticRegExpResultNode
    extends JavaScriptBaseNode {
        private final JSContext context;

        GetStaticRegExpResultNode(JSContext context2) {
            this.context = context2;
        }

        abstract Object execute();

        @Specialization
        Object get(@Cached(inline=true) TRegexUtil.InvokeExecMethodNode invokeExec) {
            return this.getRealm().getStaticRegexResult(this.context, this, invokeExec);
        }
    }
}

