/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorCompleteStepNode
extends JavaScriptBaseNode {
    @Node.Child
    protected JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
    @Node.Child
    protected CreateIterResultObjectNode createIterResultObjectNode;

    AsyncGeneratorCompleteStepNode(JSContext context2) {
        this.createIterResultObjectNode = CreateIterResultObjectNode.create(context2);
    }

    public static AsyncGeneratorCompleteStepNode create(JSContext context2) {
        return new AsyncGeneratorCompleteStepNode(context2);
    }

    public final void asyncGeneratorCompleteStep(VirtualFrame frame, Completion.Type completionType, Object completionValue, boolean done, ArrayDeque<AsyncGeneratorRequest> queue) {
        assert (!queue.isEmpty());
        AsyncGeneratorRequest next = queue.pollFirst();
        PromiseCapabilityRecord promiseCapability = next.getPromiseCapability();
        if (completionType == Completion.Type.Normal) {
            this.asyncGeneratorCompleteStepNormal(frame, completionValue, done, promiseCapability);
        } else {
            assert (completionType == Completion.Type.Throw);
            this.asyncGeneratorCompleteStepThrow(completionValue, promiseCapability);
        }
    }

    private void asyncGeneratorCompleteStepNormal(VirtualFrame frame, Object value2, boolean done, PromiseCapabilityRecord promiseCapability) {
        JSObject iterResult = this.createIterResultObjectNode.execute(frame, value2, done);
        this.callNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), iterResult));
    }

    private void asyncGeneratorCompleteStepThrow(Object value2, PromiseCapabilityRecord promiseCapability) {
        this.callNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), value2));
    }
}

