/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.impl.ModuleToUnnamedBridge;
import org.graalvm.polyglot.io.FileSystem;

final class ModuleToUnnamedIOAccessorGen
extends ModuleToUnnamedBridge.ModuleToUnnamedIOAccessor {
    private static final Handles HANDLES;
    final Object receiver;

    public ModuleToUnnamedIOAccessorGen(Object receiver) {
        this.receiver = Objects.requireNonNull(receiver);
    }

    @Override
    public Object createIOAccess(String name_, boolean allowHostFileAccess_, boolean allowSocketAccess_, FileSystem fileSystem_) {
        try {
            Object result2 = ModuleToUnnamedIOAccessorGen.HANDLES.createIOAccess_.invoke(this.receiver, name_, allowHostFileAccess_, allowSocketAccess_, ModuleToUnnamedBridge.ModuleToUnnamedIOAccessor.toFileSystem(fileSystem_));
            return result2;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    @Override
    public Exception createVetoException(String message_) {
        try {
            Exception result2 = ModuleToUnnamedIOAccessorGen.HANDLES.createVetoException_.invoke(this.receiver, message_);
            return result2;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    @Override
    public FileSystem getFileSystem(Object ioAccess_) {
        try {
            Object result2 = ModuleToUnnamedIOAccessorGen.HANDLES.getFileSystem_.invoke(this.receiver, ioAccess_);
            return ModuleToUnnamedBridge.ModuleToUnnamedIOAccessor.fromFileSystem(result2);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    @Override
    public boolean hasHostFileAccess(Object ioAccess_) {
        try {
            boolean result2 = ModuleToUnnamedIOAccessorGen.HANDLES.hasHostFileAccess_.invoke(this.receiver, ioAccess_);
            return result2;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    @Override
    public boolean hasHostSocketAccess(Object ioaccess_) {
        try {
            boolean result2 = ModuleToUnnamedIOAccessorGen.HANDLES.hasHostSocketAccess_.invoke(this.receiver, ioaccess_);
            return result2;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    @Override
    public boolean isVetoException(Throwable exception_) {
        try {
            boolean result2 = ModuleToUnnamedIOAccessorGen.HANDLES.isVetoException_.invoke(this.receiver, exception_);
            return result2;
        }
        catch (Throwable t) {
            throw ModuleToUnnamedIOAccessorGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = ModuleToUnnamedIOAccessorGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle createIOAccess_;
        private final MethodHandle createVetoException_;
        private final MethodHandle getFileSystem_;
        private final MethodHandle hasHostFileAccess_;
        private final MethodHandle hasHostSocketAccess_;
        private final MethodHandle isVetoException_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeFileSystem_ = lookup.findClass(FileSystem.class.getName());
            Class<?> typeIOAccessor = lookup.findClass(AbstractPolyglotImpl.IOAccessor.class.getName());
            this.createIOAccess_ = lookup.findVirtual(typeIOAccessor, "createIOAccess", MethodType.methodType(Object.class, List.of(String.class, Boolean.TYPE, Boolean.TYPE, typeFileSystem_)));
            this.createVetoException_ = lookup.findVirtual(typeIOAccessor, "createVetoException", MethodType.methodType(Exception.class, List.of(String.class)));
            this.getFileSystem_ = lookup.findVirtual(typeIOAccessor, "getFileSystem", MethodType.methodType(typeFileSystem_, List.of(Object.class)));
            this.hasHostFileAccess_ = lookup.findVirtual(typeIOAccessor, "hasHostFileAccess", MethodType.methodType(Boolean.TYPE, List.of(Object.class)));
            this.hasHostSocketAccess_ = lookup.findVirtual(typeIOAccessor, "hasHostSocketAccess", MethodType.methodType(Boolean.TYPE, List.of(Object.class)));
            this.isVetoException_ = lookup.findVirtual(typeIOAccessor, "isVetoException", MethodType.methodType(Boolean.TYPE, List.of(Throwable.class)));
        }
    }
}

